/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.sendmessage.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class ShareOpRecordHelper {
    private static final Log logger = LogFactory.getLog(ShareOpRecordHelper.class);

    public static ShareOpRecordHelper getInstance() {
        return Instance.SHARE_OP_RECORD_HELPER;
    }

    private ShareOpRecordHelper() {
    }

    public List<OprecordMessageModel> buildOpModel(FormShowParameter parameter) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject[] stdRsms = (DynamicObject[])parameter.getCustomParam("candidate");
        String sharerName = parameter.getCustomParam("operatorname").toString();
        Long sharerId = Long.valueOf(parameter.getCustomParam("sharerID").toString());
        Date opTime = DateUtils.nowDateTime();
        List receiverList = (List)parameter.getCustomParam("receiver");
        List receiverNameList = receiverList.stream().map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toList());
        String receiversName = String.join((CharSequence)"\u3001", receiverNameList) + "\u3002";
        for (DynamicObject stdRsm : stdRsms) {
            OprecordMessageModel oprecordMessageModel = new OprecordMessageModel();
            oprecordMessageModel.setOperator(sharerId);
            oprecordMessageModel.setOperatorname(sharerName);
            oprecordMessageModel.setBizobjname(stdRsm.get("fullname").toString());
            oprecordMessageModel.setBizentry("tstpm_stdrsm");
            oprecordMessageModel.setBizobj(stdRsm.getLong("id"));
            oprecordMessageModel.setOpnumber(OpDefEnum.SHARE_CANDIDATES.getCode());
            oprecordMessageModel.setOptime(opTime);
            String opText = this.getOpText(sharerName, stdRsm.get("fullname").toString(), receiversName);
            oprecordMessageModel.setOprtext(opText);
            modelList.add(oprecordMessageModel);
        }
        return modelList;
    }

    public String getOpText(String sharer, String stdRsmName, String receivers) {
        return String.format("%s\u5206\u4eab\u5019\u9009\u4eba%s\u7684\u6807\u51c6\u7b80\u5386\u7ed9%s", sharer, stdRsmName, receivers);
    }

    public void sendShareOpRecord(List<OprecordMessageModel> modelList) {
        logger.info("sendShareOpRecord.modelList\uff1a{}", modelList);
        try {
            OprecordMQ.sendOpRecordChangeMessage(modelList);
        }
        catch (KDException ex) {
            logger.error("OprecordMQ.sendOpRecordChangeMessage.error:", (Throwable)ex);
        }
    }

    private static class Instance {
        private static final ShareOpRecordHelper SHARE_OP_RECORD_HELPER = new ShareOpRecordHelper();

        private Instance() {
        }
    }
}

