/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.detail;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.headtemplate.AbstractHeaderService;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.integrity.ResumeIntegrityService;
import kd.tsc.tstpm.business.domain.stdrsm.service.integrity.factory.IntegrityFactory;
import org.apache.commons.lang3.StringUtils;

public class UnAllocateRsmHeaderService
extends AbstractHeaderService {
    private static final long serialVersionUID = 532900306366543018L;

    public List<String> getHideItemList(IFormView view) {
        this.setPhotoHide(view, true);
        return Lists.newArrayList((Object[])new String[]{"flexpanelap14", "flexpanelap73", "flexpanelap7", "flexpanelap711", "flexpanelap72", "flexpanelap10", "flexpanelap12", "flexpanelap13", "applyposition", "labelap3", "flexpanelap7111"});
    }

    public List<String> getClickListeners() {
        return Lists.newArrayList((Object[])new String[]{"vectorap6", "vectorap1", "labelap1"});
    }

    public List<String> getItemClickListeners() {
        return null;
    }

    public void initData(IFormView view) {
        Map requestData = view.getFormShowParameter().getCustomParams();
        Object rsmId = requestData.get("id");
        if (Objects.nonNull(rsmId)) {
            HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsm");
            DynamicObject rsm = helper.queryOne(rsmId);
            IDataModel model = view.getModel();
            this.setPhoto(view, rsm.getString("photo"));
            model.setValue("fullname", rsm.get("fullname"));
            model.setValue("number", rsm.get("number"));
            DynamicObject genderOb = rsm.getDynamicObject("gender");
            model.setValue("gender", (Object)(genderOb == null ? "" : genderOb));
            int workYears = rsm.getInt("workingyears");
            String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workYears);
            model.setValue("workexp", (Object)workYearShow);
            model.setValue("highestedu", rsm.get("highesteducation.name"));
            model.setValue("recentposition", rsm.get("recentposition"));
            model.setValue("phone", rsm.get("phone"));
            model.setValue("email", rsm.get("email"));
            this.setDeliveryInfo(model, requestData.get("id"));
            Object obj = requestData.get("applyposition");
            if (null != obj) {
                model.setValue("applyposition", (Object)obj.toString());
            }
            ResumeIntegrityService service = IntegrityFactory.getResumeIntegrityService("tstpm_rsm");
            int integrity = service.calculateResumeIntegrity(rsm.getLong("id"));
            view.getModel().setValue("integrity", (Object)(integrity + "%"));
            Object stdRsmId = requestData.get("stdrsm");
            this.setStdRsmInfo(view, (Long)stdRsmId);
        }
    }

    public void click(IFormView view, String key) {
        IDataModel model = view.getParentView().getModel();
        DynamicObject entity = model.getDataEntity();
        long stdRsmId = entity.getLong("stdrsm");
        if (StringUtils.equals((CharSequence)"vectorap6", (CharSequence)key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("tstpm_candidate_detail");
            parameter.setCustomParam("id", (Object)stdRsmId);
            parameter.setCustomParam("type", (Object)"3");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm(parameter);
        } else if (StringUtils.equals((CharSequence)"vectorap1", (CharSequence)key) || StringUtils.equals((CharSequence)"labelap1", (CharSequence)key)) {
            this.openBlacklistInfoPage(view, stdRsmId);
        }
    }

    public void savePhoto(Object objId, String url) {
    }
}

