/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.factory;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.StdRsmDetailService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.detail.EduExpService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.detail.IStdRsmService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.detail.LangExpService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.detail.PrjExpService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.detail.RelationExpService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.detail.WorkExpService;

public class ResumeDetailFactory {
    private static final Map<String, StdRsmDetailService> SERVICE = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, String> MAPPING = Maps.newHashMapWithExpectedSize((int)16);

    public static StdRsmDetailService getInstance(String entryNumber) {
        StdRsmDetailService service = SERVICE.get(entryNumber);
        if (null == service) {
            Map<String, String> mapping = ResumeMapping.getResumeMapping();
            entryNumber = mapping.get(entryNumber);
            service = SERVICE.get(entryNumber);
        }
        service.setEntryNumber(entryNumber);
        return service;
    }

    public static String getPageKey(String entryNumber) {
        String key = MAPPING.get(entryNumber);
        if (null == key) {
            Map<String, String> mapping = ResumeMapping.getResumeMapping();
            String number = mapping.get(entryNumber);
            key = MAPPING.get(number);
        }
        return HRStringUtils.isEmpty((String)key) ? null : key;
    }

    private ResumeDetailFactory() {
    }

    static {
        SERVICE.put("tstpm_stdrsm", new IStdRsmService());
        SERVICE.put("tstpm_stdeduexp", new EduExpService());
        SERVICE.put("tstpm_stdworkexp", new WorkExpService());
        SERVICE.put("tstpm_stdprjexp", new PrjExpService());
        SERVICE.put("tstpm_stdlangabl", new LangExpService());
        SERVICE.put("tstpm_stdrelationwork", new RelationExpService());
        MAPPING.put("tstpm_stdrsm", " ");
        MAPPING.put("tstpm_stdeduexp", "eduentry");
        MAPPING.put("tstpm_stdworkexp", "workentry");
        MAPPING.put("tstpm_stdprjexp", "prjentry");
        MAPPING.put("tstpm_stdlangabl", "stdlangablentry");
        MAPPING.put("tstpm_stdrelationwork", "stdrelationentry");
    }
}

