/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.factory;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tsc.tstpm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.IPrototype;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.ResumeDao;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.ResumeService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.ResumeStatusService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.black.IBlackListService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.black.IDeleteService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.prototype.AddStdRsmPrototype;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.prototype.UpdateStdRsmPrototype;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;

public class RsmPrototypeFactory {
    private static final Map<ModelType, ResumeDao> PROTOTYPES = Maps.newHashMapWithExpectedSize((int)16);

    public static <T extends IPrototype> T getInstance(ModelType modelType) {
        return (T)((IPrototype)PROTOTYPES.get((Object)modelType));
    }

    public static <T extends ResumeStatusService> T getResumeStatusService(ModelType modelType) {
        return (T)((ResumeStatusService)PROTOTYPES.get((Object)modelType));
    }

    public static <T extends ResumeService> T getResumeService(ModelType modelType) {
        return (T)((ResumeService)PROTOTYPES.get((Object)modelType));
    }

    static {
        PROTOTYPES.put(ModelType.MAIN_RSM_ADD, new AddStdRsmPrototype());
        PROTOTYPES.put(ModelType.MAIN_RSM_UPDATE, new UpdateStdRsmPrototype());
        PROTOTYPES.put(ModelType.MAIN_RSM_DELETE, new IDeleteService());
        PROTOTYPES.put(ModelType.MAIN_RSM_BLACK_LIST, new IBlackListService());
        PROTOTYPES.put(ModelType.MAIN_RSM_DEFAULT_SERVICE, new IResumeService());
    }
}

