/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.handler.adapt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.tsc.tsrbd.business.domain.rule.service.AutoRuleFactory;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tstpm.business.domain.stdrsm.domain.ResumeOpRecord;
import kd.tsc.tstpm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tstpm.business.domain.stdrsm.enums.RsmBizEnum;
import kd.tsc.tstpm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tstpm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tstpm.business.domain.stdrsm.handler.entity.Context;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.duplicate.IDuplicateService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmOpRecordService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;
import kd.tsc.tstpm.business.domain.talentpool.enums.TalentPoolOpEnum;
import kd.tsc.tstpm.business.domain.talentpool.factory.TalentPoolServiceFactory;
import kd.tsc.tstpm.business.domain.talentpool.modal.IReserveService;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import org.apache.commons.lang3.ObjectUtils;

public class StdRsmAdapt {
    private static final Log logger = LogFactory.getLog(StdRsmAdapt.class);

    public static DynamicObject isExistStandResume(AppResumeBo appResumeBo) {
        String rsmType = appResumeBo.getRsm().getDataEntityType().getName();
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping(rsmType);
        String mainEntryNumber = resumeMapping.get(rsmType);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainEntryNumber);
        DynamicObject stdRsm = new DynamicObject((DynamicObjectType)entityType);
        HRDynamicObjectUtils.copy((DynamicObject)appResumeBo.getRsm(), (DynamicObject)stdRsm);
        Map<String, DynamicObjectCollection> paramMap = StdRsmAdapt.getDuplicateParam(appResumeBo, stdRsm);
        IDuplicateService duplicateService = new IDuplicateService(mainEntryNumber);
        Context context = duplicateService.doCheckDuplicate(paramMap, Boolean.TRUE);
        Set<Long> duplicateRsm = context.getDuplicateRsm();
        if (!duplicateRsm.isEmpty()) {
            long duplicateRsmId = duplicateRsm.iterator().next();
            return StdRsmServiceHelper.getStdRsmDy(duplicateRsmId);
        }
        return null;
    }

    public static Map<String, Long> addStandResume(AppResumeBo appResumeBo, ResumeTypeEnum typeEnum) {
        IDataEntityType dataEntityType = appResumeBo.getRsm().getDataEntityType();
        String rsmMainEntryNumber = dataEntityType.getName();
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping(rsmMainEntryNumber);
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        String stdRsmMainEntryNumber = resumeMapping.get(rsmMainEntryNumber);
        DynamicObject stdRsmDy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)stdRsmMainEntryNumber));
        DynamicObject rsmDy = RsmPrototypeFactory.getInstance(ModelType.MAIN_RSM_ADD).clone(appResumeBo.getRsm(), stdRsmDy);
        StdRsmAdapt.setTpInfo(rsmDy, appResumeBo);
        DynamicObjectCollection stdRsmCollection = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)stdRsmMainEntryNumber), null);
        stdRsmCollection.add((Object)rsmDy);
        param.put(stdRsmMainEntryNumber, stdRsmCollection);
        StdRsmAdapt.fillEntryData(appResumeBo, param, stdRsmMainEntryNumber);
        Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.init(rsmDy);
        resumeService.setDuplicateEntry("tstpm_stdeduexp");
        resumeService.saveResume(param, (Long)stdRsmDy.getLong("id"));
        if (typeEnum == ResumeTypeEnum.ANALYSIS) {
            TalentListFunService.saveOneReserveRecord(stdRsmDy.getLong("id"), appResumeBo.getTalentId());
        } else {
            IReserveService service = (IReserveService)TalentPoolServiceFactory.getReserveService(TalentPoolOpEnum.RESERVE);
            List<String> buNumberList = service.getBuNumber(appResumeBo, typeEnum, "TSC_SCENE_10010");
            List<Map<String, Object>> engineParam = service.buildRuleEngineParam(param, stdRsmMainEntryNumber);
            for (String buNumber : buNumberList) {
                HashMap baseRequestMap = Maps.newHashMapWithExpectedSize((int)8);
                baseRequestMap.put("bizApp", "tstpm");
                baseRequestMap.put("sceneNumber", "TSC_SCENE_10010");
                baseRequestMap.put("buNumber", buNumber);
                boolean isHandleSucess = AutoRuleFactory.getDefaultAutoRuleService().executeBatch((Map)baseRequestMap, engineParam);
                if (isHandleSucess) continue;
                TalentListFunService.saveCandidate2UnClassFy(Collections.singletonList(stdRsmDy.getLong("id")));
            }
        }
        StdRsmOpRecordService.getInstance().resumeCreateOpRecord(new ResumeOpRecord(rsmDy, appResumeBo, typeEnum));
        return ImmutableMap.of((Object)"id", (Object)stdRsmDy.getLong("id"));
    }

    private static void setTpInfo(DynamicObject rsmDy, AppResumeBo appResumeBo) {
        String tpStdRsmId = appResumeBo.getTpStdRsmId();
        if (ObjectUtils.isNotEmpty((Object)tpStdRsmId)) {
            rsmDy.set("tpdataid", (Object)tpStdRsmId);
            rsmDy.set("tpsys", (Object)appResumeBo.getTpSys());
        }
    }

    public static void diffUpdateStandResume(Long stdRsmId, AppResumeBo appResumeBo, ResumeTypeEnum typeEnum) {
        if (stdRsmId == null) {
            return;
        }
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObject rsm = appResumeBo.getRsm();
        String rsmType = rsm.getDataEntityType().getName();
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping(rsmType);
        String stdRsmMainEntryName = resumeMapping.get(rsmType);
        logger.info("StdRsmAdapt.diffUpdateStandResume.stdRsmMainEntryName:[{}]", (Object)stdRsmMainEntryName);
        DynamicObject oldStdRsmDy = StdRsmServiceHelper.getStdRsmByMid(stdRsmMainEntryName, stdRsmId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)stdRsmMainEntryName);
        DynamicObjectCollection rsmCollection = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        DynamicObject stdRsm = RsmPrototypeFactory.getInstance(ModelType.MAIN_RSM_UPDATE).clone(rsm, oldStdRsmDy);
        RsmBizEnum operateRecord = RsmBizEnum.RESUME_OPERATE_RECORD;
        List changeListMap = (List)operateRecord.getChangeFieldValues(stdRsm, stdRsmId);
        rsmCollection.add((Object)stdRsm);
        param.put(stdRsmMainEntryName, rsmCollection);
        StdRsmAdapt.fillEntryData(appResumeBo, param, stdRsmMainEntryName);
        IResumeService resumeService = (IResumeService)RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.init(stdRsm);
        resumeService.setDuplicateEntry("tstpm_stdeduexp");
        resumeService.editResume(param, stdRsmId);
        DynamicObject position = appResumeBo.getPosition();
        StdRsmOpRecordService.getInstance().resumeUpdateOR(stdRsm, position, typeEnum, changeListMap);
    }

    public static DynamicObject isExistStandResume(String tpDataId) {
        QFilter qFilter = new QFilter("tpdataid", "=", (Object)tpDataId);
        qFilter.and("datastatus", "=", (Object)"1");
        qFilter.and("iscurrentversion", "=", (Object)"1");
        return StandardResumeDataHelper.queryOneByFilter("id", new QFilter[]{qFilter});
    }

    private static void fillEntryData(AppResumeBo appResumeBo, Map<String, DynamicObjectCollection> param, String entryNumber) {
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping(appResumeBo.getRsm().getDataEntityType().getName());
        for (Map.Entry<String, String> mapping : resumeMapping.entrySet()) {
            String rsmEntry = mapping.getKey();
            String stdEntry = mapping.getValue();
            if (stdEntry.equals(entryNumber)) continue;
            DynamicObjectCollection collection = appResumeBo.getEntry(rsmEntry);
            logger.info("StdRsmAdapt.diffUpdateStandResume: entry name[{}], entry[{}]", (Object)rsmEntry, (Object)collection);
            if (!collection.isEmpty()) {
                DynamicObjectCollection entryCollection = StdRsmAdapt.getStdRsmCollection(collection, stdEntry);
                param.put(stdEntry, entryCollection);
                continue;
            }
            if (!ObjectUtils.isEmpty((Object)param.get(stdEntry))) continue;
            param.put(stdEntry, null);
        }
    }

    private static DynamicObjectCollection getStdRsmCollection(DynamicObjectCollection collection, String entryNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryNumber);
        DynamicObjectCollection result = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        ImmutableSet ignoreKeys = ImmutableSet.of((Object)"id");
        for (DynamicObject dy : collection) {
            DynamicObject stdEntryDy = new DynamicObject((DynamicObjectType)entityType);
            DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)stdEntryDy, (Set)ignoreKeys);
            result.add((Object)stdEntryDy);
        }
        logger.info("StdRsmAdapt.getStdRsmCollection.result[{}]", (Object)SerializationUtils.toJsonString((Object)result));
        return result;
    }

    private static Map<String, DynamicObjectCollection> getDuplicateParam(AppResumeBo appResumeBo, DynamicObject stdRsm) {
        String mainEntryNumber = stdRsm.getDataEntityType().getName();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainEntryNumber);
        DynamicObjectCollection mainDyCollection = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        mainDyCollection.add((Object)stdRsm);
        paramMap.put(mainEntryNumber, mainDyCollection);
        DynamicObjectCollection collection = appResumeBo.getEntry("tstpm_srrsmeduexp");
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping(appResumeBo.getRsm().getDataEntityType().getName(), "10040_S");
        String stdEntryNumber = resumeMapping.entrySet().iterator().next().getValue();
        Optional.of(collection).ifPresent(coll -> {
            MainEntityType eduEntityType = EntityMetadataCache.getDataEntityType((String)stdEntryNumber);
            DynamicObjectCollection eduCollection = new DynamicObjectCollection((DynamicObjectType)eduEntityType, null);
            coll.forEach(dy -> {
                DynamicObject stdEdu = new DynamicObject((DynamicObjectType)eduEntityType);
                DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)stdEdu);
                eduCollection.add((Object)stdEdu);
            });
            paramMap.put(stdEntryNumber, eduCollection);
        });
        logger.info("StdRsmAdapt.getDuplicateParam.paramMap:[{}]", (Object)SerializationUtils.toJsonString((Object)paramMap));
        return paramMap;
    }
}

