/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.handler.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class DuplicateConfig {
    private static final Comparator INDEX_TOP_COMPARATOR = Comparator.comparingInt(obj -> ((DynamicObject)obj).getInt("index"));

    private DuplicateConfig() {
    }

    public static DynamicObject[] getConfig(String bizType, String type, String duplicateType) {
        QFilter filter = new QFilter("type", "=", (Object)type);
        filter.and("biztype", "=", (Object)bizType);
        if (HRStringUtils.isNotEmpty((String)duplicateType)) {
            filter.and("duplicatetype", "=", (Object)duplicateType);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_chedupruler");
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        Arrays.sort(dys, INDEX_TOP_COMPARATOR);
        return dys;
    }

    public static Map<String, List<String>> getCheckParam(DynamicObject config) {
        DynamicObjectCollection collection = config.getDynamicObjectCollection("entryentity");
        HashMap checkParams = Maps.newHashMapWithExpectedSize((int)16);
        if (collection.isEmpty()) {
            return checkParams;
        }
        for (DynamicObject entry : collection) {
            DuplicateConfig.buildQueryParams(entry, checkParams);
        }
        return checkParams;
    }

    private static void buildQueryParams(DynamicObject dy, Map<String, List<String>> checkParams) {
        String entryNumber = dy.getString("blockmark");
        if (HRStringUtils.isNotEmpty((String)entryNumber)) {
            List<String> checkFields = checkParams.getOrDefault(entryNumber, Lists.newArrayListWithCapacity((int)16));
            String attribute = dy.getString("fieldmark");
            checkFields.add(attribute);
            checkParams.put(entryNumber, checkFields);
        }
    }
}

