/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.handler.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;

public class ResumeMapping {
    private static final Map<String, String> RESUME_MAPPING = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, List<String>> RESUME_ENTRY = Maps.newHashMapWithExpectedSize((int)16);

    private ResumeMapping() {
    }

    public static Map<String, String> getResumeMapping() {
        return ResumeMapping.getResumeMapping("tstpm_srrsm");
    }

    public static Map<String, String> getResumeMapping(String sourceKey) {
        return ResumeMetadataService.getEntryKeyMap((String)sourceKey);
    }

    public static Map<String, String> getResumeMapping(String sourceKey, String rsmMtdNumber) {
        return ResumeMetadataService.getTargetKeyByMtd((String)sourceKey, (String)rsmMtdNumber);
    }

    public static Set<String> getStdRsmEntryNumbers() {
        return new HashSet<String>(RESUME_MAPPING.values());
    }

    public static List<String> getRsmEntryNumbers(String entryNumber) {
        return RESUME_ENTRY.get(entryNumber);
    }

    static {
        RESUME_MAPPING.put("tstpm_srrsm", "tstpm_stdrsm");
        RESUME_MAPPING.put("tstpm_rsm", "tstpm_stdrsm");
        RESUME_MAPPING.put("tstpm_srrsmupdate", "tstpm_stdrsm");
        RESUME_MAPPING.put("tstpm_srrsmworkexp", "tstpm_stdworkexp");
        RESUME_MAPPING.put("tstpm_srrsmeduexp", "tstpm_stdeduexp");
        RESUME_MAPPING.put("tstpm_srrsmprjexp", "tstpm_stdprjexp");
        RESUME_MAPPING.put("tstpm_srrsmlangabl", "tstpm_stdlangabl");
        RESUME_MAPPING.put("tstpm_srrsmworkrela", "tstpm_stdrelationwork");
        RESUME_MAPPING.put("tstpm_rsmworkexp", "tstpm_stdworkexp");
        RESUME_MAPPING.put("tstpm_rsmeduexp", "tstpm_stdeduexp");
        RESUME_MAPPING.put("tstpm_rsmprjexp", "tstpm_stdprjexp");
        RESUME_MAPPING.put("tstpm_rsmlangabl", "tstpm_stdlangabl");
        ArrayList resumeEntryList = Lists.newArrayList((Object[])new String[]{"tstpm_srrsmworkexp", "tstpm_srrsmeduexp", "tstpm_srrsmprjexp", "tstpm_srrsmlangabl", "tstpm_srrsmworkrela"});
        ArrayList stdRsmEntryList = Lists.newArrayList((Object[])new String[]{"tstpm_stdworkexp", "tstpm_stdeduexp", "tstpm_stdprjexp", "tstpm_stdlangabl", "tstpm_stdrelationwork"});
        RESUME_ENTRY.put("tstpm_stdrsm", stdRsmEntryList);
        RESUME_ENTRY.put("tstpm_rsm", resumeEntryList);
    }
}

