/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.handler.duplicate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.handler.duplicate.Handler;
import kd.tsc.tstpm.business.domain.stdrsm.handler.entity.Context;
import kd.tsc.tstpm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tstpm.common.utils.ResumeDyUtil;

public abstract class AbstractCheckDuplicateHandler
implements Handler,
Serializable {
    private static final Log logger = LogFactory.getLog(AbstractCheckDuplicateHandler.class);
    private static final long serialVersionUID = 36690749600828420L;
    protected Map<String, DynamicObjectCollection> params;
    protected Map<String, List<String>> checkParam;

    @Override
    public void init(Map<String, DynamicObjectCollection> params, Map<String, List<String>> checkParam) {
        this.params = params;
        this.checkParam = checkParam;
    }

    @Override
    public boolean judgeParam(Context context) {
        boolean result = true;
        DynamicObject resumeMainDy = context.getResumeMainDy();
        if (null == resumeMainDy) {
            logger.info("AbstractCheckDuplicateHandler.judgeParam: resumeMainDy is null");
            result = false;
        }
        if (this.checkParam == null || this.checkParam.isEmpty()) {
            logger.info("AbstractCheckDuplicateHandler.judgeParam: checkParam is null");
            result = false;
        }
        return result;
    }

    protected DynamicObject[] getStdRsmDys(DynamicObject dy, List<String> fields) {
        if (null == fields) {
            return new DynamicObject[0];
        }
        String entryNumber = dy.getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entryNumber);
        List filters = ResumeDyUtil.getFilterByFields((DynamicObject)dy, fields);
        if (filters.isEmpty()) {
            return new DynamicObject[0];
        }
        this.addCurrFilter(filters, dy.getDataEntityType().getName());
        String queryFields = HRDynamicObjectUtils.getQueryFields((DynamicObject)dy);
        return serviceHelper.query(queryFields, filters.toArray(new QFilter[0]));
    }

    protected DynamicObject[] getHisStdRsm(DynamicObject dy, List<String> fields) {
        if (null == fields) {
            return new DynamicObject[0];
        }
        String hisEntryNumber = dy.getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)hisEntryNumber);
        List filters = ResumeDyUtil.getFilterByFields((DynamicObject)dy, fields);
        if (filters.isEmpty()) {
            return new DynamicObject[0];
        }
        long mid = dy.getLong("mid");
        filters.add(new QFilter("mid", "!=", (Object)mid));
        filters.add(new QFilter("iscurrentversion", "=", (Object)"0"));
        String queryFields = HRDynamicObjectUtils.getQueryFields((DynamicObject)dy);
        DynamicObject[] dys = serviceHelper.query(queryFields, filters.toArray(new QFilter[0]));
        Set similarIds = Arrays.stream(dys).map(simDy -> simDy.getLong("mid")).collect(Collectors.toSet());
        if (similarIds.isEmpty()) {
            return new DynamicObject[0];
        }
        String dataStatus = ResumeHisDataStatusEnum.DELETED.getStatus();
        QFilter filter = new QFilter("datastatus", "!=", (Object)dataStatus);
        filter.and("id", "in", similarIds);
        return serviceHelper.query(queryFields, new QFilter[]{filter});
    }

    @Override
    public void logger(Context context, Boolean recordLogger) {
        DynamicObject resumeDy = context.getResumeMainDy();
        Set<Long> duplicateRsm = context.getDuplicateRsm();
        Long similarDy = duplicateRsm.iterator().next();
        String logMessage = ResManager.loadKDString((String)"%s { %s }\u4e0e\u6807\u51c6\u7b80\u5386{ %s }\u901a\u8fc7\u7cbe\u51c6\u67e5\u91cd\u89c4\u5219{ %s }\u5224\u5b9a\u4e3a\u91cd\u590d\u7b80\u5386.", (String)"StdRsmDuplicateLog_0", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        logger.info(String.format(logMessage, resumeDy.getString("fullname"), resumeDy.getLong("id"), similarDy, this.checkParam));
        if (recordLogger.booleanValue()) {
            logger.info("AbstractCheckDuplicateHandler.recordDuplicateSrdRsm.similarDy:{}", (Object)similarDy);
            SimilarServiceHelper.recordDuplicateSrdRsm(similarDy);
        }
    }

    public abstract void addCurrFilter(List<QFilter> var1, String var2);
}

