/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.handler.duplicate;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.handler.duplicate.AbstractCheckDuplicateHandler;
import kd.tsc.tstpm.business.domain.stdrsm.handler.entity.CandidateContext;
import kd.tsc.tstpm.business.domain.stdrsm.handler.entity.Context;

public class StdRsmCheckDuplicateHandler
extends AbstractCheckDuplicateHandler {
    private static final Log logger = LogFactory.getLog(StdRsmCheckDuplicateHandler.class);
    private static final long serialVersionUID = -6840541487412197430L;

    @Override
    public void doPreciseCheck(Context context) {
        String entryNumber;
        DynamicObject resumeMainDy;
        DynamicObject[] stdRsmDys;
        if (this.judgeParam(context) && (stdRsmDys = this.getStdRsmDys(resumeMainDy = context.getResumeMainDy(), (List)this.checkParam.get(entryNumber = resumeMainDy.getDataEntityType().getName()))).length > 0) {
            Long duplicateId = stdRsmDys[0].getLong("mid");
            logger.info("StdRsmCheckDuplicateHandler.doPreciseCheck.checkParam:[{}]", (Object)this.checkParam);
            logger.info("StdRsmCheckDuplicateHandler.doPreciseCheck.duplicateId:[{}]", (Object)duplicateId);
            ((CandidateContext)context).setDuplicateRsm(duplicateId);
        }
    }

    @Override
    public void doFuzzyQuery(Context context) {
        if (this.judgeParam(context)) {
            DynamicObject resumeMainDy = context.getResumeMainDy();
            String entryNumber = resumeMainDy.getDataEntityType().getName();
            Long stdRsmId = context.getResumeMainDy().getLong("mid");
            List fields = (List)this.checkParam.get(entryNumber);
            DynamicObject[] stdRsmDys = this.getHisStdRsm(resumeMainDy, fields);
            if (stdRsmDys.length == 0) {
                return;
            }
            Set<Long> similarIds = Arrays.stream(stdRsmDys).map(dy -> dy.getLong("mid")).collect(Collectors.toSet());
            ((CandidateContext)context).setSimilarIds(similarIds);
            String logMessage = ResManager.loadKDString((String)"[{}]\u6807\u51c6\u7b80\u5386 [{}]\u4e0e\u6807\u51c6\u7b80\u5386{}\u901a\u8fc7\u7cbe\u51c6\u67e5\u91cd\u89c4\u5219[{}]\u5224\u5b9a\u4e3a\u7cbe\u51c6\u7591\u4f3c\u7b80\u5386.", (String)"StdRsmDuplicateLog_1", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            logger.info(logMessage, new Object[]{resumeMainDy.get("fullname"), stdRsmId, similarIds, this.checkParam});
        }
    }

    @Override
    public void addCurrFilter(List<QFilter> filters, String entryNumber) {
        DynamicObjectCollection collection = (DynamicObjectCollection)this.params.get(entryNumber);
        Optional.ofNullable(collection).ifPresent(coll -> {
            long mid = ((DynamicObject)coll.get(0)).getLong("mid");
            filters.add(new QFilter("boid", "!=", (Object)mid));
            ImmutableList dataStatus = ImmutableList.of((Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (Object)ResumeHisDataStatusEnum.EFFECTING.getStatus());
            filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            filters.add(new QFilter("datastatus", "in", (Object)dataStatus));
        });
    }
}

