/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ResumeAttentionHelper {
    public static boolean isAttention(Long resumeId, String resumeType) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tstpm_attention");
        QFilter qFilter = new QFilter("creator", "=", (Object)TSCRequestContext.getUserId());
        qFilter.and(new QFilter("attresume", "=", (Object)resumeId));
        qFilter.and(new QFilter("attresumetype", "=", (Object)resumeType));
        DynamicObject[] attentionDos = hrServiceHelper.query("id", new QFilter[]{qFilter});
        boolean flag = false;
        if (attentionDos.length > 0) {
            flag = true;
        }
        return flag;
    }

    public static void remAttention(List<Long> resumeIds, String resumeType) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tstpm_attention");
        QFilter qFilter = new QFilter("creator", "=", (Object)TSCRequestContext.getUserId());
        qFilter.and(new QFilter("attresume", "in", resumeIds));
        qFilter.and(new QFilter("attresumetype", "=", (Object)resumeType));
        hrServiceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    public static Map<Long, DynamicObject> queryAttentionList(List<Long> resumeIds, String resumeType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_attention");
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        QFilter filter = new QFilter("attresume", "in", resumeIds).and(new QFilter("creator", "=", (Object)TSCRequestContext.getUserId())).and(new QFilter("attresumetype", "=", (Object)resumeType));
        DynamicObject[] dys = serviceHelper.query("attresume", new QFilter[]{filter});
        if (dys.length > 0) {
            for (DynamicObject dy : dys) {
                result.put(dy.getLong("attresume"), dy);
            }
        }
        return result;
    }

    public static List<Long> getMyAttention(String resumeType) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tstpm_attention");
        QFilter qFilter = new QFilter("creator", "=", (Object)TSCRequestContext.getUserId());
        qFilter.and(new QFilter("attresumetype", "=", (Object)resumeType));
        DynamicObject[] attentionDys = hrServiceHelper.query("attresume", new QFilter[]{qFilter});
        ArrayList idList = Lists.newArrayListWithCapacity((int)attentionDys.length);
        for (DynamicObject dy : attentionDys) {
            long id = dy.getLong("attresume");
            idList.add(id);
        }
        return idList;
    }

    public static void updateMyAttention(DynamicObject mergeFrom, DynamicObject mergeTo) {
        if (ResumeAttentionHelper.isMergeFromExist(mergeFrom.getLong("id"), "0")) {
            Long fromResume = mergeFrom.getLong("id");
            Long toResume = mergeTo.getLong("id");
            Map<Long, Boolean> fromResumes = ResumeAttentionHelper.queryResumeList(fromResume, "0");
            Map<Long, Boolean> toResumes = ResumeAttentionHelper.queryResumeList(toResume, "0");
            ArrayList<Long> updateIds = new ArrayList<Long>(10);
            ArrayList<Long> deleteIds = new ArrayList<Long>(10);
            Set<Long> set = fromResumes.keySet();
            for (Long key : set) {
                if (HRObjectUtils.equals((Object)toResumes.get(key), (Object)true)) {
                    deleteIds.add(key);
                    continue;
                }
                updateIds.add(key);
            }
            ResumeAttentionHelper.delAttention(deleteIds, "0", fromResume);
            ResumeAttentionHelper.updateAttention(updateIds, "0", fromResume, toResume);
        }
    }

    private static boolean isMergeFromExist(Long resumeId, String resumeType) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tstpm_attention");
        QFilter qFilter = new QFilter("attresume", "=", (Object)resumeId);
        qFilter.and(new QFilter("attresumetype", "=", (Object)resumeType));
        DynamicObject[] attentionDos = hrServiceHelper.query("id", new QFilter[]{qFilter});
        boolean flag = false;
        if (attentionDos.length > 0) {
            flag = true;
        }
        return flag;
    }

    private static Map<Long, Boolean> queryResumeList(Long resumeId, String resumeType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_attention");
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        QFilter filter = new QFilter("attresume", "=", (Object)resumeId).and(new QFilter("attresumetype", "=", (Object)resumeType));
        DynamicObject[] dys = serviceHelper.query("creator", new QFilter[]{filter});
        if (dys.length > 0) {
            for (DynamicObject dy : dys) {
                result.put(dy.getDynamicObject("creator").getLong("id"), true);
            }
        }
        return result;
    }

    private static void delAttention(List<Long> creatorIds, String resumeType, Long fromResume) {
        if (creatorIds.isEmpty()) {
            return;
        }
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tstpm_attention");
        QFilter qFilter = new QFilter("creator", "in", creatorIds);
        qFilter.and(new QFilter("attresumetype", "=", (Object)resumeType));
        qFilter.and(new QFilter("attresume", "=", (Object)fromResume));
        hrServiceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    private static void updateAttention(List<Long> creatorIds, String resumeType, Long fromResume, Long toResume) {
        if (creatorIds.isEmpty()) {
            return;
        }
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tstpm_attention");
        QFilter qFilter = new QFilter("creator", "in", creatorIds);
        qFilter.and(new QFilter("attresumetype", "=", (Object)resumeType));
        qFilter.and(new QFilter("attresume", "=", (Object)fromResume));
        DynamicObject[] updateDy = hrServiceHelper.query("attresume", new QFilter[]{qFilter});
        for (int iNumber = 0; iNumber < updateDy.length; ++iNumber) {
            updateDy[iNumber].set("attresume", (Object)toResume);
        }
        hrServiceHelper.update(updateDy);
    }
}

