/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.helper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmDetailHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;

public class ResumeFormHelper {
    private ResumeFormHelper() {
    }

    public static void showResumeORForm(IFormView view, Long stdRsmId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbs_oprecord_list");
        showParameter.getOpenStyle().setTargetKey("tabpageapor");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("entitytype", (Object)"tstpm_stdrsm");
        showParameter.setCustomParam("bizobj", (Object)String.valueOf(stdRsmId));
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
    }

    public static void showMergeCandidate(IFormView view, Object curId, Object susId, CloseCallBack callBack) {
        FormShowParameter mergerPerson = new FormShowParameter();
        mergerPerson.setFormId("tstpm_mergercandidates");
        mergerPerson.getOpenStyle().setShowType(ShowType.Modal);
        mergerPerson.setCloseCallBack(callBack);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("curId", curId);
        params.put("susId", susId);
        mergerPerson.setCustomParams(params);
        view.showForm(mergerPerson);
    }

    public static void loadPage(IFormView view, String formId, String targetKey) {
        FormShowParameter childPageParameter = new FormShowParameter();
        childPageParameter.setFormId(formId);
        childPageParameter.getOpenStyle().setTargetKey(targetKey);
        childPageParameter.getOpenStyle().setShowType(ShowType.InContainer);
        long stdRsmId = (Long)view.getFormShowParameter().getCustomParam("id");
        if (StringUtils.equals((CharSequence)"tsrbd_label_show", (CharSequence)formId)) {
            DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
            Long sourceVid = stdRsmDy.getLong("sourcevid");
            childPageParameter.setCustomParam("id", (Object)sourceVid);
            childPageParameter.setCustomParam("type", (Object)String.valueOf(LabelTagObjTypeEnum.OUT_STDRSM.getId()));
            childPageParameter.setCustomParam("isshowbutton", (Object)Boolean.TRUE);
            childPageParameter.setCustomParam("pagetype", (Object)"detail");
        } else {
            childPageParameter.setCustomParam("id", (Object)stdRsmId);
        }
        String isSimpleStdRsm = (String)view.getFormShowParameter().getCustomParam("isSimpleStdRsm");
        if (!StringUtils.equals((CharSequence)"tstpm_stdrsm_detail", (CharSequence)formId)) {
            childPageParameter.setSendToClient(Boolean.TRUE.booleanValue());
        }
        String dataStatus = (String)view.getFormShowParameter().getCustomParam("datastatus");
        if (null != isSimpleStdRsm || StringUtils.equals((CharSequence)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (CharSequence)dataStatus)) {
            if (StringUtils.equals((CharSequence)"tstpm_stdrsm_detail", (CharSequence)formId)) {
                DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
                long vid = stdRsmDy.getLong("sourcevid");
                childPageParameter.setCustomParam("vid", (Object)vid);
            }
            if (StringUtils.equals((CharSequence)"tsrbd_label_show", (CharSequence)formId)) {
                childPageParameter.setCustomParam("isshowbutton", (Object)Boolean.FALSE);
            }
            if (null != isSimpleStdRsm) {
                childPageParameter.setCustomParam("isSimpleStdRsm", (Object)Integer.valueOf(isSimpleStdRsm));
            }
        }
        childPageParameter.setCustomParam("datastatus", view.getFormShowParameter().getCustomParam("datastatus"));
        if (StringUtils.equals((CharSequence)"tstpm_head_template", (CharSequence)formId)) {
            childPageParameter.setCustomParam("page_type", (Object)"2");
        }
        long sourceId = (Long)view.getFormShowParameter().getCustomParam("sourcevid");
        childPageParameter.setCustomParam("sourcevid", (Object)sourceId);
        view.showForm(childPageParameter);
        view.getPageCache().put(formId + "pageid", childPageParameter.getPageId());
    }

    public static void loadHeadPage(IFormView view, String formId, String targetKey) {
        FormShowParameter childPageParameter = new FormShowParameter();
        childPageParameter.setFormId(formId);
        childPageParameter.getOpenStyle().setTargetKey(targetKey);
        childPageParameter.getOpenStyle().setShowType(ShowType.InContainer);
        long stdRsmId = (Long)view.getFormShowParameter().getCustomParam("id");
        childPageParameter.setCustomParam("id", (Object)stdRsmId);
        String isSimpleStdRsm = (String)view.getFormShowParameter().getCustomParam("isSimpleStdRsm");
        if (!StringUtils.equals((CharSequence)"tstpm_stdrsm_detail", (CharSequence)formId)) {
            childPageParameter.setSendToClient(Boolean.TRUE.booleanValue());
        }
        String dataStatus = (String)view.getFormShowParameter().getCustomParam("datastatus");
        if (null != isSimpleStdRsm || StringUtils.equals((CharSequence)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (CharSequence)dataStatus)) {
            if (StringUtils.equals((CharSequence)"tstpm_stdrsm_detail", (CharSequence)formId)) {
                DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
                long vid = stdRsmDy.getLong("sourcevid");
                childPageParameter.setCustomParam("vid", (Object)vid);
            }
            if (StringUtils.equals((CharSequence)"tsrbd_label_show", (CharSequence)formId)) {
                childPageParameter.setCustomParam("isshowbutton", (Object)Boolean.FALSE);
            }
            if (null != isSimpleStdRsm) {
                childPageParameter.setCustomParam("isSimpleStdRsm", (Object)Integer.valueOf(isSimpleStdRsm));
            }
        }
        childPageParameter.setCustomParam("datastatus", view.getFormShowParameter().getCustomParam("datastatus"));
        if (StringUtils.equals((CharSequence)"tstpm_head_template", (CharSequence)formId)) {
            childPageParameter.setCustomParam("page_type", (Object)"6");
        }
        long sourceId = (Long)view.getFormShowParameter().getCustomParam("sourcevid");
        childPageParameter.setCustomParam("sourcevid", (Object)sourceId);
        view.showForm(childPageParameter);
        view.getPageCache().put(formId + "pageid", childPageParameter.getPageId());
    }

    public static void loadRightDownPage(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String dataStatus = (String)parameter.getCustomParam("datastatus");
        String isSimpleStdRsm = (String)view.getFormShowParameter().getCustomParam("isSimpleStdRsm");
        if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus) && isSimpleStdRsm == null) {
            ResumeFormHelper.loadPage(view, "tstpm_blacklist_info", "flexpanerightdown");
        }
    }

    public static void loadTabPage(IFormView view, String formId, String targetKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        long stdRsmId = (Long)view.getFormShowParameter().getCustomParam("id");
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCustomParam("id", (Object)stdRsmId);
        Map<String, Boolean> permission = StdRsmDetailHelper.getPermission(stdRsmId);
        formShowParameter.setCustomParam("permission", permission);
        view.showForm(formShowParameter);
        view.getPageCache().put(formId + "pageid", formShowParameter.getPageId());
    }

    public static void openSaveModalPage(IFormPlugin plugin, IFormView view, String formId, Object primaryKey) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
        String stdRsmId = view.getPageCache().get("stdRsmId");
        baseShowParameter.setCustomParam("id", (Object)stdRsmId);
        if (Objects.nonNull(primaryKey)) {
            baseShowParameter.setPkId(primaryKey);
        }
        baseShowParameter.setCloseCallBack(new CloseCallBack(plugin, formId));
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static void openSaveModalPage(IFormPlugin plugin, IFormView view, String formId, Object primaryKey, OperationStatus operationStatus) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
        String stdRsmId = view.getPageCache().get("stdRsmId");
        baseShowParameter.setCustomParam("id", (Object)stdRsmId);
        if (Objects.nonNull(primaryKey)) {
            baseShowParameter.setPkId(primaryKey);
        }
        baseShowParameter.setCloseCallBack(new CloseCallBack(plugin, formId));
        baseShowParameter.setStatus(operationStatus);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static void openShowRecycleFrom(IFormView view, Long primaryKeyValue) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tstpm_stdrsm_detail");
        DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmDy(primaryKeyValue);
        showParameter.setCustomParam("id", (Object)rsmDy.getLong("sourcevid"));
        showParameter.setCustomParam("vid", (Object)rsmDy.getLong("sourcevid"));
        showParameter.setCustomParam("type", (Object)"delete");
        String caption = ResManager.loadKDString((String)"\u6807\u51c6\u7b80\u5386-%s", (String)"RecycleListPlugin_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
        DynamicObject dy = StdRsmServiceHelper.getStdRsmDy(primaryKeyValue);
        showParameter.setCaption(String.format(Locale.ROOT, caption, dy.getString("fullname")));
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        view.showForm(showParameter);
    }

    public static FormShowParameter openFormInContainer(Map<String, Object> customMap, String formId, String targetKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(targetKey);
        showParameter.setCustomParams(customMap);
        return showParameter;
    }
}

