/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tstpm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tstpm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;

public class ResumeValidateHelper {
    private static final Map<String, String> DATA_STATUS_MAP = Maps.newHashMapWithExpectedSize((int)2);

    public static String setShowVersion(IFormView view, Long stdRsmId, Long vid) {
        String message = ResumeValidateHelper.stdRsmDeleteStateValidate(stdRsmId);
        if (HRStringUtils.isNotEmpty((String)message)) {
            IFormView mainView = view.getMainView();
            mainView.showErrorNotification(message);
            view.sendFormAction(mainView);
            view.close();
            return message;
        }
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        long sourceId = stdRsmDy.getLong("sourcevid");
        if (sourceId == vid) {
            message = ResManager.loadKDString((String)"\u6b64\u7248\u672c\u4e3a\u6700\u65b0\u7248\u672c", (String)"ResumeValidateHelper_01", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            view.showErrorNotification(message);
        }
        return message;
    }

    public static String stdRsmDeleteValidate(IFormView view, long stdRsmId) {
        boolean hasPermission = AppUtils.checkPagePermission((String)"tstpm_stdrsm", (String)"4715e1f1000000ac");
        if (!hasPermission) {
            String message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5220\u9664\u201d\u7684\u6743\u9650\u3002", (String)"ResumeValidateHelper_04", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            IFormView mainView = view.getMainView();
            mainView.showErrorNotification(message);
            view.sendFormAction(mainView);
            return message;
        }
        boolean talentPoolPerm = CheckPermissionHelper.getInstance().isCurTalentAuth(stdRsmId);
        if (!talentPoolPerm) {
            String message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5220\u9664\u201d\u7684\u6743\u9650\u3002", (String)"ResumeValidateHelper_04", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            IFormView mainView = view.getMainView();
            mainView.showErrorNotification(message);
            view.sendFormAction(mainView);
            return message;
        }
        DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        String dataStatus = rsmDy.getString("datastatus");
        if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            String message = ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c,\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"ResumeValidateHelper_06", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            IFormView mainView = view.getMainView();
            mainView.showErrorNotification(message);
            view.sendFormAction(mainView);
            view.close();
            return message;
        }
        Object service = RsmPrototypeFactory.getResumeStatusService(ModelType.MAIN_RSM_DELETE);
        service.setEntryNumber("tstpm_stdrsm");
        if (service.validateStatusChange(rsmDy.getLong("mid"))) {
            String message = ResManager.loadKDString((String)"\u8be5\u6807\u51c6\u7b80\u5386\u5b58\u5728\u5173\u8054\u7684\u5e94\u8058\u6863\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ResumeValidateHelper_05", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            IFormView mainView = view.getMainView();
            mainView.showErrorNotification(message);
            view.sendFormAction(mainView);
            return message;
        }
        return null;
    }

    public static String stdRsmDeleteDataStatusValidate(IFormView view, long stdRsmId) {
        DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        String dataStatus = rsmDy.getString("datastatus");
        String message = null;
        if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            message = ResManager.loadKDString((String)"\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"ResumeValidateHelper_06", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            IFormView mainView = view.getMainView();
            mainView.showErrorNotification(message);
            view.sendFormAction(mainView);
            view.close();
        }
        return message;
    }

    public static String suspectedResumeOpenValidate(FormShowParameter parameter) {
        Object obj = parameter.getCustomParam("id");
        long stdRsmId = Long.parseLong(obj.toString());
        DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmByMid(parameter.getFormId(), stdRsmId);
        String pageDataStatus = (String)parameter.getCustomParam("datastatus");
        String dataStatus = rsmDy.getString("datastatus");
        if (Objects.nonNull(pageDataStatus) && !pageDataStatus.equals(dataStatus)) {
            return ResManager.loadKDString((String)" \u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            return ResManager.loadKDString((String)"\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"ResumeValidateHelper_06", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        List<Long> susIds = SimilarServiceHelper.querySimilarList(stdRsmId);
        if (susIds.isEmpty()) {
            return ResManager.loadKDString((String)" \u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        return null;
    }

    public static String stdRsmDetailOpenValidate(FormShowParameter parameter) {
        String isSimpleStdRsm = (String)parameter.getCustomParam("isSimpleStdRsm");
        if (HRStringUtils.isNotEmpty((String)isSimpleStdRsm)) {
            return null;
        }
        Object obj = parameter.getCustomParam("id");
        long stdRsmId = Long.parseLong(obj.toString());
        DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmByMid("tstpm_stdrsm", stdRsmId);
        String dataStatus = rsmDy.getString("datastatus");
        if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            return ResManager.loadKDString((String)"\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"ResumeValidateHelper_06", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        boolean hasStdRsmQueryPermission = CheckPermissionHelper.getInstance().isCurTalentAuth(stdRsmId);
        if (!hasStdRsmQueryPermission && ResumeHisDataStatusEnum.EFFECTING.getStatus().equals(dataStatus)) {
            return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6807\u51c6\u7b80\u5386\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"ResumeValidateHelper_02", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus)) {
            boolean hasPermission = CheckPermissionHelper.getInstance().checkBlackListPermission("47150e89000000ac");
            if (!hasStdRsmQueryPermission && !hasPermission) {
                return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6807\u51c6\u7b80\u5386\u53ca\u9ed1\u540d\u5355\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"ResumeValidateHelper_09", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            }
            if (!hasStdRsmQueryPermission) {
                return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6807\u51c6\u7b80\u5386\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"ResumeValidateHelper_02", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            }
            if (!hasPermission) {
                return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u9ed1\u540d\u5355\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"ResumeValidateHelper_03", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String recycleResumeValidate(IFormView view, long stdRsmId) {
        boolean isHasPerm;
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        String dataStatus = stdRsmDy.getString("datastatus");
        String message = null;
        if (!ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            message = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            view.showErrorNotification(message);
            view.invokeOperation("refresh");
        }
        if (HRStringUtils.isEmpty(message) && !(isHasPerm = AppUtils.checkPagePermission((String)"tstpm_recycle", (String)"47150e89000000ac"))) {
            message = ResManager.loadKDString((String)"\u65e0\"\u7b80\u5386\u56de\u6536\u7ad9\"\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResumeValidateHelper_10", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            view.showErrorNotification(message);
            view.invokeOperation("refresh");
        }
        return message;
    }

    public static String cancelSusValidate(Object stdRsmId, Object similarId, IFormView view) {
        String message = null;
        if (HRObjectUtils.isEmpty((Object)stdRsmId) || HRObjectUtils.isEmpty((Object)similarId)) {
            message = ResManager.loadKDString((String)" \u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.isEmpty(message)) {
            message = ResumeValidateHelper.stdRsmDeleteStateValidate(Long.parseLong(stdRsmId.toString()));
        }
        if (HRStringUtils.isEmpty((String)message)) {
            message = ResumeValidateHelper.stdRsmDeleteStateValidate(Long.parseLong(similarId.toString()));
        }
        if (HRStringUtils.isEmpty((String)message)) {
            message = ResumeValidateHelper.validateSusRelate(Long.parseLong(stdRsmId.toString()), Long.parseLong(similarId.toString()));
        }
        if (HRStringUtils.isEmpty((String)message)) {
            message = ResumeValidateHelper.blacklistStatusChangeValidate(Long.parseLong(stdRsmId.toString()), Long.parseLong(similarId.toString()), view);
        }
        if (HRStringUtils.isEmpty((String)message) && !TalentPoolMgtPermHelper.isSuperUser() && HRStringUtils.isEmpty((String)(message = ResumeValidateHelper.viewStdRsmPermission(Long.parseLong(stdRsmId.toString()))))) {
            message = ResumeValidateHelper.viewStdRsmPermission(Long.parseLong(similarId.toString()));
        }
        return message;
    }

    public static String mergeSusValidate(Object stdRsmId, Object similarId, IFormView view) {
        String message = null;
        if (HRObjectUtils.isEmpty((Object)stdRsmId) || HRObjectUtils.isEmpty((Object)similarId)) {
            message = ResManager.loadKDString((String)" \u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.isEmpty(message)) {
            message = ResumeValidateHelper.stdRsmDeleteStateValidate(Long.parseLong(stdRsmId.toString()));
        }
        if (HRStringUtils.isEmpty((String)message)) {
            message = ResumeValidateHelper.stdRsmDeleteStateValidate(Long.parseLong(similarId.toString()));
        }
        if (HRStringUtils.isEmpty((String)message)) {
            message = ResumeValidateHelper.validateSusRelate(Long.parseLong(stdRsmId.toString()), Long.parseLong(similarId.toString()));
        }
        if (HRStringUtils.isEmpty((String)message)) {
            message = ResumeValidateHelper.blacklistStatusChangeValidate(Long.parseLong(stdRsmId.toString()), Long.parseLong(similarId.toString()), view);
        }
        if (HRStringUtils.isEmpty((String)message)) {
            boolean hasPermission;
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.parseLong(stdRsmId.toString()));
            ids.add(Long.parseLong(similarId.toString()));
            boolean bl = hasPermission = TalentPoolMgtPermHelper.isSuperUser() || CheckPermissionHelper.getInstance().checkSpecialPermission(ids, "1LUUIJBY4C=R");
            if (!hasPermission) {
                message = ResManager.loadKDString((String)"\u60a8\u6682\u65e0 \u5408\u5e76\u5019\u9009\u4eba \u7684\u6743\u9650", (String)"SuspectedResumePlugin_8", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
            }
        }
        return message;
    }

    public static String blacklistStatusChangeValidate(long stdRsmId, long similarId, IFormView view) {
        String message = ResManager.loadKDString((String)" \u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        Boolean originalStdRsmIsBlack = Boolean.parseBoolean(view.getPageCache().get("blackState"));
        Boolean originalSimilarIsBlack = Boolean.parseBoolean(view.getPageCache().get("sus_blackState"));
        Boolean stdRsmIsBlack = TalentListFunService.isStdRsmBlackList(stdRsmId);
        Boolean similarIsBlack = TalentListFunService.isStdRsmBlackList(similarId);
        if (originalStdRsmIsBlack.equals(stdRsmIsBlack) && originalSimilarIsBlack.equals(similarIsBlack)) {
            message = null;
        }
        return message;
    }

    public static String stdRsmDeleteStateValidate(long stdRsmId) {
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmByMid("tstpm_stdrsm", stdRsmId);
        String dataStatus = stdRsmDy.getString("datastatus");
        String message = null;
        if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            message = ResManager.loadKDString((String)" \u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0/\u5173\u95ed\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        return message;
    }

    public static String viewStdRsmPermission(Long stdRsmId) {
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmByMid("tstpm_stdrsm", stdRsmId);
        String dataStatus = stdRsmDy.getString("datastatus");
        String message = null;
        if (ResumeHisDataStatusEnum.EFFECTING.getStatus().equals(dataStatus) && !CheckPermissionHelper.getInstance().isCurTalentAuth(stdRsmId)) {
            message = ResManager.loadKDString((String)"\u65e0\"\u6807\u51c6\u7b80\u5386\"\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResumeValidateHelper_02", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus)) {
            boolean hasPermission = AppUtils.checkPagePermission((String)"tstpm_blacklist", (String)"47150e89000000ac");
            if (!CheckPermissionHelper.getInstance().checkTstpmPermission() || !hasPermission) {
                message = ResManager.loadKDString((String)"\u65e0\"\u9ed1\u540d\u5355\"\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResumeValidateHelper_03", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            }
        }
        return message;
    }

    public static String validateSusRelate(Long stdRsmId, Long similarId) {
        String message = ResManager.loadKDString((String)" \u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0/\u5173\u95ed\u9875\u9762\u3002", (String)"ResumeValidateHelper_07", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        List<Long> susIds = SimilarServiceHelper.querySimilarList(stdRsmId);
        for (Long susId : susIds) {
            if (!similarId.equals(susId)) continue;
            message = null;
        }
        return message;
    }

    public static String validateResumeDetailStatus(Long stdRsmId, String dataStatus) {
        String validate = ResumeValidateHelper.stdRsmDeleteStateValidate(stdRsmId);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            return DATA_STATUS_MAP.get(ResumeHisDataStatusEnum.DELETED.getStatus());
        }
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmByMid("tstpm_stdrsm", stdRsmId);
        String oraStatus = stdRsmDy.getString("datastatus");
        if (!oraStatus.equals(dataStatus)) {
            validate = DATA_STATUS_MAP.get(dataStatus);
        }
        return validate;
    }

    static {
        DATA_STATUS_MAP.put(ResumeHisDataStatusEnum.EFFECTING.getStatus(), ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u4eba\u5458\u5df2\u5728\u9ed1\u540d\u5355\u3002", (String)"StdRsmBusiAppHelper_1", (String)"tsc-tstpm-business", (Object[])new Object[0]));
        DATA_STATUS_MAP.put(ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u4eba\u5458\u5df2\u4e0d\u5728\u9ed1\u540d\u5355\u3002", (String)"StdRsmBusiAppHelper_2", (String)"tsc-tstpm-business", (Object[])new Object[0]));
        DATA_STATUS_MAP.put(ResumeHisDataStatusEnum.DELETED.getStatus(), ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c,\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"ResumeValidateHelper_06", (String)"tsc-tstpm-business", (Object[])new Object[0]));
    }
}

