/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class SimilarServiceHelper {
    private static final Log logger = LogFactory.getLog(SimilarServiceHelper.class);
    private static final String queryField = "stdrsm,similarrsm,stdrsmhis,duplicatetype";

    private SimilarServiceHelper() {
    }

    public static List<Long> querySimilarList(Long stdRsmId) {
        DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        QFilter filter = new QFilter("stdrsm", "=", (Object)rsmDy.getLong("mid"));
        filter.and(new QFilter("duplicatetype", "=", (Object)"1"));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        DynamicObject[] dys = helper.query("similarrsm", new QFilter[]{filter});
        return Arrays.stream(dys).map(dynamicObject -> dynamicObject.getLong("similarrsm")).distinct().collect(Collectors.toList());
    }

    public static void unSuspectStdRsm(Long stdRsmId, Long similarId) {
        DynamicObject[] stdRsmArray = StdRsmServiceHelper.getMidStdRsmIncludeMine(stdRsmId);
        DynamicObject[] simStdRsmArray = StdRsmServiceHelper.getMidStdRsmIncludeMine(similarId);
        ArrayList filters = Lists.newArrayListWithCapacity((int)16);
        Arrays.stream(stdRsmArray).forEach(stdRsm -> Arrays.stream(simStdRsmArray).forEach(simStdRsm -> {
            QFilter deleteFilter = SimilarServiceHelper.getSimilarFilter(stdRsm, simStdRsm);
            filters.add(deleteFilter);
        }));
        logger.info("SimilarServiceHelper.unSuspectStdRsm.deleteFilter:[{}]", (Object)filters);
        QFilter finalQFilter = null;
        for (QFilter filter : filters) {
            finalQFilter = finalQFilter == null ? filter : finalQFilter.or(filter);
        }
        logger.info("StdRsmEntryCheckDuplicateHandler.getEntryFilter:[{}]", finalQFilter);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        DynamicObject[] dys = helper.query(queryField, new QFilter[]{finalQFilter});
        Set<Long> pkIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        logger.info("StdRsmEntryCheckDuplicateHandler.pkIds:[{}]", pkIds);
        helper.delete((Object[])pkIds.toArray(new Long[0]));
    }

    public static Set<Long> querySimilarList(List<Long> stdRsmIds) {
        logger.info("SimilarServiceHelper.querySimilarList.stdRsmIds: [{}]", stdRsmIds);
        QFilter filter = new QFilter("stdrsm", "in", stdRsmIds).and(new QFilter("duplicatetype", "=", (Object)"1"));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        DynamicObject[] dys = helper.query(queryField, new QFilter[]{filter});
        Set similarList = Arrays.stream(dys).map(dy -> dy.getLong("stdrsm")).collect(Collectors.toSet());
        DynamicObject[] stdRsmDys = StdRsmServiceHelper.getStdRsmDys(new ArrayList<Long>(similarList));
        logger.info("SimilarServiceHelper.querySimilarList.similarList :[{}]", similarList);
        Set<Long> similarStdRsmIds = Arrays.stream(stdRsmDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        logger.info("SimilarServiceHelper.querySimilarList.stdRsmIds :[{}]", similarStdRsmIds);
        return similarStdRsmIds;
    }

    public static Long getSysDuplicateDys(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("stdrsm", "in", stdRsmIds);
        filter.and("duplicatetype", "=", (Object)"0");
        String selectProperties = "stdrsmhis,stdrsm";
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        DynamicObject[] simDys = helper.queryOriginalArray(selectProperties, new QFilter[]{filter});
        return simDys.length;
    }

    public static synchronized void recordDuplicateSrdRsm(Long stdRsmId) {
        long stdRsmHis;
        String selectProperties = "id,stdrsm,stdrsmhis";
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        filter.and("duplicatetype", "=", (Object)"0");
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        DynamicObject duplicateDy = helper.queryOne(selectProperties, new QFilter[]{filter});
        if (null == duplicateDy) {
            duplicateDy = SimilarServiceHelper.getSimilarDy(stdRsmId, stdRsmId, "0");
            stdRsmHis = 1L;
        } else {
            stdRsmHis = duplicateDy.getLong("stdrsmhis");
            ++stdRsmHis;
        }
        duplicateDy.set("stdrsmhis", (Object)stdRsmHis);
        SimilarServiceHelper.saveSimilar(new DynamicObject[]{duplicateDy});
    }

    public static synchronized void eachRecordSimilar(Long stdRsmId, Set<Long> similarIds) {
        logger.info("SimilarServiceHelper.eachRecordSimilar.stdRsmId [{}], similarIds:[{}]", (Object)stdRsmId, similarIds);
        Set<Long> noExistSimilar = SimilarServiceHelper.isExistSimilar(stdRsmId, similarIds);
        if (noExistSimilar.isEmpty()) {
            logger.info("SimilarServiceHelper.eachRecordSimilar.noExistSimilar is empty");
            return;
        }
        List<Long> notMergedSimilarIds = StdRsmServiceHelper.getNotMergedSimilarIds(similarIds);
        logger.info("SimilarServiceHelper.eachRecordSimilar.notMergedSimilarIds[{}]", noExistSimilar);
        ArrayList collection = Lists.newArrayListWithExpectedSize((int)16);
        for (Long similarId : notMergedSimilarIds) {
            logger.info("SimilarServiceHelper.eachRecordSimilar.stdRsmId:[{}] similarId[{}]", (Object)stdRsmId, (Object)similarId);
            if (stdRsmId.equals(similarId)) continue;
            collection.add(SimilarServiceHelper.getSimilarDy(stdRsmId, similarId, "1"));
            collection.add(SimilarServiceHelper.getSimilarDy(similarId, stdRsmId, "1"));
        }
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        helper.save(collection.toArray(new DynamicObject[0]));
        logger.info("SimilarServiceHelper.eachRecordSimilar end");
    }

    public static void saveSimilar(DynamicObject[] dys) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        helper.save(dys);
    }

    public static void batchDeleteStdRsmSimData(List<Long> idList) {
        QFilter forQFilter = new QFilter("stdrsm", "in", idList).and("duplicatetype", "=", (Object)"1");
        logger.info("SimilarServiceHelper.batchDeleteStdRsmSimData.forQFilter:[{}]", (Object)forQFilter);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        helper.deleteByFilter(new QFilter[]{forQFilter});
        QFilter backQFilter = new QFilter("similarrsm", "in", idList).and(new QFilter("duplicatetype", "=", (Object)"1"));
        logger.info("SimilarServiceHelper.batchDeleteStdRsmSimData.backQFilter:[{}]", (Object)backQFilter);
        helper.deleteByFilter(new QFilter[]{backQFilter});
    }

    private static QFilter getSimilarFilter(DynamicObject stdRsm, DynamicObject similarDy) {
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsm.getLong("id")).and(new QFilter("similarrsm", "=", (Object)similarDy.getLong("id"))).and(new QFilter("duplicatetype", "=", (Object)"1"));
        QFilter orFilter = new QFilter("similarrsm", "=", (Object)stdRsm.getLong("id")).and(new QFilter("stdrsm", "=", (Object)similarDy.getLong("id"))).and(new QFilter("duplicatetype", "=", (Object)"1"));
        return filter.or(orFilter);
    }

    public static List<DynamicObject> getDyArrayByList(List<Pair<Long, Long>> deleteSimDys) {
        ArrayList dys = Lists.newArrayListWithCapacity((int)16);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        for (Pair<Long, Long> deleteSimDy : deleteSimDys) {
            DynamicObject dy = helper.generateEmptyDynamicObject();
            dy.set("stdrsm", deleteSimDy.getKey());
            dy.set("similarrsm", deleteSimDy.getValue());
            dy.set("duplicatetype", (Object)"1");
            dys.add(dy);
        }
        return dys;
    }

    public static QFilter getSimFilter(Long stdRsmId) {
        return new QFilter("stdrsm", "=", (Object)stdRsmId).or(new QFilter("similarrsm", "=", (Object)stdRsmId)).and(new QFilter("duplicatetype", "=", (Object)"1"));
    }

    private static DynamicObject getSimilarDy(Long stdRsmId, Long similarId, String type) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tstpm_stdrsmsimilar");
        DynamicObject similarDy = new DynamicObject((DynamicObjectType)entityType);
        similarDy.set("stdrsm", (Object)stdRsmId);
        similarDy.set("duplicatetype", (Object)type);
        similarDy.set("similarrsm", (Object)similarId);
        logger.info("SimilarServiceHelper.getSimilarDy.similarRsm:[{}]", (Object)similarId);
        return similarDy;
    }

    public static void updateMergeDys(DynamicObject mergeFrom, DynamicObject mergeTo) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)mergeTo.getDataEntityType().getName());
        QFilter filter = new QFilter("boid", "=", (Object)mergeFrom.getLong("id"));
        filter.or("mid", "=", (Object)mergeFrom.getLong("id"));
        ArrayList updateDyList = Lists.newArrayListWithCapacity((int)16);
        DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{filter});
        Arrays.stream(dys).forEach(dy -> {
            dy.set("mid", (Object)mergeTo.getLong("id"));
            dy.set("ismerge", (Object)"1");
            updateDyList.add(dy);
        });
        updateDyList.add(mergeTo);
        helper.update(updateDyList.toArray(new DynamicObject[0]));
    }

    public static Boolean checkIsMerge(DynamicObject mergeFrom, DynamicObject mergeTo) {
        List<Long> similarList = SimilarServiceHelper.querySimilarList(mergeTo.getLong("id"));
        if (!similarList.contains(mergeFrom.getLong("id"))) {
            return Boolean.TRUE;
        }
        boolean mergeFromIsMerge = mergeFrom.getBoolean("ismerge");
        boolean mergeToIsMerge = mergeTo.getBoolean("ismerge");
        if (mergeFromIsMerge || mergeToIsMerge) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Set<Long> isExistSimilar(Long stdRsmId, Set<Long> similarIds) {
        Set<Long> exists = SimilarServiceHelper.getSimilarByStdRsmId(stdRsmId);
        return Sets.difference(similarIds, exists);
    }

    public static Set<Long> getSimilarByStdRsmId(Long stdRsmId) {
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsmId).and(new QFilter("duplicatetype", "=", (Object)"1"));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        DynamicObject[] dys = helper.query(queryField, new QFilter[]{filter});
        return Arrays.stream(dys).map(dy -> dy.getLong("similarrsm")).collect(Collectors.toSet());
    }

    public static Map<Long, List<Long>> querySimilarListEachOther(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("stdrsm", "in", stdRsmIds).and(new QFilter("duplicatetype", "=", (Object)"1"));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsmsimilar");
        DynamicObject[] dys = helper.queryOriginalArray(queryField, new QFilter[]{filter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (null != dys && dys.length > 0) {
            for (DynamicObject dy : dys) {
                List similarIds;
                Long stdRsmId = dy.getLong("stdrsm");
                long similarRsmId = dy.getLong("similarrsm");
                List list = similarIds = result.get(stdRsmId) == null ? (List)result.get(similarRsmId) : (List)result.get(stdRsmId);
                if (!stdRsmIds.contains(similarRsmId)) continue;
                if (null == similarIds) {
                    similarIds = Lists.newArrayListWithCapacity((int)16);
                    similarIds.add(dy.getLong("similarrsm"));
                    result.put(stdRsmId, similarIds);
                    continue;
                }
                if (similarIds.contains(stdRsmId) || similarIds.contains(similarRsmId)) continue;
                similarIds.add(similarRsmId);
            }
        }
        return result;
    }
}

