/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.helper;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tstpm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tstpm.business.domain.stdrsm.helper.HistoryServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TrackRecSumServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class StandardResumeDataHelper {
    private static final Log logger = LogFactory.getLog(StandardResumeDataHelper.class);
    private static final HRBaseServiceHelper BOS_USER_HELPER = new HRBaseServiceHelper("bos_user");
    private static HRBaseServiceHelper stdRsmServiceHelper = new HRBaseServiceHelper("tstpm_stdrsm");

    public static DynamicObject queryOne(Long id) {
        return stdRsmServiceHelper.loadSingle((Object)id);
    }

    public static DynamicObject[] batchQuerySelectFieldsyById(List<Long> stdRsmIdList, String selectFields) {
        QFilter qFilter = new QFilter("id", "in", stdRsmIdList);
        DynamicObject[] dys = stdRsmServiceHelper.query(selectFields, new QFilter[]{qFilter});
        return dys;
    }

    public static DynamicObject[] queryStdRsmByIds(List<Long> stdRsmIdList) {
        return stdRsmServiceHelper.loadDynamicObjectArray(stdRsmIdList.toArray());
    }

    public static DynamicObject[] queryBosUserByQFilter(List<Long> userIds) {
        QFilter qFilter = new QFilter("id", "in", userIds);
        return BOS_USER_HELPER.query("id,name,email,phone,useropenid", qFilter.toArray());
    }

    public static void updateTrackTime(long id, Date trackTime, DynamicObject jobStatusObj) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject stdResumeDo = stdRsmServiceHelper.loadDynamicObject(qFilter);
        if (stdResumeDo.getDynamicObject("jobstatus") != null && stdResumeDo.getDynamicObject("jobstatus").get("id").equals(jobStatusObj.get("id"))) {
            HashMap<String, Object> updateMap = new HashMap<String, Object>(1);
            updateMap.put("tracktime", trackTime);
            Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
            resumeService.init(stdResumeDo);
            resumeService.updateStdRsmWithNoHistory(id, updateMap);
        } else {
            stdResumeDo.set("jobstatus", (Object)jobStatusObj);
            stdResumeDo.set("tracktime", (Object)trackTime);
            HRMPOperationServiceImpl service = new HRMPOperationServiceImpl("tstpm_stdrsm");
            OperateOption option = OperateOption.create();
            service.invokeOperation("save", new DynamicObject[]{stdResumeDo}, option);
            HashMap<String, Object> updateMap = new HashMap<String, Object>(1);
            updateMap.put("tracktime", trackTime);
            HistoryServiceHelper.singleUpdateHisStdRsm(id, updateMap);
        }
    }

    public static void updateModifyTime(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] stdResumeDo = stdRsmServiceHelper.loadDynamicObjectArray(qFilter.toArray());
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (int i = 0; i < stdResumeDo.length; ++i) {
            stdResumeDo[i].set("modifytime", (Object)updateDate);
        }
        stdRsmServiceHelper.update(stdResumeDo);
    }

    public static void updateStdRsmUpdTime(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] stdRsmDo = stdRsmServiceHelper.loadDynamicObjectArray(qFilter.toArray());
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (int i = 0; i < stdRsmDo.length; ++i) {
            stdRsmDo[i].set("stdrsmupdtime", (Object)updateDate);
        }
        stdRsmServiceHelper.update(stdRsmDo);
    }

    public static void updateStdRsmMerge(List<Long> stdRsmIds) {
        HashMap<Long, Map<String, Object>> updateMaps = new HashMap<Long, Map<String, Object>>(stdRsmIds.size());
        TalentListServiceHelper.getInstance().setPositionNumData(updateMaps, stdRsmIds);
        TalentListServiceHelper.getInstance().setRecStatus(updateMaps, stdRsmIds);
        TalentListServiceHelper.getInstance().setTalentPoolNumData(updateMaps, stdRsmIds);
        for (Long stdRsmId : stdRsmIds) {
            StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, (Map)updateMaps.get(stdRsmId));
        }
    }

    public static void updateStdRsmTalentPool(List<Long> stdRsmIds) {
        HashMap<Long, Map<String, Object>> updateMaps = new HashMap<Long, Map<String, Object>>(stdRsmIds.size());
        TalentListServiceHelper.getInstance().setTalentPoolNumData(updateMaps, stdRsmIds);
        Date date1 = new Date();
        for (Long stdRsmId : stdRsmIds) {
            if (((Map)updateMaps.get(stdRsmId)).size() == 0) continue;
            StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, (Map)updateMaps.get(stdRsmId));
        }
        Date date2 = new Date();
        logger.info("\u6d4b\u8bd5\u6dfb\u52a0\u79fb\u9664\u4eba\u624d\u5e93\u65f6\u957f\uff1a", (Object)(date2.getTime() - date1.getTime()));
    }

    public static void updateStdRsmTalent(Long stdRsmId, Map<String, Object> updateMap) {
        logger.info("StandardResumeDataHelper.updateStdRsmTalent.stdRsmId:[{}].updateMap:[{}]", (Object)stdRsmId, updateMap);
        if (updateMap.get("jobstatus") != null) {
            QFilter qFilter = new QFilter("id", "=", (Object)stdRsmId);
            DynamicObject stdResumeDo = stdRsmServiceHelper.loadDynamicObject(qFilter);
            long mid = stdResumeDo.getLong("mid");
            if (stdRsmId != mid) {
                stdResumeDo = stdRsmServiceHelper.loadSingle((Object)mid);
            }
            DynamicObject jobStatusDo = stdResumeDo.getDynamicObject("jobstatus");
            Long jobStatusId = Optional.ofNullable(jobStatusDo).map(jvalue -> jvalue.getLong("id")).orElse(0L);
            Object jobStatusIdNew = updateMap.get("jobstatus");
            if (!StringUtils.equals((CharSequence)String.valueOf(jobStatusIdNew), (CharSequence)String.valueOf(jobStatusId))) {
                Object jobStatus = updateMap.get("jobstatus");
                if (jobStatus instanceof String) {
                    HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsrbd_jobstatus");
                    stdResumeDo.set("jobstatus", (Object)helper.loadSingle((Object)Long.valueOf(jobStatus.toString())));
                } else {
                    stdResumeDo.set("jobstatus", jobStatus);
                }
                HRMPOperationServiceImpl service = new HRMPOperationServiceImpl("tstpm_stdrsm");
                OperateOption option = OperateOption.create();
                logger.info("StandardResumeDataHelper.updateStdRsmTalent.customsave.stdResumeDo[{}]:", (Object)stdResumeDo);
                service.invokeOperation("customsave", new DynamicObject[]{stdResumeDo}, option);
            }
        } else {
            Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
            logger.info("StandardResumeDataHelper.updateStdRsmTalent.resumeService[{}]:", updateMap);
            resumeService.updateStdRsmWithNoHistory(stdRsmId, updateMap);
        }
    }

    public static List<Long> getMergeStdIds(List<Long> id) {
        ArrayList<Long> stdIds = new ArrayList<Long>(16);
        QFilter qFilter = new QFilter("mid", "in", id);
        qFilter.and(new QFilter("ismerge", "=", (Object)"1"));
        DynamicObject[] stdResumeDos = stdRsmServiceHelper.query("id", new QFilter[]{qFilter});
        if (stdResumeDos.length > 0) {
            for (DynamicObject dynObj : stdResumeDos) {
                stdIds.add(dynObj.getLong("id"));
            }
        }
        return stdIds;
    }

    public static List<Long> getMainStdIds(List<Long> ids) {
        DynamicObject[] stdResumeDos;
        ArrayList<Long> stdIds = new ArrayList<Long>(16);
        QFilter qFilter = new QFilter("id", "in", ids);
        for (DynamicObject dynamicObject : stdResumeDos = stdRsmServiceHelper.query("id,mid", new QFilter[]{qFilter})) {
            if (dynamicObject.get("mid") == null) continue;
            stdIds.add(dynamicObject.getLong("mid"));
        }
        return TrackRecSumServiceHelper.removeDuplicate(stdIds);
    }

    public static Long getMasterCandidateId(Long stdRsmId) {
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        boolean isMerge = stdRsmDy.getBoolean("ismerge");
        Long masterCandidateId = stdRsmId;
        if (Boolean.TRUE == isMerge) {
            masterCandidateId = stdRsmDy.getLong("mid");
        }
        return masterCandidateId;
    }

    public static Map<Long, DynamicObject> batchQueryStdRsmToMap(List<Long> stdRsmIdList) {
        DynamicObject[] stdRsms = StandardResumeDataHelper.queryStdRsmByIds(stdRsmIdList);
        HashMap stdRsmMap = Maps.newHashMapWithExpectedSize((int)stdRsmIdList.size());
        for (DynamicObject stdRsm : stdRsms) {
            stdRsmMap.put(stdRsm.getLong("id"), stdRsm);
        }
        return stdRsmMap;
    }

    public static void updateStdRsmByHighestEdu(long stdRsmId, DynamicObject highestEdu) {
        HashMap updateParamMap = Maps.newHashMapWithExpectedSize((int)4);
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (highestEdu != null) {
            Long education = highestEdu.getDynamicObject("education").getLong("id");
            Long school = highestEdu.getDynamicObject("schoolname").getLong("id");
            Long educationForm = highestEdu.getDynamicObject("educationform").getLong("id");
            String specialtyName = highestEdu.getString("specialtyname");
            updateParamMap.put("highesteducation", education);
            updateParamMap.put("highesteduschool", school);
            updateParamMap.put("educationform", educationForm);
            updateParamMap.put("highestspecialty", specialtyName);
            updateParamMap.put("stdrsmupdtime", updateDate);
        } else {
            updateParamMap.put("highesteducation", null);
            updateParamMap.put("highesteduschool", null);
            updateParamMap.put("educationform", null);
            updateParamMap.put("highestspecialty", null);
            updateParamMap.put("stdrsmupdtime", updateDate);
        }
        StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, updateParamMap);
    }

    public static void updateStdRsmByRecentWorkExp(long stdRsmId, DynamicObject recentWorkExp) {
        HashMap updateParamMap = Maps.newHashMapWithExpectedSize((int)4);
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (recentWorkExp != null) {
            Long posCat = recentWorkExp.getDynamicObject("poscat") != null ? Long.valueOf(recentWorkExp.getDynamicObject("poscat").getLong("id")) : null;
            String positionName = recentWorkExp.getString("positionname");
            String companyName = recentWorkExp.getString("companyname");
            Long industryType = recentWorkExp.getDynamicObject("industrytype") != null ? Long.valueOf(recentWorkExp.getDynamicObject("industrytype").getLong("id")) : null;
            updateParamMap.put("poscat", posCat);
            updateParamMap.put("recentposition", positionName);
            updateParamMap.put("recentcompany", companyName);
            updateParamMap.put("industrytype", industryType);
            updateParamMap.put("stdrsmupdtime", updateDate);
        } else {
            updateParamMap.put("poscat", null);
            updateParamMap.put("recentposition", null);
            updateParamMap.put("recentcompany", null);
            updateParamMap.put("industrytype", null);
            updateParamMap.put("stdrsmupdtime", updateDate);
        }
        StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, updateParamMap);
    }

    public static void updateStdRsmActivationInfo(String actionId, List<Long> stdRsmIds) {
        for (Long stdRsmId : stdRsmIds) {
            Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
            HashMap<String, Object> updateMap = new HashMap<String, Object>(2);
            switch (actionId) {
                case "btn_invite": {
                    updateMap.put("activationmode", CfgMsgScenes.TALENT_UPDATE_RESUME.getBaseDataId());
                    updateMap.put("activationtime", updateDate);
                    StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, updateMap);
                    break;
                }
                case "btn_invitedelivery": {
                    updateMap.put("activationmode", CfgMsgScenes.TALENT_DELIVER_RESUME.getBaseDataId());
                    updateMap.put("activationtime", updateDate);
                    StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, updateMap);
                    break;
                }
            }
        }
    }

    public static DynamicObject queryOneByFilter(String selectProperties, QFilter[] qFilters) {
        return stdRsmServiceHelper.queryOne(selectProperties, qFilters);
    }

    public static boolean isCandidateInBlacklist(long stdRsmId) {
        QFilter qFilter = new QFilter("id", "=", (Object)stdRsmId);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        qFilter.and("datastatus", "=", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
        return stdRsmServiceHelper.isExists(qFilter);
    }

    private StandardResumeDataHelper() {
    }
}

