/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.common.utils.CandidateSortUtil;

public class StdRsmServiceHelper {
    private static final Log logger = LogFactory.getLog(StdRsmServiceHelper.class);

    private StdRsmServiceHelper() {
    }

    public static DynamicObject getStdRsmByMid(String entryNumber, Long stdRsmId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entryNumber);
        DynamicObject rsm = helper.loadSingle((Object)stdRsmId);
        if (rsm.getLong("id") != rsm.getLong("mid")) {
            QFilter filter = new QFilter("id", "=", (Object)rsm.getLong("mid"));
            rsm = helper.loadDynamicObject(filter);
        }
        return rsm;
    }

    public static DynamicObject getStdRsmDy(Long stdRsmId) {
        DynamicObject single;
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        if (StdRsmServiceHelper.existDy(stdRsmId, "tstpm_stdrsm")) {
            single = helper.loadSingle((Object)stdRsmId);
        } else {
            single = helper.generateEmptyDynamicObject();
            single.set("id", (Object)stdRsmId);
        }
        return single;
    }

    public static DynamicObject[] getStdRsmDys(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("id", "in", stdRsmIds);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        return helper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static DynamicObject[] getMidStdRsmIds(Long stdRsmId) {
        QFilter filter = new QFilter("mid", "=", (Object)stdRsmId);
        QFilter fidFilter = new QFilter("id", "!=", (Object)stdRsmId);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        String selectFields = "id,mid";
        QFilter[] filters = new QFilter[]{filter.and(fidFilter)};
        return helper.query(selectFields, filters);
    }

    public static DynamicObject[] getMidStdRsmIncludeMine(Long stdRsmId) {
        QFilter filter = new QFilter("mid", "=", (Object)stdRsmId);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        String selectFields = "id,mid";
        QFilter[] filters = new QFilter[]{filter};
        return helper.queryOriginalArray(selectFields, filters);
    }

    public static Map<Long, Long> getMidStdRsmIdsRelation(List<Long> stdRsmIds) {
        logger.info("StdRsmServiceHelper.getMidStdRsmIdsRelation.resultMap:[{}]", stdRsmIds);
        QFilter filter = new QFilter("mid", "in", stdRsmIds);
        filter.and("sourcevid", "!=", (Object)0L);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        String selectFields = "id,mid";
        DynamicObject[] rsmDys = helper.query("id,mid", new QFilter[]{filter});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdRsmIds.size());
        for (Long stdRsmId : stdRsmIds) {
            Arrays.stream(rsmDys).filter(dy -> dy.getLong("id") == stdRsmId.longValue()).forEach(dy -> resultMap.put(stdRsmId, dy.getLong("mid")));
        }
        logger.info("StdRsmServiceHelper.getMidStdRsmIdsRelation.resultMap:[{}]", (Object)resultMap);
        return resultMap;
    }

    public static Map<Long, List<Long>> getMidStdRsm(List<Long> stdRsmIds) {
        logger.info("StdRsmServiceHelper.getMidStdRsmIdsRelation.stdRsmIds:[{}]", stdRsmIds);
        DynamicObject[] dys = StdRsmServiceHelper.getStdRsmDys(stdRsmIds);
        List midList = Arrays.stream(dys).map(dy -> dy.getLong("mid")).collect(Collectors.toList());
        logger.info("StdRsmServiceHelper.getMidStdRsmIdsRelation.midList:[{}]", midList);
        midList.addAll(stdRsmIds);
        QFilter filter = new QFilter("mid", "in", midList);
        filter.and("sourcevid", "!=", (Object)0L);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
        String selectFields = "id,mid";
        DynamicObject[] rsmDys = helper.query("id,mid", new QFilter[]{filter});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)midList.size());
        for (DynamicObject rsmDy : rsmDys) {
            long mid = rsmDy.getLong("mid");
            List list = resultMap.getOrDefault(mid, Lists.newArrayListWithCapacity((int)16));
            list.add(rsmDy.getLong("id"));
            resultMap.put(mid, list);
        }
        logger.info("StdRsmServiceHelper.getMidStdRsmIdsRelation.resultMap:[{}]", (Object)resultMap);
        return resultMap;
    }

    public static boolean existDy(Long id, String entryNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entryNumber);
        return helper.isExists((Object)id);
    }

    public static DynamicObject[] getEntryDys(String entryNumber, Long stdRsmId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entryNumber);
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        Long vid = stdRsmDy.getLong("sourcevid");
        QFilter filter = new QFilter("stdrsm", "=", (Object)vid);
        return helper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static List<DynamicObject> getEntryDysOrdered(String entryNumber, Long stdRsmId) {
        DynamicObject[] entryDys = StdRsmServiceHelper.getEntryDys(entryNumber, stdRsmId);
        List entryDysOrdered = Lists.newArrayListWithCapacity((int)entryDys.length);
        if (entryDys.length > 0) {
            entryDysOrdered = CandidateSortUtil.sortExperience((DynamicObject[])entryDys, (String)"startdate", (String)"endingdate", (String)"createtime");
        }
        return entryDysOrdered;
    }

    public static List<Long> getNotMergedSimilarIds(Set<Long> similarIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", similarIds).and("ismerge", "=", (Object)"0");
        DynamicObject[] dys = helper.query(new QFilter[]{qFilter});
        return Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static void singleUpdateCurrStdRsm(Long stdRsmId, Map<String, Object> updateMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
        DynamicObject updateDy = helper.loadSingle((Object)stdRsmId);
        for (Map.Entry<String, Object> entry : updateMap.entrySet()) {
            updateDy.set(entry.getKey(), entry.getValue());
        }
        helper.update(new DynamicObject[]{updateDy});
    }

    public static void updateStdRsmModifyTime(Long stdRsmId) {
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        HashMap<String, Object> updateMap = new HashMap<String, Object>(1);
        updateMap.put("modifytime", now);
        StdRsmServiceHelper.singleUpdateCurrStdRsm(stdRsmId, updateMap);
    }

    public static List<Long> getStdRsmSouId(List<Long> ids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] stdResumeDos = helper.query("sourcevid", new QFilter[]{qFilter});
        return Arrays.stream(stdResumeDos).map(dy -> dy.getLong("sourcevid")).collect(Collectors.toList());
    }

    public static List<Long> getSouStdRsmMid(List<Long> souIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("sourcevid", "in", souIds);
        DynamicObject[] stdResumeDos = helper.query("mid", new QFilter[]{qFilter});
        return Arrays.stream(stdResumeDos).map(dy -> dy.getLong("mid")).collect(Collectors.toList());
    }

    public static List<Long> getDelStdRsmId(List<Long> stdRsmIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", stdRsmIds);
        qFilter.and(new QFilter("datastatus", "=", (Object)ResumeHisDataStatusEnum.DELETED.getStatus()));
        DynamicObject[] stdRsmDelDynObj = helper.query("id", new QFilter[]{qFilter});
        return Arrays.stream(stdRsmDelDynObj).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getBlackListStdRsmId(List<Long> stdRsmIds) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", stdRsmIds);
        qFilter.and(new QFilter("datastatus", "=", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus()));
        DynamicObject[] stdRsmBlackDynObj = helper.query("id", new QFilter[]{qFilter});
        return Arrays.stream(stdRsmBlackDynObj).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static DynamicObject[] getStdRsmByDataStatus(List<Object> stdRsmList, ResumeHisDataStatusEnum ... statusEnum) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        QFilter filter = new QFilter("id", "in", stdRsmList);
        List status = Arrays.stream(statusEnum).map(ResumeHisDataStatusEnum::getStatus).collect(Collectors.toList());
        filter.and("datastatus", "in", status);
        return helper.loadDynamicObjectArray(new QFilter[]{filter});
    }
}

