/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.retry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tstpm.business.domain.stdrsm.retry.ResumeRetry;

public abstract class AbstractResumeRetry
implements ResumeRetry {
    protected final Log logger = LogFactory.getLog(AbstractResumeRetry.class);
    private Integer tryTimes = 10;
    private Integer intervalTime = 1;
    protected static final String IS_SUCCESS = "IS_SUCCESS";
    protected static final String EXECUTE_RESULT = "EXECUTE_RESULT";

    @Override
    public void setRetryTime(int time) {
        this.tryTimes = time;
    }

    @Override
    public void setIntervalTime(Integer intervalTime) {
        this.intervalTime = intervalTime;
    }

    @Override
    public Object retryBiz(Object obj) throws InterruptedException {
        int retryNum = 1;
        Map<Object, Object> result = Maps.newHashMapWithExpectedSize((int)2);
        while (retryNum <= this.tryTimes) {
            try {
                result = this.execute(obj);
                if (((Boolean)result.get(IS_SUCCESS)).booleanValue()) {
                    this.logger.info("AbstractResumeRetry.retryBiz.success.retryNum:[{}]", (Object)retryNum);
                    break;
                }
                TimeUnit.SECONDS.sleep(this.intervalTime.intValue());
                ++retryNum;
            }
            catch (Exception e) {
                ++retryNum;
                TimeUnit.SECONDS.sleep(this.intervalTime.intValue());
            }
        }
        return result.get(EXECUTE_RESULT);
    }

    protected abstract Map<String, Object> execute(Object var1);
}

