/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.runnable;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.duplicate.IDuplicateService;

public class CheckSimilarRunnable
implements Runnable {
    private final DynamicObject[] dys;
    private final String entryNumber;
    private final List<String> duplicates;

    public CheckSimilarRunnable(DynamicObject[] dys, String entryNumber, List<String> duplicates) {
        this.duplicates = duplicates;
        this.entryNumber = entryNumber;
        this.dys = dys;
    }

    @Override
    public void run() {
        Arrays.stream(this.dys).forEach(dy -> {
            DynamicObjectType type = dy.getDynamicObjectType();
            DynamicObjectCollection rsmCollection = new DynamicObjectCollection(type, null);
            rsmCollection.add(dy);
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            params.put(type.getName(), rsmCollection);
            long vid = dy.getLong("sourcevid");
            this.duplicates.forEach(pageNumber -> {
                DynamicObject[] subDys = StdRsmServiceHelper.getEntryDys(pageNumber, vid);
                if (subDys.length > 0) {
                    MainEntityType subType = EntityMetadataCache.getDataEntityType((String)pageNumber);
                    DynamicObjectCollection subCollection = new DynamicObjectCollection((DynamicObjectType)subType, null);
                    subCollection.addAll(Arrays.asList(subDys));
                    params.put(pageNumber, subCollection);
                }
            });
            IDuplicateService duplicateService = new IDuplicateService(this.entryNumber);
            duplicateService.doCheckSimilar(params);
        });
    }
}

