/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.duplicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tstpm.business.domain.stdrsm.handler.config.DuplicateConfig;
import kd.tsc.tstpm.business.domain.stdrsm.handler.duplicate.Handler;
import kd.tsc.tstpm.business.domain.stdrsm.handler.entity.CandidateContext;
import kd.tsc.tstpm.business.domain.stdrsm.handler.entity.Context;
import kd.tsc.tstpm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.duplicate.DuplicateService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmOpRecordService;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractDuplicateService
implements DuplicateService {
    protected StdRsmOpRecordService rsmOpRecordService = StdRsmOpRecordService.getInstance();
    protected final List<Handler> handlers = Lists.newArrayListWithCapacity((int)16);
    protected String mainEntryNumber;
    protected final int HOLD = 10000;
    protected final Log logger = LogFactory.getLog(AbstractDuplicateService.class);

    public AbstractDuplicateService(String mainEntryNumber) {
        this.mainEntryNumber = mainEntryNumber;
    }

    protected Context getDuplicateContextFactory(Map<String, DynamicObjectCollection> map) {
        CandidateContext context = new CandidateContext();
        DynamicObject mainDynamicObject = this.getMainDynamicObject(map);
        String mainEntryNumber = mainDynamicObject.getDataEntityType().getName();
        this.logger.info("AbstractDuplicateService.mainEntryNumber.mainEntryNumber\u3010{}\u3011", (Object)mainEntryNumber);
        context.setResumeMainDy(mainDynamicObject);
        for (Map.Entry<String, DynamicObjectCollection> entry : map.entrySet()) {
            DynamicObjectCollection collection = entry.getValue();
            String entryNumber = entry.getKey();
            if (entryNumber.equals(mainEntryNumber)) continue;
            context.setDyMap(entryNumber, collection);
        }
        return context;
    }

    protected void buildHandlerChain(DynamicObject[] configs, Map<String, DynamicObjectCollection> params) {
        this.handlers.clear();
        for (DynamicObject config : configs) {
            String handlerClass = config.getString("handlerclass");
            Handler instance = this.getInstance(handlerClass);
            Map<String, List<String>> checkParam = DuplicateConfig.getCheckParam(config);
            if (checkParam.isEmpty()) continue;
            instance.init(params, checkParam);
            this.handlers.add(instance);
        }
    }

    protected Handler getInstance(String handlerClass) {
        try {
            Class<?> handle = Class.forName(handlerClass);
            return (Handler)handle.newInstance();
        }
        catch (Exception e) {
            ErrorCode errorCode = new ErrorCode("AbstractDuplicateService.getInstance", e.getMessage());
            throw new KDException(errorCode, new Object[0]);
        }
    }

    @Override
    public void mergeStdRsm(DynamicObject mergeFrom, DynamicObject mergeTo) {
        this.logger.info("SimilarServiceHelper.mergeStdRsm.mergeFrom [{}] mergeTo:[{}]", (Object)mergeFrom.getLong("mid"), (Object)mergeTo.getLong("mid"));
        this.beforeMergeStdRsm(mergeFrom, mergeTo);
        QFilter simFilter = SimilarServiceHelper.getSimFilter(mergeFrom.getLong("id"));
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)this.mainEntryNumber);
        DynamicObject[] simDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{simFilter});
        Set<Long> updateSimDys = AbstractDuplicateService.getSimDyIds(simDys, mergeFrom.getLong("id"), mergeTo.getLong("id"));
        SimilarServiceHelper.updateMergeDys(mergeFrom, mergeTo);
        serviceHelper.deleteByFilter(new QFilter[]{simFilter});
        if (!updateSimDys.isEmpty()) {
            ArrayList saveSimDys = Lists.newArrayListWithCapacity((int)16);
            for (Long simDy : updateSimDys) {
                saveSimDys.add(Pair.of((Object)simDy, (Object)mergeTo.getLong("id")));
                saveSimDys.add(Pair.of((Object)mergeTo.getLong("id"), (Object)simDy));
            }
            List<DynamicObject> saveList = SimilarServiceHelper.getDyArrayByList(saveSimDys);
            serviceHelper.save(saveList.toArray(new DynamicObject[0]));
        }
        this.afterMergeStdRsm(mergeFrom, mergeTo);
    }

    @Override
    public void unSuspectStdRsm(Long stdRsmId, Long similarId) {
        SimilarServiceHelper.unSuspectStdRsm(stdRsmId, similarId);
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)this.mainEntryNumber);
        QFilter filter = new QFilter("id", "in", (Object)ImmutableList.of((Object)stdRsmId, (Object)similarId));
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        StdRsmOpRecordService.getInstance().cancelSuspectedOR(dys);
    }

    @Override
    public Map<Long, Boolean> batchQuerySimilarList(List<Long> stdRsmIds) {
        Map<Long, List<Long>> midStdRsmIdsRelation = StdRsmServiceHelper.getMidStdRsm(stdRsmIds);
        Set<Long> midList = midStdRsmIdsRelation.keySet();
        this.logger.info("SimilarServiceHelper.batchQuerySimilarList.midList:[{}]", midList);
        QFilter filter = new QFilter("stdrsm", "in", midList).and(new QFilter("duplicatetype", "=", (Object)"1"));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)this.mainEntryNumber);
        DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{filter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)stdRsmIds.size());
        if (dys.length == 0) {
            return result;
        }
        for (Long stdRsmId : stdRsmIds) {
            Optional<DynamicObject> optional = Arrays.stream(dys).filter(dy -> {
                long mid = dy.getLong("stdrsm");
                List list = (List)midStdRsmIdsRelation.get(mid);
                return list.contains(stdRsmId);
            }).findFirst();
            if (optional.isPresent()) {
                result.put(stdRsmId, Boolean.TRUE);
                continue;
            }
            result.put(stdRsmId, Boolean.FALSE);
        }
        this.logger.info("SimilarServiceHelper.batchQuerySimilarList.result:[{}]", (Object)result);
        return result;
    }

    private static Set<Long> getSimDyIds(DynamicObject[] dys, Long mergeFromId, Long mergeToId) {
        HashSet simDyIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject simDy : dys) {
            Long simId;
            Long id = simDy.getLong("stdrsm");
            if (!mergeFromId.equals(id) && !mergeToId.equals(id)) {
                simDyIds.add(id);
            }
            if (mergeFromId.equals(simId = Long.valueOf(simDy.getLong("similarrsm"))) || mergeToId.equals(simId)) continue;
            simDyIds.add(simId);
        }
        return simDyIds;
    }

    protected abstract DynamicObject getMainDynamicObject(Map<String, DynamicObjectCollection> var1);

    protected abstract void beforeMergeStdRsm(DynamicObject var1, DynamicObject var2);

    protected abstract void afterMergeStdRsm(DynamicObject var1, DynamicObject var2);
}

