/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.duplicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.business.domain.commrec.service.CommrecHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.business.domain.stdrsm.handler.config.DuplicateConfig;
import kd.tsc.tstpm.business.domain.stdrsm.handler.duplicate.Handler;
import kd.tsc.tstpm.business.domain.stdrsm.handler.entity.Context;
import kd.tsc.tstpm.business.domain.stdrsm.helper.BlacklistDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeAttentionHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.runnable.MultiFutureThread;
import kd.tsc.tstpm.business.domain.stdrsm.service.duplicate.AbstractDuplicateService;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.common.utils.ResumeDyUtil;

public class IDuplicateService
extends AbstractDuplicateService {
    public IDuplicateService(String mainEntryNumber) {
        super(mainEntryNumber);
    }

    @Override
    public Context doCheckDuplicate(Map<String, DynamicObjectCollection> params, Boolean recordLogger) {
        Context context = this.getDuplicateContextFactory(params);
        String entryNumber = context.getResumeMainDy().getDynamicObjectType().getName();
        this.logger.info("IDuplicateService.doPreciseCheck.entryNumber:[{}]", (Object)entryNumber);
        DynamicObject[] configs = DuplicateConfig.getConfig(entryNumber, "0", null);
        this.logger.info("IDuplicateService.doCheckDuplicate.configs:[{}]", (Object)SerializationUtils.toJsonString((Object)configs));
        this.buildHandlerChain(configs, params);
        for (Handler handler : this.handlers) {
            handler.doPreciseCheck(context);
            Set<Long> duplicateRsm = context.getDuplicateRsm();
            if (duplicateRsm.isEmpty()) continue;
            handler.logger(context, recordLogger);
            if (!recordLogger.booleanValue()) continue;
            break;
        }
        return context;
    }

    @Override
    public void doCheckSimilar(Map<String, DynamicObjectCollection> params) {
        Context context = this.getDuplicateContextFactory(params);
        String entryNumber = context.getResumeMainDy().getDynamicObjectType().getName();
        this.logger.info("IDuplicateService.doCheckSimilar.entryNumber:[{}]", (Object)entryNumber);
        DynamicObject[] configs = DuplicateConfig.getConfig(entryNumber, "1", null);
        this.buildHandlerChain(configs, params);
        this.logger.info("IDuplicateService.doCheckSimilar.configs:[{}]", (Object)SerializationUtils.toJsonString((Object)configs));
        for (Handler handler : this.handlers) {
            handler.doFuzzyQuery(context);
        }
        Set<Long> similarIds = context.getSimilarIds();
        if (!similarIds.isEmpty()) {
            long stdRsmId = context.getResumeMainDy().getLong("mid");
            this.logger.info("IDuplicateService.doFuzzyQuery.stdRsmId:[{}]:similarIds:[{}]", (Object)stdRsmId, similarIds);
            SimilarServiceHelper.eachRecordSimilar(stdRsmId, similarIds);
        }
    }

    @Override
    public Long getSysDuplicateDys(List<Long> stdRsmIds) {
        List stdRsmIdList = ResumeDyUtil.carveUpListByStep(stdRsmIds, (int)10000);
        MultiFutureThread thread = new MultiFutureThread(stdRsmIdList.size(), 10000);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        stdRsmIdList.forEach(list -> {
            MultiFutureThread<Long> futureThread = thread.setCallable(() -> SimilarServiceHelper.getSysDuplicateDys(list));
            List<Long> execute = futureThread.execute();
            result.addAll(execute);
        });
        return result.stream().mapToLong(Long::longValue).sum();
    }

    @Override
    protected DynamicObject getMainDynamicObject(Map<String, DynamicObjectCollection> map) {
        return (DynamicObject)map.get(this.mainEntryNumber).get(0);
    }

    @Override
    public void beforeMergeStdRsm(DynamicObject mergeFrom, DynamicObject mergeTo) {
        String mergeFromDataStatus = mergeFrom.getString("datastatus");
        String mergeToDataStatus = mergeTo.getString("datastatus");
        boolean isBlackList = ResumeDyUtil.equals((String)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (String[])new String[]{mergeFromDataStatus, mergeToDataStatus});
        if (isBlackList) {
            mergeTo.set("datastatus", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
            Long mergeFromId = mergeFrom.getLong("mid");
            Long mergeToId = mergeTo.getLong("mid");
            DynamicObject blackListDy = BlacklistDataHelper.loadSingle((List<Long>)ImmutableList.of((Object)mergeFromId, (Object)mergeToId));
            Optional.ofNullable(blackListDy).ifPresent(dy -> {
                mergeTo.set("blareason", dy.get("blareason"));
                mergeTo.set("blatime", dy.get("createtime"));
                mergeTo.set("addsource", dy.get("addsource"));
            });
        }
        AppFileMService.mergeCandidate(mergeTo.getLong("id"), mergeFrom.getLong("id"));
        String message = null;
        if (isBlackList && !mergeToDataStatus.equals(ResumeHisDataStatusEnum.BLACK_LIST.getStatus())) {
            message = ResManager.loadKDString((String)"\uff0c\u5f53\u524d\u7b80\u5386\u88ab\u52a0\u5165\u9ed1\u540d\u5355\u3002", (String)"StdRsmORStructText_16", (String)"tsc-tstpm-business", (Object[])new Object[0]);
        }
        this.rsmOpRecordService.mergeCandidatesOR(mergeFrom, mergeTo, message);
    }

    @Override
    public void afterMergeStdRsm(DynamicObject mergeFrom, DynamicObject mergeTo) {
        TalentListFunService.updateReserveRecord(mergeFrom, mergeTo);
        ResumeAttentionHelper.updateMyAttention(mergeFrom, mergeTo);
        CommrecHelper.updateCommsrcentry((DynamicObject)mergeFrom, (DynamicObject)mergeTo);
        ArrayList<Long> stdRsmIds = new ArrayList<Long>(1);
        stdRsmIds.add(mergeTo.getLong("id"));
        StandardResumeDataHelper.updateStdRsmMerge(stdRsmIds);
        StandardResumeDataHelper.updateModifyTime(stdRsmIds);
    }
}

