/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.integrity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tstpm.business.domain.stdrsm.service.integrity.ResumeIntegrityService;
import kd.tsc.tstpm.business.domain.stdrsm.service.integrity.factory.IntegrityFactory;

public abstract class AbstractResumeIntegrityService
implements ResumeIntegrityService {
    protected String mainEntryNumber;
    protected List<String> entryNumberList;

    @Override
    public int calculateResumeIntegrity(Map<String, DynamicObjectCollection> param) {
        Map<String, List<DynamicObject>> weightConfig = this.getWeightConfig();
        ArrayList weightResult = Lists.newArrayListWithCapacity((int)weightConfig.size());
        for (Map.Entry<String, DynamicObjectCollection> entry : param.entrySet()) {
            String entryNumber = entry.getKey();
            DynamicObjectCollection collection = entry.getValue();
            String stdRsmEntryNumber = this.getEntryNumber(entryNumber);
            List<DynamicObject> list = weightConfig.get(stdRsmEntryNumber);
            int weight = IntegrityFactory.getResumeWeight(stdRsmEntryNumber).integrityResume(collection, list);
            weightResult.add(weight);
        }
        return weightResult.stream().mapToInt(Integer::intValue).sum();
    }

    @Override
    public void setMainEntryNumber(String entryNumber) {
        this.mainEntryNumber = entryNumber;
    }

    @Override
    public void setEntryNumberList(List<String> entryNumberList) {
        this.entryNumberList = entryNumberList;
    }

    @Override
    public int calculateResumeIntegrity(Long resumeId) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)this.mainEntryNumber)) {
            return 0;
        }
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)this.mainEntryNumber);
        DynamicObject mainEntry = helper.queryOne((Object)resumeId);
        DynamicObjectCollection mainDyCollection = new DynamicObjectCollection(mainEntry.getDynamicObjectType(), null);
        mainDyCollection.add((Object)mainEntry);
        param.put(this.mainEntryNumber, mainDyCollection);
        if (this.entryNumberList == null) {
            return 0;
        }
        for (String entryNumber : this.entryNumberList) {
            QFilter filter = this.getEntryNumberQFilter(resumeId);
            HRBaseServiceHelper entryNumberHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entryNumber);
            DynamicObject[] dys = entryNumberHelper.loadDynamicObjectArray(new QFilter[]{filter});
            if (dys.length <= 0) continue;
            DynamicObjectCollection collection = AbstractResumeIntegrityService.getStdRsmCollection(dys, entryNumber);
            param.put(entryNumber, collection);
        }
        return this.calculateResumeIntegrity(param);
    }

    private static DynamicObjectCollection getStdRsmCollection(DynamicObject[] dys, String entryNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryNumber);
        DynamicObjectCollection result = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        ImmutableSet ignoreKeys = ImmutableSet.of((Object)"id");
        for (DynamicObject dy : dys) {
            DynamicObject stdEntryDy = new DynamicObject((DynamicObjectType)entityType);
            DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)stdEntryDy, (Set)ignoreKeys);
            result.add((Object)stdEntryDy);
        }
        return result;
    }

    protected Map<String, List<DynamicObject>> getWeightConfig() {
        DynamicObject[] dys;
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : dys = this.getResumeWeightConfig()) {
            String entryNumber = dy.getString("resume.number");
            List list = result.getOrDefault(entryNumber, Lists.newArrayListWithCapacity((int)16));
            list.add(dy);
            result.put(entryNumber, list);
        }
        return result;
    }

    protected DynamicObject[] getResumeWeightConfig() {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_rsmintegrity");
        String selectFields = "resume.number,weight,properties,modular";
        return helper.queryOriginalArray(selectFields, new QFilter[0]);
    }

    protected abstract String getEntryNumber(String var1);

    protected abstract QFilter getEntryNumberQFilter(Long var1);
}

