/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.integrity.weight;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tsc.tstpm.business.domain.stdrsm.service.integrity.AbstractResumeWeight;
import kd.tsc.tstpm.common.utils.ResumeDyUtil;

public class IResumeWeight
extends AbstractResumeWeight {
    private static final Map<Integer, Integer> JOB_INTENTION = Maps.newHashMapWithExpectedSize((int)3);
    private static final Map<String, Consumer<Map<String, Object>>> RESUME_METHOD = Maps.newHashMapWithExpectedSize((int)3);
    private static final String FIELD_RESUME = "resume";
    private static final String FIELD_CONFIG = "config";
    private static final String SUM_RESULT = "sum_result";

    public IResumeWeight() {
        JOB_INTENTION.put(0, 0);
        JOB_INTENTION.put(1, 5);
        JOB_INTENTION.put(2, 10);
        JOB_INTENTION.put(3, 15);
        RESUME_METHOD.put("baseInfo", this::calculateBaseInfoIntegrity);
        RESUME_METHOD.put("contactInfo", this::calculateContactInfoIntegrity);
        RESUME_METHOD.put("jobIntention", this::calculateJobIntentionIntegrity);
        RESUME_METHOD.put("selfEvaluation", this::calculateSelfEvaluationIntegrity);
    }

    @Override
    public int integrityResume(DynamicObjectCollection collection, List<DynamicObject> configList) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        param.put(FIELD_RESUME, collection.get(0));
        for (DynamicObject config : configList) {
            String modular = config.getString(this.MODULAR);
            param.put(FIELD_CONFIG, config);
            RESUME_METHOD.get(modular).accept(param);
        }
        return param.getOrDefault(SUM_RESULT, 0);
    }

    private void calculateBaseInfoIntegrity(Map<String, Object> param) {
        DynamicObject resume = (DynamicObject)param.get(FIELD_RESUME);
        DynamicObject config = (DynamicObject)param.get(FIELD_CONFIG);
        int weight = this.calculateIntegrityAllRequired(resume, config);
        int oldWeight = (Integer)param.getOrDefault(SUM_RESULT, 0);
        param.put(SUM_RESULT, weight + oldWeight);
    }

    private void calculateContactInfoIntegrity(Map<String, Object> param) {
        DynamicObject resume = (DynamicObject)param.get(FIELD_RESUME);
        DynamicObject config = (DynamicObject)param.get(FIELD_CONFIG);
        int weight = this.calculateIntegrityAnyProperties(resume, config);
        int oldWeight = (Integer)param.getOrDefault(SUM_RESULT, 0);
        param.put(SUM_RESULT, weight + oldWeight);
    }

    private void calculateJobIntentionIntegrity(Map<String, Object> param) {
        DynamicObject resume = (DynamicObject)param.get(FIELD_RESUME);
        DynamicObject config = (DynamicObject)param.get(FIELD_CONFIG);
        String[] fields = this.getFields(config);
        ArrayList notEmptyList = Lists.newArrayListWithCapacity((int)fields.length);
        for (String field : fields) {
            if (!ResumeDyUtil.isEmpty((Object)resume.get(field))) {
                notEmptyList.add(field);
            }
            if (notEmptyList.size() == 3) break;
        }
        int weight = JOB_INTENTION.get(notEmptyList.size());
        int oldWeight = (Integer)param.getOrDefault(SUM_RESULT, 0);
        param.put(SUM_RESULT, weight + oldWeight);
    }

    private void calculateSelfEvaluationIntegrity(Map<String, Object> param) {
        DynamicObject resume = (DynamicObject)param.get(FIELD_RESUME);
        DynamicObject config = (DynamicObject)param.get(FIELD_CONFIG);
        int weight = this.calculateIntegrityAnyProperties(resume, config);
        int oldWeight = (Integer)param.getOrDefault(SUM_RESULT, 0);
        param.put(SUM_RESULT, weight + oldWeight);
    }
}

