/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.black;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.helper.BlacklistDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.ResumeStatusService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmOpRecordService;

public abstract class AbstractResumeStatusService
implements ResumeStatusService {
    protected final Log logger = LogFactory.getLog(ResumeStatusService.class);
    protected StdRsmOpRecordService rsmOpRecordService = StdRsmOpRecordService.getInstance();
    protected String entryNumber;
    protected ResumeHisDataStatusEnum dataStatusEnum;
    protected List<String> duplicates = Lists.newArrayListWithExpectedSize((int)16);

    @Override
    public void setDuplicates(String ... entryNumber) {
        this.duplicates.addAll(Arrays.asList(entryNumber));
    }

    @Override
    public void setEntryNumber(String entryNumber) {
        this.entryNumber = entryNumber;
    }

    @Override
    public void changeResumeStatus(Long mid) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)this.entryNumber);
        QFilter filter = new QFilter("id", "=", (Object)mid);
        DynamicObject dy = helper.generateEmptyDynamicObject();
        String queryFields = HRDynamicObjectUtils.getQueryFields((DynamicObject)dy);
        DynamicObject rsmDy = helper.queryOne(queryFields, new QFilter[]{filter});
        ResumeHisDataStatusEnum statusEnum = this.getRecoverStatusEnum();
        rsmDy.set("datastatus", (Object)statusEnum.getStatus());
        String dataStatus = rsmDy.getString("datastatus");
        if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus)) {
            DynamicObject blackListDy = BlacklistDataHelper.loadSingle(mid);
            rsmDy.set("addsource", blackListDy.get("addsource"));
            rsmDy.set("blareason", blackListDy.get("blareason"));
            rsmDy.set("blatime", blackListDy.get("createtime"));
        }
        helper.update(new DynamicObject[]{rsmDy});
    }

    @Override
    public void batchChangeResumeStatus(List<Long> rsmList, Map<String, Object> effectField) {
        DynamicObject[] rsmDys;
        this.logger.info("ResumeStatusService.batchChangeResumeStatus.effectField:[{}]", effectField);
        this.beforeStatusChangeResume(rsmList, effectField);
        for (DynamicObject rsmDy : rsmDys = this.getCurrentVersionRsmDys(rsmList, this.getChangeStatus())) {
            if (!effectField.isEmpty()) {
                effectField.forEach((arg_0, arg_1) -> ((DynamicObject)rsmDy).set(arg_0, arg_1));
            }
            if (ResumeHisDataStatusEnum.DELETED.equals((Object)this.dataStatusEnum)) {
                rsmDy.set("deltime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            }
            rsmDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)this.entryNumber);
        serviceHelper.save(rsmDys);
        this.afterStatusChangeResume(rsmDys);
    }

    @Override
    public void batchRecoverResumeStatus(List<Long> rsmList, Map<String, Object> effectField) {
        DynamicObject[] rsmDys;
        this.logger.info("ResumeStatusService.batchRecoverResumeStatus.effectField:[{}]", effectField);
        this.beforeRecoverResume(rsmList);
        ResumeHisDataStatusEnum statusEnum = this.getRecoverStatusEnum();
        for (DynamicObject rsmDy : rsmDys = this.getCurrentVersionRsmDys(rsmList, statusEnum)) {
            rsmDy.set("datastatus", (Object)ResumeHisDataStatusEnum.EFFECTING.getStatus());
            if (!effectField.isEmpty()) {
                effectField.forEach((arg_0, arg_1) -> ((DynamicObject)rsmDy).set(arg_0, arg_1));
            }
            if (!ResumeHisDataStatusEnum.DELETED.equals((Object)this.dataStatusEnum)) continue;
            rsmDy.set("deltime", null);
        }
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)this.entryNumber);
        serviceHelper.save(rsmDys);
        this.afterRecoverResume(rsmDys);
    }

    protected DynamicObject[] getCurrentVersionRsmDys(List<Long> stdRsmIds, ResumeHisDataStatusEnum ... statusEnums) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)this.entryNumber);
        QFilter filter = new QFilter("mid", "in", stdRsmIds);
        filter.and("iscurrentversion", "=", (Object)"1");
        List status = Arrays.stream(statusEnums).map(ResumeHisDataStatusEnum::getStatus).collect(Collectors.toList());
        filter.and("datastatus", "in", status);
        return helper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    protected abstract ResumeHisDataStatusEnum[] getChangeStatus();

    protected abstract ResumeHisDataStatusEnum getRecoverStatusEnum();

    void beforeStatusChangeResume(List<Long> stdRsmIds, Map<String, Object> effectField) {
    }

    void afterStatusChangeResume(DynamicObject[] rsmDys) {
    }

    void beforeRecoverResume(List<Long> stdRsmIds) {
    }

    void afterRecoverResume(DynamicObject[] rsmDys) {
    }
}

