/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordChangeModel;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tstpm.business.domain.stdrsm.domain.ResumeOpRecord;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmORStructText;

public class StdRsmOpRecordService {
    private static final Log logger = LogFactory.getLog(StdRsmOpRecordService.class);
    private static final String REGEX = ",";
    private static final String DEKIMITER = "\u3001";

    public static StdRsmOpRecordService getInstance() {
        return Instance.STDRSM_INSTANCE;
    }

    private StdRsmOpRecordService() {
    }

    public void commonOpRecord(DynamicObject[] rsmDys, OpDefEnum opDefEnum) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String operatorName = RequestContext.get().getUserName();
        for (DynamicObject rsmDy : rsmDys) {
            String bizObjName = rsmDy.getString("fullname");
            String opText = StdRsmORStructText.getInstance().getCommonORText(opDefEnum, operatorName, bizObjName);
            modelList.add(this.getStdRsmORModel(rsmDy, opDefEnum, opText, null));
        }
        this.sendStdRsmOpRecord(modelList);
    }

    public void mergeCandidatesOR(DynamicObject mergeFrom, DynamicObject mergeTo, String message) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String operatorName = RequestContext.get().getUserName();
        String mergeFromText = this.getStdRsmTest(mergeFrom);
        String mergeToText = this.getStdRsmTest(mergeTo);
        String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.MERGE_CANDIDATES, operatorName, mergeFromText, mergeToText);
        modelList.add(this.getStdRsmORModel(mergeTo, OpDefEnum.MERGE_CANDIDATES, opText, null));
        if (HRStringUtils.isNotEmpty((String)message)) {
            String bizObjName = mergeTo.getString("fullname");
            String newOpText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.JOIN_BLACKLIST, operatorName, bizObjName);
            modelList.add(this.getStdRsmORModel(mergeTo, OpDefEnum.JOIN_BLACKLIST, newOpText, null));
        }
        modelList.add(this.getStdRsmORModel(mergeTo, OpDefEnum.MERGE_CANDIDATES, opText, null));
        this.sendStdRsmOpRecord(modelList);
    }

    public void cancelSuspectedOR(DynamicObject[] dys) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String operatorName = RequestContext.get().getUserName();
        DynamicObject candidateA = dys[0];
        DynamicObject candidateB = dys[1];
        String cancelAText = this.getStdRsmTest(candidateA);
        String cancelBText = this.getStdRsmTest(candidateB);
        String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.CANCEL_SUSPECTED, operatorName, cancelAText, cancelBText);
        modelList.add(this.getStdRsmORModel(candidateA, OpDefEnum.CANCEL_SUSPECTED, opText, null));
        modelList.add(this.getStdRsmORModel(candidateB, OpDefEnum.CANCEL_SUSPECTED, opText, null));
        this.sendStdRsmOpRecord(modelList);
    }

    public void setDisplayVersionOR(long vid, long stdRsmId) {
        QFilter filter = new QFilter("sourcevid", "=", (Object)0L);
        filter.and("boid", "=", (Object)stdRsmId);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_stdrsm");
        DynamicObject[] dys = helper.query("fullname", new QFilter[]{filter}, "id  asc");
        int index = 0;
        for (DynamicObject dy : dys) {
            ++index;
            if (vid == dy.getLong("id")) break;
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String operatorName = RequestContext.get().getUserName();
        DynamicObject hisDy = helper.loadSingle((Object)vid);
        String bizObjName = hisDy.getString("fullname");
        String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.SET_DISPLAY_VERSION, operatorName, bizObjName, "v" + index, "v" + dys.length);
        modelList.add(this.getStdRsmORModel(hisDy, OpDefEnum.SET_DISPLAY_VERSION, opText, null));
        this.sendStdRsmOpRecord(modelList);
    }

    public void activeDeliverOR(DynamicObject resume, String channelType, String positionName) {
        String opText;
        String resumeName = resume.getString("fullname");
        if (HRStringUtils.isNotEmpty((String)positionName)) {
            opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.ACTIVE_DELIVER, resumeName, channelType, positionName);
        } else {
            String message = ResManager.loadKDString((String)"\u5019\u9009\u4eba%s\u901a\u8fc7%s\u5e94\u8058\uff0c\u521b\u5efa\u4e86\u6807\u51c6\u7b80\u5386\u3002", (String)"StdRsmORStructText_18", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            opText = String.format(message, resumeName, channelType);
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)1);
        OprecordMessageModel model = this.getStdRsmORModel(resume, OpDefEnum.FOUND_STDRSM, opText, resumeName);
        modelList.add(model);
        this.sendStdRsmOpRecord(modelList);
    }

    public void recommendOR(DynamicObject resume, String channelType, String positionName, String recommend) {
        String resumeName = resume.getString("fullname");
        String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.RECOMMEND, resumeName, channelType, positionName, recommend);
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)1);
        OprecordMessageModel model = this.getStdRsmORModel(resume, OpDefEnum.FOUND_STDRSM, opText, recommend);
        modelList.add(model);
        this.sendStdRsmOpRecord(modelList);
    }

    public void handlerCreateOR(DynamicObject resume, String channelType, String operate) {
        String resumeName = resume.getString("fullname");
        String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.HANDLER_SAVE, operate, channelType, resumeName);
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)1);
        OprecordMessageModel model = this.getStdRsmORModel(resume, OpDefEnum.FOUND_STDRSM, opText, operate);
        modelList.add(model);
        this.sendStdRsmOpRecord(modelList);
    }

    public void resumeUpdateOR(DynamicObject resume, DynamicObject position, ResumeTypeEnum typeEnum, List<Map<String, Object>> changeListMap) {
        String operate;
        String orText;
        String resumeName = resume.getString("fullname");
        if (typeEnum.getOpDefEnum().equals((Object)OpDefEnum.INTVI_UPDATE_RSM) || typeEnum.getOpDefEnum().equals((Object)OpDefEnum.ACTIVE_DELIVER)) {
            orText = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u66f4\u65b0\u4e86\u7b80\u5386\u4fe1\u606f", (String)"StdRsmORStructText_17", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            operate = resume.getString("fullname");
        } else {
            operate = RequestContext.get().getUserName();
            if (Objects.isNull(position)) {
                orText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.STD_RSM_UPDATE, operate, resumeName);
            } else {
                String positionName = position.getString("number") + position.get("name");
                orText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.APP_FILE_UPDATE, operate, positionName, resumeName);
            }
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)1);
        OprecordMessageModel model = this.getStdRsmORModel(resume, OpDefEnum.UPDATE_STDRSM, orText, operate);
        if (null != changeListMap) {
            model.setChangeList(this.getChangeModelList(changeListMap));
        }
        modelList.add(model);
        this.sendStdRsmOpRecord(modelList);
    }

    public List<OprecordChangeModel> getChangeModelList(List<Map<String, Object>> changeListMap) {
        ArrayList changeModelList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map<String, Object> changeMap : changeListMap) {
            OprecordChangeModel changeModel = new OprecordChangeModel();
            changeModel.setFieldkey(String.valueOf(changeMap.get("fieldKey")));
            changeModel.setFieldname(String.valueOf(changeMap.get("fieldName")));
            changeModel.setOriginalvalue(String.valueOf(changeMap.get("originalValue")));
            changeModel.setNewvalue(String.valueOf(changeMap.get("newValue")));
            changeModelList.add(changeModel);
        }
        return changeModelList;
    }

    public OprecordMessageModel getStdRsmORModel(DynamicObject resume, OpDefEnum opDefEnum, String opText, String operate) {
        OprecordMessageModel model = new OprecordMessageModel();
        model.setOperator(Long.valueOf(RequestContext.get().getCurrUserId()));
        if (HRStringUtils.isNotEmpty((String)operate)) {
            model.setOperatorname(operate);
        } else {
            model.setOperatorname(RequestContext.get().getUserName());
        }
        model.setBizobjname(resume.getString("fullname"));
        model.setBizentry("tstpm_stdrsm");
        model.setBizobj(resume.getLong("mid"));
        model.setOpnumber(opDefEnum.getCode());
        logger.info("StdRsmOpRecordService.sendStdRsmOpRecord.opDefNum:{}", (Object)opDefEnum.getCode());
        model.setOptime(DateUtils.nowDateTime());
        model.setOprtext(opText);
        logger.info("StdRsmOpRecordService.sendStdRsmOpRecord.model:{}", (Object)model);
        return model;
    }

    public void sendStdRsmOpRecord(List<OprecordMessageModel> modelList) {
        logger.info("StdRsmOpRecordService.sendStdRsmOpRecord.modelList:{}", (Object)modelList.toString());
        try {
            OprecordMQ.sendOpRecordChangeMessage(modelList);
        }
        catch (KDException exception) {
            logger.error("sendStdRsm error:", (Throwable)exception);
        }
    }

    public void resumeCreateOpRecord(ResumeOpRecord opRecord) {
        ResumeTypeEnum typeEnum = opRecord.getTypeEnum();
        String operate = opRecord.getOperate();
        if (typeEnum.getOpDefEnum().equals((Object)OpDefEnum.ACTIVE_DELIVER)) {
            this.activeDeliverOR(opRecord.getResume(), opRecord.getChannelType(), opRecord.getPosition());
        }
        if (typeEnum.getOpDefEnum().equals((Object)OpDefEnum.RECOMMEND)) {
            this.recommendOR(opRecord.getResume(), opRecord.getChannelType(), opRecord.getPosition(), operate);
        }
        if (typeEnum.getOpDefEnum().equals((Object)OpDefEnum.HANDLER_SAVE)) {
            this.handlerCreateOR(opRecord.getResume(), opRecord.getChannelType(), operate);
        }
    }

    public String getStdRsmTest(DynamicObject dy) {
        return dy.getString("number") + "-" + dy.getString("fullname");
    }

    private static class Instance {
        private static final StdRsmOpRecordService STDRSM_INSTANCE = new StdRsmOpRecordService();

        private Instance() {
        }
    }
}

