/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.entity.RsmRecommend;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmORStructText;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmOpRecordService;
import kd.tsc.tstpm.business.domain.talentpool.entity.StdrsmPositionIdEntity;
import kd.tsc.tstpm.business.domain.talentpool.entity.TalentPoolPostionEntity;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TalentPoolOperateRecordService {
    private static final Log logger = LogFactory.getLog(TalentPoolOperateRecordService.class);
    private static TalentPoolOperateRecordService talentPoolOperateRecordService = new TalentPoolOperateRecordService();

    private TalentPoolOperateRecordService() {
    }

    public static TalentPoolOperateRecordService getInstance() {
        return talentPoolOperateRecordService;
    }

    public void removeTalentPoolOp(List<Long> candidateIds, List<Long> talentPoolIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "in", talentPoolIds);
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        DynamicObject[] reserveRecordDtArrays = serviceHelper.query("id, talentpool, stdrsm", new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
        if (reserveRecordDtArrays == null || reserveRecordDtArrays.length == 0) {
            return;
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject[] candiDateDynObj = TalentListDaoHelper.getInstance().getCandidateDts(candidateIds);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynObj : reserveRecordDtArrays) {
            Long stdId = dynObj.getDynamicObject("stdrsm").getLong("id");
            Long toolPoolId = dynObj.getDynamicObject("talentpool").getLong("id");
            Set t1 = (Set)result.get(stdId);
            if (null == t1) {
                t1 = Sets.newHashSetWithExpectedSize((int)16);
            }
            if (toolPoolId != null) {
                t1.add(toolPoolId);
            }
            result.put(stdId, t1);
        }
        String operatorName = RequestContext.get().getUserName();
        for (DynamicObject rsmDy : candiDateDynObj) {
            String bizObjName = rsmDy.getString("fullname");
            Set longs = (Set)result.get(rsmDy.getLong("id"));
            if (longs == null) continue;
            String talentPoolName = this.getStrTalPoolName(new ArrayList<Long>(longs), "0");
            String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.REMOVE, operatorName, bizObjName, talentPoolName);
            modelList.add(StdRsmOpRecordService.getInstance().getStdRsmORModel(rsmDy, OpDefEnum.REMOVE, opText, null));
        }
        StdRsmOpRecordService.getInstance().sendStdRsmOpRecord(modelList);
    }

    public String getStrTalPoolName(List<Long> talentPoolIds, String flag) {
        DynamicObject[] talentPoolDynObj = HRStringUtils.equals((String)"1", (String)flag) ? TalentListDaoHelper.getInstance().getTalentPools(talentPoolIds) : TalentListDaoHelper.getInstance().getTalentPools(this.removePrePrivateTalPoo(talentPoolIds));
        int talPooNum = 0;
        String strTalentPoolName = null;
        for (DynamicObject candiDynObj : talentPoolDynObj) {
            String name = StringUtils.equals((CharSequence)candiDynObj.getString("pooltype"), (CharSequence)"A") ? "\u516c\u5171\u4eba\u624d\u5e93-" : "\u5171\u4eab\u79c1\u6709\u5e93-";
            name = name + candiDynObj.getString("name");
            if (talPooNum < talentPoolIds.size() - 1) {
                name = name + "\u3001";
            }
            strTalentPoolName = strTalentPoolName != null ? strTalentPoolName + name : name;
            ++talPooNum;
        }
        return strTalentPoolName;
    }

    public List<Long> removePrePrivateTalPoo(List<Long> talentPoolIds) {
        DynamicObject[] dynamicObjects;
        QFilter presetFilter = new QFilter("id", "in", Arrays.asList(1010L, 1020L, 1030L, 1040L));
        QFilter qFilter = TalentPoolMgtQFilterHelper.privateTalentPoolQFilter();
        QFilter idFilter = new QFilter("id", "in", talentPoolIds);
        presetFilter.or(qFilter);
        idFilter.and(presetFilter);
        for (DynamicObject dynObj : dynamicObjects = TalentPoolMgtHelper.queryTalentPool(idFilter)) {
            talentPoolIds.remove(dynObj.getLong("id"));
        }
        return talentPoolIds;
    }

    public void reserveOpRecord(DynamicObject[] reserveDtArrays, OperationResult operationResult) {
        List<DynamicObject> reserveDtList = this.getReserveData(reserveDtArrays, operationResult);
        if (CollectionUtils.isEmpty(reserveDtList)) {
            return;
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String operatorName = RequestContext.get().getUserName();
        ArrayList<Long> stdRsmIds = new ArrayList<Long>();
        for (DynamicObject reserveDt : reserveDtList) {
            Long reserveDtId = reserveDt.getLong("id");
            Object stdRsmObj = reserveDt.get("stdrsm");
            DynamicObject stdRsmDy = null;
            stdRsmDy = stdRsmObj instanceof Long ? StandardResumeDataHelper.queryOne((Long)stdRsmObj) : (DynamicObject)stdRsmObj;
            Long stdRsmId = stdRsmDy.getLong("id");
            if (stdRsmIds.contains(stdRsmId)) break;
            stdRsmIds.add(stdRsmId);
            String bizObjName = stdRsmDy.getString("fullname");
            DynamicObject talentPoolDy = reserveDt.getDynamicObject("talentpool");
            StringBuilder talentPoolObj = new StringBuilder();
            talentPoolObj.append(this.getTalentPoolType(talentPoolDy.getString("pooltype"), 0L, "1"));
            talentPoolObj.append("-");
            talentPoolObj.append(talentPoolDy.getString("name"));
            for (DynamicObject internalReserveDt : reserveDtList) {
                DynamicObject internalTalentPoolDy = internalReserveDt.getDynamicObject("talentpool");
                if (reserveDtId.longValue() == internalReserveDt.getLong("id") || stdRsmId.longValue() != internalReserveDt.getLong("id")) continue;
                talentPoolObj.append("\u3001");
                talentPoolObj.append(this.getTalentPoolType(internalTalentPoolDy.getString("pooltype"), 0L, "1"));
                talentPoolObj.append("-");
                talentPoolObj.append(internalTalentPoolDy.getString("name"));
            }
            String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.RESERVE_TO_STDRSM, operatorName, bizObjName, talentPoolObj.toString());
            modelList.add(StdRsmOpRecordService.getInstance().getStdRsmORModel(stdRsmDy, OpDefEnum.RESERVE_TO_STDRSM, opText, null));
        }
        StdRsmOpRecordService.getInstance().sendStdRsmOpRecord(modelList);
    }

    public void transferOpRecord(DynamicObject[] reserveDtArrays, List<Long> oldTalentPoolIds) {
        ArrayList reserveDtList = new ArrayList(reserveDtArrays.length);
        Collections.addAll(reserveDtList, reserveDtArrays);
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String operatorName = RequestContext.get().getUserName();
        for (DynamicObject reserveDt : reserveDtList) {
            Long reserveDtId = reserveDt.getLong("id");
            Long stdRsmId = reserveDt.getLong("stdrsm");
            DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
            String bizObjName = stdRsmDy.getString("fullname");
            DynamicObject talentPoolDy = reserveDt.getDynamicObject("talentpool");
            StringBuilder talentPoolObj = new StringBuilder();
            talentPoolObj.append(this.getTalentPoolType(talentPoolDy.getString("pooltype"), talentPoolDy.getDynamicObject("creator").getLong("id"), "0"));
            talentPoolObj.append("-");
            talentPoolObj.append(talentPoolDy.getString("name"));
            for (DynamicObject internalReserveDt : reserveDtList) {
                DynamicObject internalTalentPoolDy = internalReserveDt.getDynamicObject("talentpool");
                if (reserveDtId.longValue() == internalReserveDt.getLong("id") || stdRsmId.longValue() != internalReserveDt.getDynamicObject("stdrsm").getLong("id")) continue;
                talentPoolObj.append("\u3001");
                talentPoolObj.append(this.getTalentPoolType(internalTalentPoolDy.getString("pooltype"), internalTalentPoolDy.getDynamicObject("creator").getLong("id"), "0"));
                talentPoolObj.append("-");
                talentPoolObj.append(internalTalentPoolDy.getString("name"));
            }
            String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.TRANSFER_POOL, operatorName, bizObjName, this.getStrTalPoolName(oldTalentPoolIds, "1"), talentPoolObj.toString());
            modelList.add(StdRsmOpRecordService.getInstance().getStdRsmORModel(stdRsmDy, OpDefEnum.TRANSFER_POOL, opText, null));
        }
        StdRsmOpRecordService.getInstance().sendStdRsmOpRecord(modelList);
    }

    public void recommondOpRecord(List<Long> candidateIds, List<Long> positionIds, List<RsmRecommend.FailPosition> failPositionList) {
        List<StdrsmPositionIdEntity> stdrsmPositionList = this.getRecommondData(candidateIds, positionIds, failPositionList);
        if (CollectionUtils.isEmpty(stdrsmPositionList)) {
            return;
        }
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String operatorName = RequestContext.get().getUserName();
        List<StdrsmPositionIdEntity> returnStdPosList = this.getStdrsmPostionDys(stdrsmPositionList, candidateIds, positionIds);
        for (StdrsmPositionIdEntity returnStdPos : returnStdPosList) {
            DynamicObject stdRsmDy = returnStdPos.getCandidateDy();
            String bizObjName = stdRsmDy.getString("fullname");
            StringBuilder positionObj = new StringBuilder(returnStdPos.getPositionDys().size());
            for (DynamicObject positionDt : returnStdPos.getPositionDys()) {
                positionObj.append(positionDt.getString("number"));
                positionObj.append(positionDt.getString("name"));
                positionObj.append("\u3001");
            }
            String positionObjFinal = positionObj.substring(0, positionObj.length() - 1);
            String opText = StdRsmORStructText.getInstance().getCommonORText(OpDefEnum.RECOMMEND_TO_POSITION, operatorName, bizObjName, positionObjFinal);
            modelList.add(StdRsmOpRecordService.getInstance().getStdRsmORModel(stdRsmDy, OpDefEnum.RECOMMEND_TO_POSITION, opText, null));
        }
        StdRsmOpRecordService.getInstance().sendStdRsmOpRecord(modelList);
    }

    private List<DynamicObject> getReserveData(DynamicObject[] reserveDtArrays, OperationResult operationResult) {
        DynamicObject reserveDt;
        Iterator reserveDtIterator;
        ArrayList<DynamicObject> reserveDtList = new ArrayList<DynamicObject>(reserveDtArrays.length);
        Collections.addAll(reserveDtList, reserveDtArrays);
        ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
        HashSet errorPkIdsSet = validateResultCollection.getErrorPkIds();
        if (errorPkIdsSet.size() > 0) {
            reserveDtIterator = reserveDtList.iterator();
            while (reserveDtIterator.hasNext()) {
                reserveDt = (DynamicObject)reserveDtIterator.next();
                if (!errorPkIdsSet.contains(reserveDt.getLong("id"))) continue;
                reserveDtIterator.remove();
            }
        }
        if (CollectionUtils.isEmpty(reserveDtList)) {
            return reserveDtList;
        }
        reserveDtIterator = reserveDtList.iterator();
        while (reserveDtIterator.hasNext()) {
            reserveDt = (DynamicObject)reserveDtIterator.next();
            DynamicObject talentPoolDy = reserveDt.getDynamicObject("talentpool");
            if (!HRStringUtils.equals((String)"B", (String)talentPoolDy.getString("pooltype")) || talentPoolDy.getDynamicObject("creator").getLong("id") != TSCRequestContext.getUserId()) continue;
            reserveDtIterator.remove();
        }
        return reserveDtList;
    }

    private List<StdrsmPositionIdEntity> getRecommondData(List<Long> candidateIds, List<Long> positionIds, List<RsmRecommend.FailPosition> failPositionList) {
        int totalCount = candidateIds.size() * positionIds.size();
        ArrayList<TalentPoolPostionEntity> talentPoolPostionEntityList = new ArrayList<TalentPoolPostionEntity>(totalCount);
        for (Long candidateId : candidateIds) {
            for (Long positionId : positionIds) {
                TalentPoolPostionEntity TalentPoolPostionEntity2 = new TalentPoolPostionEntity();
                TalentPoolPostionEntity2.setCandidateId(candidateId);
                TalentPoolPostionEntity2.setPositionId(positionId);
                talentPoolPostionEntityList.add(TalentPoolPostionEntity2);
            }
        }
        if (CollectionUtils.isNotEmpty(failPositionList)) {
            Iterator postionIterator = talentPoolPostionEntityList.iterator();
            while (postionIterator.hasNext()) {
                TalentPoolPostionEntity talentPoolPostionEntity = (TalentPoolPostionEntity)postionIterator.next();
                for (RsmRecommend.FailPosition failPosition : failPositionList) {
                    DynamicObject positionDy = failPosition.getPositionDy();
                    if (talentPoolPostionEntity.getPositionId().longValue() != positionDy.getLong("id")) continue;
                    for (DynamicObject stdRsmDy : failPosition.getStdRsmDys()) {
                        if (stdRsmDy.getLong("id") != talentPoolPostionEntity.getCandidateId().longValue()) continue;
                        postionIterator.remove();
                    }
                }
            }
        }
        ArrayList<StdrsmPositionIdEntity> stdrsmPositionIdEntityList = new ArrayList<StdrsmPositionIdEntity>(talentPoolPostionEntityList.size());
        ArrayList<Long> stdrsmIds = new ArrayList<Long>(talentPoolPostionEntityList.size());
        for (TalentPoolPostionEntity talentPoolPostionEntity : talentPoolPostionEntityList) {
            Long candidateId = talentPoolPostionEntity.getCandidateId();
            if (stdrsmIds.contains(candidateId)) continue;
            ArrayList<Long> stdrsmPositionIds = new ArrayList<Long>(talentPoolPostionEntityList.size());
            StdrsmPositionIdEntity stdrsmPositionIdEntity = new StdrsmPositionIdEntity();
            stdrsmPositionIdEntity.setCandidateId(candidateId);
            Long positionId = talentPoolPostionEntity.getPositionId();
            stdrsmPositionIds.add(positionId);
            for (TalentPoolPostionEntity internalEntity : talentPoolPostionEntityList) {
                if (!candidateId.equals(internalEntity.getCandidateId()) || positionId.equals(internalEntity.getPositionId())) continue;
                stdrsmPositionIds.add(internalEntity.getPositionId());
            }
            stdrsmPositionIdEntity.setPositionIds(stdrsmPositionIds);
            stdrsmPositionIdEntityList.add(stdrsmPositionIdEntity);
            stdrsmIds.add(candidateId);
        }
        return stdrsmPositionIdEntityList;
    }

    private List<StdrsmPositionIdEntity> getStdrsmPostionDys(List<StdrsmPositionIdEntity> stdrsmPositionIdEntityList, List<Long> candidateIds, List<Long> positionIds) {
        DynamicObject[] stdRsmDys = StdRsmServiceHelper.getStdRsmDys(candidateIds);
        DynamicObject[] positionDys = RsmPositionHelper.getPositionObjByPositionIds(positionIds);
        for (StdrsmPositionIdEntity stdPosEntity : stdrsmPositionIdEntityList) {
            for (DynamicObject stdRsmDy : stdRsmDys) {
                if (stdPosEntity.getCandidateId().longValue() != stdRsmDy.getLong("id")) continue;
                stdPosEntity.setCandidateDy(stdRsmDy);
            }
            for (Long positionId : stdPosEntity.getPositionIds()) {
                for (DynamicObject positionDy : positionDys) {
                    if (positionId.longValue() != positionDy.getLong("id")) continue;
                    stdPosEntity.getPositionDys().add(positionDy);
                }
            }
        }
        return stdrsmPositionIdEntityList;
    }

    private String getTalentPoolType(String talentPoolTypeCode, Long creatorId, String flag) {
        String talentPoolTypeName = "\u516c\u5171\u4eba\u624d\u5e93";
        if (HRStringUtils.isEmpty((String)talentPoolTypeCode)) {
            talentPoolTypeName = "\u516c\u5171\u4eba\u624d\u5e93";
        } else if (HRStringUtils.equals((String)"B", (String)talentPoolTypeCode)) {
            talentPoolTypeName = HRStringUtils.equals((String)flag, (String)"0") ? (creatorId == TSCRequestContext.getUserId() ? "\u79c1\u6709\u4eba\u624d\u5e93" : "\u5171\u4eab\u79c1\u6709\u5e93") : "\u5171\u4eab\u79c1\u6709\u5e93";
        }
        return talentPoolTypeName;
    }
}

