/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.resume;

import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.resume.FieldService;
import org.apache.commons.lang3.time.DateFormatUtils;

public abstract class AbstractFieldService
implements FieldService {
    protected final Log logger = LogFactory.getLog(AbstractFieldService.class);
    protected final String FIELD_KEY = "fieldKey";
    protected final String FIELD_NAME = "fieldName";
    protected final String ORIGINAL_VALUE = "originalValue";
    protected final String NEW_VALUE = "newValue";

    protected Map<String, Object> changeFieldValue(DynamicObject originalDy, DynamicObject newDy, Set<String> fields) {
        HashMap changeFieldValue = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (String attr : fields) {
            Object originalDyValue = this.getAttrString(originalDy, attr);
            Object newDyValue = this.getAttrString(newDy, attr);
            if (originalDyValue instanceof Timestamp && newDyValue instanceof Date) {
                Date newDyDateValue = (Date)newDyValue;
                Timestamp newDateTimeStp = new Timestamp(newDyDateValue.getTime());
                if (((Timestamp)originalDyValue).equals(newDateTimeStp)) continue;
                changeFieldValue.put(attr, newDyValue);
                continue;
            }
            if (Objects.equals(originalDyValue, newDyValue)) continue;
            changeFieldValue.put(attr, newDy.get(attr));
        }
        this.logger.info("FieldService.getChangeFieldValue:[{}]", (Object)changeFieldValue);
        return changeFieldValue;
    }

    protected Object getAttrString(DynamicObject dataEntity, String attr) {
        Object attrValue = dataEntity.get(attr);
        if (attrValue instanceof DynamicObject) {
            return dataEntity.get(attr + ".id");
        }
        return dataEntity.get(attr);
    }

    protected String getShowFieldValue(DynamicObject dataEntity, String attr) {
        Object obj = dataEntity.get(attr);
        return this.getFmtString(obj);
    }

    protected String getFmtString(Object obj) {
        String result = " ";
        if (Objects.nonNull(obj)) {
            if (obj instanceof DynamicObject) {
                result = ((DynamicObject)obj).getString("name");
            } else if (obj instanceof Date) {
                Date date = (Date)obj;
                result = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
            } else {
                result = obj.toString();
            }
        }
        return result;
    }

    protected abstract Set<String> getKeyWord(String var1);

    protected abstract List<Map<String, Object>> getChangeFieldValue(DynamicObject var1, DynamicObject var2, Set<String> var3);
}

