/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.stdrsm.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tstpm.business.domain.sendmessage.pojo.Recipient;
import kd.tsc.tstpm.business.domain.sendmessage.service.ISendMessage;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardEducationExpDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardWorkExpDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.infrastructure.utils.ResumeUtil;
import kd.tsc.tstpm.common.constants.TSTPMStdRsmBizAppConstants;
import kd.tsc.tstpm.common.enums.stdrsm.MsgSceneEnum;
import kd.tsc.tstpm.common.utils.ViewUtils;
import org.apache.commons.lang3.StringUtils;

public class CandidateDetailPageHelper {
    private static final String LABEL_AGE = "lblage";
    private static final String LABEL_PHONE = "lblphone";
    private static DynamicObject stdRsmDy = null;
    private static DynamicObject eduExpDy = null;
    private static DynamicObject workExpDy = null;
    private static String[] fields = new String[]{"picturefield", "id", "name"};

    public static void setHeaderInfo(IFormView formView, Long stdRsmId) {
        Image photo = (Image)formView.getControl("photo");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        String photoUrl = stdRsmDy.getString("photo");
        if (photoUrl != null && photoUrl.length() > 0) {
            photo.setUrl(HRImageUrlUtil.getImageFullUrl((String)photoUrl));
        } else {
            photo.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        HRDynamicObjectUtils.copy((DynamicObject)stdRsmDy, (DynamicObject)dataEntity);
        dataEntity.set("workexp", (Object)ResumeAnalysisHelper.getWorkYearShow((int)Integer.parseInt(stdRsmDy.getString("workingyears"))));
        DynamicObject education = stdRsmDy.getDynamicObject("highesteducation");
        dataEntity.set("highestedu", (Object)(education == null ? "" : education.getString("name")));
        dataEntity.set("recentposition", (Object)stdRsmDy.getString("recentposition"));
    }

    private static String getFieldValue(String pageKey, String fieldKey) {
        String fieldValue = "";
        fieldValue = StringUtils.equals((CharSequence)"tstpm_stdrsm", (CharSequence)pageKey) ? CandidateDetailPageHelper.getFieldValue(stdRsmDy, fieldKey) : (StringUtils.equals((CharSequence)"tstpm_stdeduexp", (CharSequence)pageKey) ? CandidateDetailPageHelper.getFieldValue(eduExpDy, fieldKey) : CandidateDetailPageHelper.getFieldValue(workExpDy, fieldKey));
        switch (fieldKey) {
            case "age": {
                if (!StringUtils.equals((CharSequence)"0", (CharSequence)fieldValue)) {
                    fieldValue = String.format(ResManager.loadKDString((String)"%s\u5c81", (String)"CandidateDetailPageHelper_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]), fieldValue);
                    break;
                }
                fieldValue = "";
                break;
            }
            case "gender": {
                fieldValue = ResumeUtil.conversionGender(fieldValue);
                break;
            }
            case "workingyears": {
                if (!StringUtils.equals((CharSequence)"0", (CharSequence)fieldValue)) {
                    fieldValue = ResumeAnalysisHelper.getWorkYearShow((int)Integer.parseInt(fieldValue));
                    break;
                }
                fieldValue = "";
                break;
            }
        }
        return fieldValue;
    }

    private static String getFieldValue(DynamicObject dynamicObject, String fieldKey) {
        String fieldValueNew = "";
        if (dynamicObject != null && dynamicObject.get(fieldKey) != null) {
            Long id;
            Object fieldValue = dynamicObject.get(fieldKey);
            fieldValueNew = fieldValue instanceof DynamicObject ? ((DynamicObject)fieldValue).getString("name") : Optional.ofNullable(dynamicObject).map(d -> d.getString(fieldKey)).orElseGet(() -> "");
            if (StringUtils.equals((CharSequence)"schoolname", (CharSequence)fieldKey) && TSTPMStdRsmBizAppConstants.OTHER_SCHOOL_ID.equals(id = Long.valueOf(((DynamicObject)fieldValue).getLong("id")))) {
                fieldValueNew = dynamicObject.getString("othschname");
            }
        }
        return fieldValueNew;
    }

    private static void initializeHeadData(Long stdRsmId) {
        stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        long sourceId = stdRsmDy.getLong("sourcevid");
        eduExpDy = StandardEducationExpDataHelper.queryHighestEducationExp(sourceId);
        workExpDy = StandardWorkExpDataHelper.queryRecentWorkExp(sourceId);
    }

    public static void refreshView(IFormView needRefreshView, IFormView currentView) {
        needRefreshView.invokeOperation("refresh");
        currentView.sendFormAction(needRefreshView);
    }

    public static void openSendMessagePage(IFormView formView, MsgSceneEnum msgSceneEnum, List<Long> stdRsmIdList, CloseCallBack closeCallBack) {
        FormShowParameter fsp = new FormShowParameter();
        String caption = msgSceneEnum.getCaption();
        fsp.setCaption(caption);
        fsp.setFormId("tstpm_send_message");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap customParamMap = Maps.newHashMapWithExpectedSize((int)2);
        customParamMap.put("cfgMsgScene", msgSceneEnum);
        customParamMap.put("stdRsmIdList", stdRsmIdList);
        fsp.setCustomParams((Map)customParamMap);
        fsp.setCloseCallBack(closeCallBack);
        if ("tstpm_candidate_detail".equals(formView.getModel().getDataEntityType().getName())) {
            fsp.setPageId(formView.getPageId() + msgSceneEnum.getValue());
        }
        formView.showForm(fsp);
    }

    public static void openDynamicForm(IFormView formView, String formId, ShowType showType, CloseCallBack closeCallBack, Map<String, Object> customParamMap) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(showType);
        fsp.setCustomParams(customParamMap);
        fsp.setCloseCallBack(closeCallBack);
        formView.showForm(fsp);
    }

    public static void setRecipientInfo(List<Recipient> recipientList, AbstractFormDataModel model) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        Arrays.stream(fields).forEach(field -> tableValueSetter.addField(field, new Object[0]));
        recipientList.forEach(recipient -> tableValueSetter.addRow(new Object[]{HRImageUrlUtil.getImageFullUrl((String)recipient.getPhoto()), recipient.getId(), recipient.getName()}));
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
    }

    public static int refreshStdRsmCache(IFormView view, int deleteRowIndex) {
        ViewUtils.setDataChangedFieldInPageCache((IPageCache)view.getPageCache(), (String)"candidate");
        String recipientJson = view.getPageCache().get("recipients");
        JSONArray jsonArray = JSON.parseArray((String)recipientJson);
        jsonArray.remove(deleteRowIndex);
        view.getPageCache().put("recipients", jsonArray.toJSONString());
        view.getPageCache().put("recipientsSize", String.valueOf(jsonArray.size()));
        ISendMessage sendMessage = (ISendMessage)SerializationUtils.deSerializeFromBase64((String)view.getParentView().getPageCache().get("isendmessage"));
        sendMessage.updateVariable(view);
        return jsonArray.size();
    }

    private CandidateDetailPageHelper() {
        throw new IllegalStateException("Utility class");
    }
}

