/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.modal;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleConfigHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.talentpool.modal.ReserveService;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public abstract class AbstractReserveService
implements ReserveService {
    protected DynamicObject ruleConfigDy;
    protected List<String> buNumberList = Lists.newArrayListWithCapacity((int)16);

    public void setRuleConfigNumber(String ruleConfigNumber) {
        this.ruleConfigDy = RuleConfigHelper.getRuleConfigByNumber((String)ruleConfigNumber);
    }

    public void saveReserveRecord(DynamicObject resume, DynamicObject[] poolDys) {
        List<DynamicObject> reserveDtList = this.getReserveTalentPoolList(resume, poolDys);
        OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tstpm_reservere", (DynamicObject[])reserveDtList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        ArrayList<Long> candidateIds = new ArrayList<Long>(1);
        candidateIds.add(resume.getLong("id"));
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        StandardResumeDataHelper.updateModifyTime(Lists.newArrayList(candidateIds));
    }

    public List<DynamicObject> getReserveTalentPoolList(DynamicObject resume, DynamicObject[] poolDys) {
        int length = poolDys.length;
        ArrayList<DynamicObject> reserveDtList = new ArrayList<DynamicObject>(length);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_reservere");
        long[] reserveIds = ORM.create().genLongIds("tstpm_reservere", length);
        int reserveIdIndex = 0;
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject talentPoolDt : poolDys) {
            DynamicObject reserveRecordDt = helper.generateEmptyDynamicObject();
            reserveRecordDt.set("id", (Object)reserveIds[reserveIdIndex]);
            reserveRecordDt.set("creator", (Object)TSCRequestContext.getUserId());
            reserveRecordDt.set("createtime", (Object)nowTime);
            reserveRecordDt.set("modifier", (Object)TSCRequestContext.getUserId());
            reserveRecordDt.set("modifytime", (Object)nowTime);
            reserveRecordDt.set("reserveper", (Object)TSCRequestContext.getUserId());
            reserveRecordDt.set("reservetime", (Object)nowTime);
            reserveRecordDt.set("talentpool", (Object)talentPoolDt);
            reserveRecordDt.set("stdrsm", (Object)resume);
            reserveRecordDt.set("ismerge", (Object)"1");
            reserveDtList.add(reserveRecordDt);
            ++reserveIdIndex;
        }
        return reserveDtList;
    }

    public void addBuNumber(String buNumber) {
        this.buNumberList.add(buNumber);
    }

    public void addTalentPoolDy(List<DynamicObject> talentPoolResult, List<DynamicObject> addTalentPoolList) {
        for (DynamicObject addTalentPoolDy : addTalentPoolList) {
            Optional<DynamicObject> optional = talentPoolResult.stream().filter(dy -> dy.getLong("id") == addTalentPoolDy.getLong("id")).findFirst();
            if (optional.isPresent()) continue;
            talentPoolResult.add(addTalentPoolDy);
        }
    }
}

