/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.modal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.EmailInfoServiceHelper;
import kd.tsc.tsrbd.business.domain.rule.RuleContext;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleBizHelper;
import kd.tsc.tsrbd.business.domain.rule.modal.IRuleModal;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tstpm.business.domain.rule.StdRsmBatchRuleContext;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.business.domain.talentpool.enums.AddResumeEntryEnum;
import kd.tsc.tstpm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tstpm.business.domain.talentpool.modal.AbstractReserveService;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;

public class IReserveService
extends AbstractReserveService {
    private static final Log logger = LogFactory.getLog(IReserveService.class);
    public static final String DEFAULT_POOL_NUMBER = "1010_S";
    private static final String CREATE_ORG = "createorg.number";
    private static final String TALENT_POOL_ORG = "org.number";
    private static final String EMAIL_SOURCE = "emailsource.number";

    @Override
    public void reserveTalentPool(Map<String, DynamicObjectCollection> resumes, DynamicObject[] poolDys) {
        DynamicObject resume = (DynamicObject)resumes.get("tstpm_stdrsm").get(0);
        if (HRArrayUtils.isEmpty((Object[])poolDys)) {
            StdRsmBatchRuleContext batchRuleContext = new StdRsmBatchRuleContext();
            ArrayList talentPoolResult = Lists.newArrayListWithCapacity((int)16);
            for (String buNumber : this.buNumberList) {
                batchRuleContext.setAutoRulesConfig(this.ruleConfigDy);
                batchRuleContext.setBuNumber(buNumber);
                List<Map<String, Object>> engineParam = this.buildRuleEngineParam(resumes, "tstpm_stdrsm");
                batchRuleContext.setInputParamList(engineParam);
                IRuleModal ruleModal = new IRuleModal();
                ruleModal.batchCallRuleEngine((RuleContext)batchRuleContext);
                List<DynamicObject> addTalentPoolList = batchRuleContext.getTalentPoolResult();
                this.addTalentPoolDy(talentPoolResult, addTalentPoolList);
            }
            if (talentPoolResult.isEmpty()) {
                QFilter filter = new QFilter("number", "in", (Object)DEFAULT_POOL_NUMBER);
                this.saveReserveRecord(resume, TalentPoolMgtHelper.queryTalentPool(filter));
            } else {
                this.saveReserveRecord(resume, talentPoolResult.toArray(new DynamicObject[0]));
            }
        } else {
            this.saveReserveRecord(resume, poolDys);
        }
    }

    public List<Map<String, Object>> buildRuleEngineParam(Map<String, DynamicObjectCollection> resumes, String stdRsmMainEntryNumber) {
        DynamicObject resume = (DynamicObject)resumes.get(stdRsmMainEntryNumber).get(0);
        int total = this.getTotalParam(resumes);
        List<Map<String, Object>> result = this.fillResume(resume, total);
        this.fillResumeEntry(resumes, total, result);
        return result;
    }

    private void fillResumeEntry(Map<String, DynamicObjectCollection> resumes, int total, List<Map<String, Object>> result) {
        for (Map.Entry<String, DynamicObjectCollection> entry : resumes.entrySet()) {
            String key = entry.getKey();
            DynamicObjectCollection collection = entry.getValue();
            if (key.equals("tstpm_stdrsm") || !Objects.nonNull(collection)) continue;
            int size = collection.size();
            int step = total / size;
            for (int i = 0; i < size; ++i) {
                int low = i * step;
                int high = (i + 1) * step;
                for (int j = 0; j < total; ++j) {
                    String resumeValue;
                    if (j < low || j >= high || StringUtils.isEmpty((CharSequence)(resumeValue = AddResumeEntryEnum.getValue(key)))) continue;
                    result.get(j).put(AddResumeEntryEnum.getValue(key), collection.get(i));
                }
            }
        }
    }

    private List<Map<String, Object>> fillResume(DynamicObject resume, int total) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)total);
        for (int i = 0; i < total; ++i) {
            HashMap rsmMap = Maps.newHashMapWithExpectedSize((int)16);
            rsmMap.put(AddResumeEntryEnum.KEY_STD_RSM.getValue(), resume);
            result.add(rsmMap);
        }
        return result;
    }

    private int getTotalParam(Map<String, DynamicObjectCollection> resumes) {
        int total = 1;
        for (Map.Entry<String, DynamicObjectCollection> entry : resumes.entrySet()) {
            DynamicObjectCollection collection = entry.getValue();
            if (!Objects.nonNull(collection)) continue;
            total *= collection.size();
        }
        return total;
    }

    public void setBuNumber(AppResumeBo appResumeBo, ResumeTypeEnum typeEnum) {
        if (null != appResumeBo.getPosition()) {
            this.addBuNumber(appResumeBo.getPosition().getString(CREATE_ORG));
        } else if (null != appResumeBo.getTalentId()) {
            DynamicObject talentPool = TalentPoolFunHelper.queryOneTalentPool(appResumeBo.getTalentId());
            this.addBuNumber(talentPool.getString(TALENT_POOL_ORG));
        } else if (typeEnum == ResumeTypeEnum.EMAIL) {
            List policyEntityBu = RuleBizHelper.getPolicyEntityBu((DynamicObject)this.ruleConfigDy);
            for (DynamicObject org : policyEntityBu) {
                if (!this.emailBu(appResumeBo, org)) continue;
                this.addBuNumber(org.getString("number"));
                break;
            }
        }
    }

    public List<String> getBuNumber(AppResumeBo appResumeBo, ResumeTypeEnum typeEnum, String sceneNumber) {
        if (null != appResumeBo.getPosition()) {
            return Collections.singletonList(appResumeBo.getPosition().getString(CREATE_ORG));
        }
        if (null != appResumeBo.getTalentId()) {
            DynamicObject talentPool = TalentPoolFunHelper.queryOneTalentPool(appResumeBo.getTalentId());
            return Collections.singletonList(talentPool.getString(TALENT_POOL_ORG));
        }
        if (typeEnum == ResumeTypeEnum.EMAIL) {
            DynamicObject[] policyEntityArr = RuleBizHelper.queryRulePolicyListBySceneNumber((String)sceneNumber);
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : policyEntityArr) {
                collection.addAll((Collection)dynamicObject.getDynamicObjectCollection("entrybulist"));
            }
            List<Object> policyObjList = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject dy : collection) {
                DynamicObject dynamicObject = dy.getDynamicObject("entitybu");
                policyObjList.add(dynamicObject);
                boolean containsSub = dy.getBoolean("containssub");
                if (!containsSub) continue;
                List childDy = RuleBizHelper.getChildDy((DynamicObject)dy);
                policyObjList.addAll(childDy);
            }
            policyObjList = policyObjList.stream().distinct().collect(Collectors.toList());
            ArrayList buNumberList = Lists.newArrayListWithExpectedSize((int)policyObjList.size());
            for (DynamicObject dynamicObject : policyObjList) {
                if (!this.emailBu(appResumeBo, dynamicObject)) continue;
                buNumberList.add(dynamicObject.getString("number"));
            }
            return buNumberList;
        }
        return null;
    }

    private boolean emailBu(AppResumeBo appResumeBo, DynamicObject orgDy) {
        DynamicObject delivery = appResumeBo.getDelivery();
        String emailNumber = delivery.getString(EMAIL_SOURCE);
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_cfgmail", (Long)orgDy.getLong("id"));
        filter.and("number", "=", (Object)emailNumber);
        Object[] emailInfo = EmailInfoServiceHelper.getEmailInfo((QFilter[])new QFilter[]{filter});
        return !HRArrayUtils.isEmpty((Object[])emailInfo);
    }
}

