/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;

public class TalentListDaoHelper {
    private static TalentListDaoHelper talentListDaoHelper = new TalentListDaoHelper();

    private TalentListDaoHelper() {
    }

    public static TalentListDaoHelper getInstance() {
        return talentListDaoHelper;
    }

    public List<Long> getLabelRelationStdId(List<Long> labIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_stdrsmlabel");
        QFilter stdFilter = new QFilter("tagobjtypeid", "=", (Object)LabelTagObjTypeEnum.OUT_STDRSM.getId());
        if (labIds.size() > 0) {
            stdFilter.and("labelid", "in", labIds);
        }
        DynamicObject[] dynamicObjects = serviceHelper.query("tagobjid", stdFilter.toArray());
        ArrayList<Long> stdIds = new ArrayList<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.get("tagobjid") == null) continue;
            stdIds.add(dynamicObject.getLong("tagobjid"));
        }
        return StdRsmServiceHelper.getSouStdRsmMid(stdIds);
    }

    public DataSet getStdReserveDataSet(List<Long> list) {
        QFilter mergeFilter = new QFilter("stdrsm", "in", list);
        QFilter talentPoolFilter = new QFilter("talentpool.id", "!=", (Object)1010L);
        mergeFilter.and(talentPoolFilter);
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)TalentListDaoHelper.class.getName(), (String)"tstpm_reservere", (String)"stdrsm id,talentpool", (QFilter[])mergeFilter.toArray(), (String)"");
        return reserveData;
    }

    public DynamicObject[] getStdReserve(List<Long> childIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        String selectProperties = "talentpool,stdrsm";
        QFilter filter = new QFilter("talentpool.id", "in", childIdList);
        DynamicObject[] dynamicObjects = serviceHelper.query("talentpool,stdrsm", new QFilter[]{filter});
        return dynamicObjects;
    }

    public DynamicObjectCollection getStdSortAppFile(List<Long> list) {
        List<Long> mergeStdIds = StandardResumeDataHelper.getMergeStdIds(list);
        mergeStdIds.addAll(list);
        String selectPro = "id,stdrsm,recrustg.id,recrustat.id,enterlinktime,validrecruchnlnm";
        QFilter aFilter = new QFilter("stdrsm", "in", list);
        aFilter.and(new QFilter("filestatus", "=", (Object)"A"));
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"tspr_appfile", (String)"id,stdrsm,recrustg.id,recrustat.id,enterlinktime,validrecruchnlnm", (QFilter[])aFilter.toArray(), (String)"enterlinktime desc");
        Map<Long, DynamicObject> longDynamicObjectMap = StandardResumeDataHelper.batchQueryStdRsmToMap(list);
        for (int k = 0; k < collections.size(); ++k) {
            long aLong = ((DynamicObject)collections.get(k)).getLong("stdrsm");
            ((DynamicObject)collections.get(k)).set("stdrsm", longDynamicObjectMap.get(aLong).get("mid"));
        }
        return collections;
    }

    public DynamicObject[] getStdRsm(List<Long> list) {
        QFilter mainFilter = new QFilter("stdrsm", "in", list);
        HRBaseServiceHelper resumeServiceHelper = new HRBaseServiceHelper("tstpm_rsm");
        String selectResume = "id,stdrsm,delivery.recruchnlnm.name";
        DynamicObject[] resumeDynObj = resumeServiceHelper.query("id,stdrsm,delivery.recruchnlnm.name", mainFilter.toArray(), "delivery.applytime");
        return resumeDynObj;
    }

    public DynamicObject getTalentPool(String talentPoolId) {
        HRBaseServiceHelper talentServiceHelper = new HRBaseServiceHelper("tstpm_talentpoolmgt");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(talentPoolId));
        DynamicObject dynObj = talentServiceHelper.queryOne("number,creator,pooltype", new QFilter[]{qFilter});
        return dynObj;
    }

    public DynamicObject[] getTalentPools(List<Long> talentPoolIds) {
        HRBaseServiceHelper talentServiceHelper = new HRBaseServiceHelper("tstpm_talentpoolmgt");
        QFilter qFilter = new QFilter("id", "in", talentPoolIds);
        DynamicObject[] dynObj = talentServiceHelper.query("name,number,creator,pooltype", new QFilter[]{qFilter});
        return dynObj;
    }

    public DynamicObject[] getSubTalentPool(String talentPoolId, DynamicObject dynObj, Long creator) {
        QFilter childFilter;
        HRBaseServiceHelper talentServiceHelper = new HRBaseServiceHelper("tstpm_talentpoolmgt");
        if ("1040".equals(talentPoolId)) {
            DynamicObject[] shareTalentPool = CheckPermissionHelper.getInstance().getShareTalentPool();
            ArrayList shareIdList = Lists.newArrayListWithCapacity((int)shareTalentPool.length);
            for (DynamicObject shareDynObj : shareTalentPool) {
                shareIdList.add(shareDynObj.getLong("id"));
            }
            childFilter = new QFilter("id", "in", (Object)shareIdList);
        } else if (TSCRequestContext.getUserId() != creator && "B".equals(dynObj.get("pooltype"))) {
            childFilter = new QFilter("id", "=", (Object)Long.parseLong(talentPoolId));
        } else {
            String number = "%" + dynObj.getString("number") + "%";
            childFilter = new QFilter("longnumber", "like", (Object)number);
        }
        DynamicObject[] dynObjAllChild = talentServiceHelper.query("id", new QFilter[]{childFilter});
        return dynObjAllChild;
    }

    public DynamicObject[] getCandidateDts(List<Long> candidateIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", candidateIds);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("id,fullname,number,mid", qFilter.toArray(), null);
        return dynamicObjects;
    }

    public DynamicObject[] getBlackDelCandiDateDts(List<Long> candidateIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", candidateIds);
        QFilter blackFilter = new QFilter("datastatus", "=", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
        blackFilter.or("datastatus", "=", (Object)ResumeHisDataStatusEnum.DELETED.getStatus());
        qFilter.and(blackFilter);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("id", qFilter.toArray());
        return dynamicObjects;
    }

    public List<Long> getBlackCandiDateDts(List<Long> candidateIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", candidateIds);
        QFilter blackFilter = new QFilter("datastatus", "=", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
        qFilter.and(blackFilter);
        DynamicObject[] dys = hrBaseServiceHelper.query("id", qFilter.toArray());
        return Arrays.stream(dys).map(dynamicObject -> dynamicObject.getLong("id")).distinct().collect(Collectors.toList());
    }

    public DynamicObject[] getStdRsmStatusData(Long candidateId, String status) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "=", (Object)candidateId);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)status);
        qFilter.and(statusFilter);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("id,datastatus", qFilter.toArray());
        return dynamicObjects;
    }

    public DynamicObjectCollection getStdAppFile(List<Long> list) {
        QFilter aFilter = new QFilter("stdrsm", "in", list);
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"tspr_appfile", (String)"id,stdrsm", (QFilter[])aFilter.toArray());
        Map<Long, DynamicObject> longDynamicObjectMap = StandardResumeDataHelper.batchQueryStdRsmToMap(list);
        for (int k = 0; k < collections.size(); ++k) {
            long aLong = ((DynamicObject)collections.get(k)).getLong("stdrsm");
            ((DynamicObject)collections.get(k)).set("stdrsm", longDynamicObjectMap.get(aLong).get("mid"));
        }
        return collections;
    }

    public DynamicObject[] getReserveByCandidateId(List<Long> candidateIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        String selectProperties = "talentpool,stdrsm";
        QFilter filter = new QFilter("stdrsm.id", "in", candidateIds);
        return serviceHelper.query("talentpool,stdrsm", new QFilter[]{filter});
    }

    public List<Long> getReserveStdIds(List<Long> talentIds, List<Long> candidateIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        QFilter qFilter = new QFilter("talentpool", "in", talentIds);
        qFilter.and(new QFilter("stdrsm.mid", "in", candidateIds));
        DynamicObject[] dynObjTalent = serviceHelper.query("id,stdrsm.mid", qFilter.toArray());
        ArrayList<Long> stdSups = new ArrayList<Long>(dynObjTalent.length);
        for (DynamicObject dynObjTal : dynObjTalent) {
            if (dynObjTal.get("stdrsm.mid") == null) continue;
            stdSups.add(dynObjTal.getLong("stdrsm.mid"));
        }
        return stdSups;
    }
}

