/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListDaoHelper;

public class TalentListFilterServiceHelper {
    private static final String NOTEXISTS = "not exists";
    private static final String NOTNULL = "is not null";
    private static final String NOTIN = "NOT IN";
    private static final String NOTEQUALS = "<>";
    private static final String NOTLIKE = "NOT LIKE";
    private static final HashMap<Object, Object> LABEL_CATEGORY = Maps.newHashMapWithExpectedSize((int)3);
    private static TalentListFilterServiceHelper talentListServiceHelper;

    private TalentListFilterServiceHelper() {
    }

    public static TalentListFilterServiceHelper getInstance() {
        return talentListServiceHelper;
    }

    public CommonFilterColumn addLabelFilterColumn(CommonFilterColumn labelColumn) {
        labelColumn.setDefaultValue("");
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        ArrayList<Long> tagObjTypeIds = new ArrayList<Long>(1);
        tagObjTypeIds.add(LabelTagObjTypeEnum.OUT_STDRSM.getId());
        DynamicObject[] labels = LabelDataHelper.getLabelsByObjType(tagObjTypeIds);
        int objSize = labels.length;
        for (int i = 0; i < objSize; ++i) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(labels[i].getString("name") + LABEL_CATEGORY.get(labels[i].getString("labelcategory"))));
            item.setValue(labels[i].getString("id"));
            combos.add(item);
        }
        labelColumn.setComboItems(combos);
        return labelColumn;
    }

    public void handlePageFilter(List<QFilter> oldFilters, int index, Map<QFilter, QFilter> map, String property) {
        switch (property) {
            case "lableinfo": 
            case "lableinfo.id": {
                Object labelValue = oldFilters.get(index).getValue();
                QFilter commLabFilter = this.getLabelFilter(oldFilters, labelValue);
                map.put(oldFilters.get(index), commLabFilter);
                break;
            }
            case "datarange": {
                String dataValue = oldFilters.get(index).getValue().toString();
                if ("A".equals(dataValue)) {
                    List<Long> curTalentAuthStdInfo = CheckPermissionHelper.getInstance().getCurTalentAuthStdInfo();
                    QFilter qFilter = new QFilter("id", "in", curTalentAuthStdInfo);
                    map.put(oldFilters.get(index), qFilter);
                    break;
                }
                QFilter qFilter = new QFilter("id", NOTNULL, (Object)"");
                map.put(oldFilters.get(index), qFilter);
                break;
            }
            case "contact": {
                Object contactValue = oldFilters.get(index).getValue();
                QFilter qFilter = this.getContactFilter(contactValue);
                map.put(oldFilters.get(index), qFilter);
                break;
            }
            case "lableinfo.name": {
                QFilter schLabFilter = this.setLabelSchemeQuery(oldFilters, index);
                if (schLabFilter == null) break;
                map.put(oldFilters.get(index), schLabFilter);
                break;
            }
        }
    }

    private QFilter getLabelFilter(List<QFilter> oldFilters, Object value) {
        QFilter commLabFilter;
        ArrayList<Long> labIds = new ArrayList<Long>(oldFilters.size());
        if (value instanceof Long) {
            long labId = (Long)value;
            labIds.add(labId);
            List<Long> labelRelationStdId = TalentListDaoHelper.getInstance().getLabelRelationStdId(labIds);
            commLabFilter = new QFilter("id", "in", labelRelationStdId);
        } else if (value instanceof List) {
            List labId = (List)value;
            labIds.addAll(labId);
            List<Long> labelRelationStdId = TalentListDaoHelper.getInstance().getLabelRelationStdId(labIds);
            commLabFilter = new QFilter("id", "in", labelRelationStdId);
        } else {
            List<Long> labelRelationStdId = TalentListDaoHelper.getInstance().getLabelRelationStdId(labIds);
            commLabFilter = new QFilter("id", "not in", labelRelationStdId);
        }
        return commLabFilter;
    }

    private QFilter getContactFilter(Object value) {
        QFilter qFilter;
        if (value instanceof String) {
            String contact = (String)value;
            qFilter = this.getContentQFilter(contact);
        } else {
            List contacts = (List)value;
            qFilter = this.getContentQFilter((String)contacts.get(0));
            for (int j = 1; j < contacts.size(); ++j) {
                qFilter = qFilter.or(this.getContentQFilter((String)contacts.get(j)));
            }
        }
        return qFilter;
    }

    private QFilter getContentQFilter(String contact) {
        QFilter qFilter = "A".equals(contact) ? new QFilter("phone", "!=", (Object)" ") : ("B".equals(contact) ? new QFilter("phone", "=", (Object)" ") : ("C".equals(contact) ? new QFilter("email", "!=", (Object)" ") : new QFilter("email", "=", (Object)" ")));
        return qFilter;
    }

    private QFilter setLabelSchemeQuery(List<QFilter> oldFilters, int index) {
        QFilter schLabFilter;
        String cpValue = oldFilters.get(index).getCP();
        if (NOTNULL.equals(cpValue)) {
            ArrayList<Long> labIds = new ArrayList<Long>(oldFilters.size());
            List<Long> labelRelationStdId = TalentListDaoHelper.getInstance().getLabelRelationStdId(labIds);
            schLabFilter = new QFilter("id", "in", labelRelationStdId);
        } else {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_label");
            QFilter filter = LabelDataHelper.getLabelQfilter();
            QFilter qFilter = this.getDropFilterAss(oldFilters, index, filter);
            DynamicObject[] dynamicObjects = serviceHelper.query("id", new QFilter[]{qFilter});
            ArrayList<Long> labIds = new ArrayList<Long>(dynamicObjects.length);
            for (DynamicObject dynObj : dynamicObjects) {
                labIds.add(dynObj.getLong("id"));
            }
            if (labIds.size() > 0) {
                List<Long> labelRelationStdId = TalentListDaoHelper.getInstance().getLabelRelationStdId(labIds);
                schLabFilter = new QFilter("id", "in", labelRelationStdId);
            } else {
                schLabFilter = new QFilter("1", "!=", (Object)1);
            }
        }
        return schLabFilter;
    }

    private QFilter getDropFilterAss(List<QFilter> oldFilters, int index, QFilter filter) {
        if (NOTIN.equals(oldFilters.get(index).getCP().toUpperCase())) {
            filter = filter.and(new QFilter("name", "not in", oldFilters.get(index).getValue()));
        } else if (NOTEQUALS.equals(oldFilters.get(index).getCP())) {
            QFilter qNotEqFilter = new QFilter("name", "!=", oldFilters.get(index).getValue());
            qNotEqFilter.or(new QFilter("name", "is null", null));
            filter = filter.and(qNotEqFilter);
        } else if (NOTLIKE.equals(oldFilters.get(index).getCP().toUpperCase())) {
            filter = filter.and(new QFilter("name", "not like", oldFilters.get(index).getValue()));
        } else {
            QFilter qFilter = oldFilters.get(index);
            qFilter.__setProperty("name");
            filter = filter.and(qFilter);
        }
        return filter;
    }

    static {
        LABEL_CATEGORY.put("A", "(IL)");
        LABEL_CATEGORY.put("B", "(PL)");
        LABEL_CATEGORY.put("C", "(AI)");
        talentListServiceHelper = new TalentListFilterServiceHelper();
    }
}

