/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import com.google.common.collect.ImmutableList;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.RecycleTaskServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.MailRecycleCount;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.rsm.YesOrNotEnum;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import kd.tsc.tstpm.business.domain.rsm.sr.entity.RsmRecommend;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmApiService;
import kd.tsc.tstpm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tstpm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tstpm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tstpm.business.domain.talentpool.entity.TalentPoolMessageEntity;
import kd.tsc.tstpm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.common.utils.TalentPoolDeseUtil;
import org.apache.commons.collections.CollectionUtils;

public class TalentListFunService {
    private static final Log logger = LogFactory.getLog(TalentListFunService.class);
    private static final String NOTBTNKEY = "<>";

    public static DynamicObject[] saveReserveRecord(List<Long> talentPoolIds, List<Long> candidateIds) {
        int totalCount = talentPoolIds.size() * candidateIds.size();
        DynamicObject[] talentPoolDtArrays = TalentPoolFunHelper.queryTalentPoolDtArrays(talentPoolIds);
        ArrayList<DynamicObject> reserveDtList = new ArrayList<DynamicObject>(totalCount);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        long[] reserveIds = ORM.create().genLongIds(serviceHelper.getEntityName(), totalCount);
        int reserveIdIndex = 0;
        for (DynamicObject talentPoolDt : talentPoolDtArrays) {
            for (Long candidateId : candidateIds) {
                DynamicObject reserveRecordDt = serviceHelper.generateEmptyDynamicObject();
                Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                reserveRecordDt.set("id", (Object)reserveIds[reserveIdIndex]);
                reserveRecordDt.set("creator", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("createtime", (Object)nowTime);
                reserveRecordDt.set("modifier", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("modifytime", (Object)nowTime);
                reserveRecordDt.set("reserveper", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("reservetime", (Object)nowTime);
                reserveRecordDt.set("talentpool", (Object)talentPoolDt);
                reserveRecordDt.set("stdrsm", (Object)candidateId);
                reserveDtList.add(reserveRecordDt);
                ++reserveIdIndex;
            }
        }
        return reserveDtList.toArray(new DynamicObject[reserveDtList.size()]);
    }

    public static String returnSaveResult() {
        TalentPoolFallMessage talentPoolFallMessage = new TalentPoolFallMessage();
        talentPoolFallMessage.setFlag(true);
        talentPoolFallMessage.setTitleMsg(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u50a8\u5907\u6210\u529f\u3002", (String)"TALENTLIST_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        return SerializationUtils.toJsonString((Object)talentPoolFallMessage);
    }

    public static DynamicObject[] removeReserveRecord(List<Long> oldTalentPoolIds, List<Long> candidateIds) {
        ArrayList talentPoolIds = new ArrayList();
        CollectionUtils.addAll(talentPoolIds, (Object[])new Object[oldTalentPoolIds.size()]);
        Collections.copy(talentPoolIds, oldTalentPoolIds);
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "in", talentPoolIds);
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        DynamicObject[] reserveRecordDtArrays = serviceHelper.query("id, talentpool, stdrsm", new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
        ArrayList<Long> reserveRecordIds = new ArrayList<Long>(reserveRecordDtArrays.length);
        for (DynamicObject reserveRecordDtDt : reserveRecordDtArrays) {
            reserveRecordIds.add(reserveRecordDtDt.getLong("id"));
        }
        serviceHelper.delete(reserveRecordIds.toArray());
        List<Long> mergeIds = StandardResumeDataHelper.getMergeStdIds(candidateIds);
        QFilter mergeIdsFilter = new QFilter("stdrsm", "in", mergeIds);
        HRBaseServiceHelper mergeHelper = new HRBaseServiceHelper("tstpm_reservere");
        DynamicObject[] mergeRecordDtArrays = mergeHelper.query("id", new QFilter[]{talentPoolIdsFilter, mergeIdsFilter});
        ArrayList<Long> mergeRecordIds = new ArrayList<Long>(mergeRecordDtArrays.length);
        for (DynamicObject mergeDt : mergeRecordDtArrays) {
            mergeRecordIds.add(mergeDt.getLong("id"));
        }
        mergeHelper.delete(mergeRecordIds.toArray());
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        return reserveRecordDtArrays;
    }

    public static void transferTalentPool(List<Long> candidateIds, List<Long> oldTalentPoolIds, List<Long> talentPoolIds, IFormView view) {
        TXHandle tx = TX.required();
        try {
            DynamicObject[] reserveRecordDtArrays = TalentListFunService.removeReserveRecord(oldTalentPoolIds, candidateIds);
            if (reserveRecordDtArrays.length == 0) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8f6c\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"TalentListFunService_8", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                tx.markRollback();
                return;
            }
            DynamicObject[] addReserveDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
            OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tstpm_reservere", (DynamicObject[])addReserveDtArrays, (OperateOption)OperateOption.create());
            int errorCount = addOperationResult.getValidateResult().errorSize();
            if (errorCount > 0) {
                String talentPoolName = addReserveDtArrays[0].getDynamicObject("talentpool").getString("name");
                view.showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u50a8\u5907\u5728%s\u4e0b\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u50a8\u5907\u3002", (String)"TalentListFunService_9", (String)"tsc-tstpm-business", (Object[])new Object[0]), talentPoolName));
                tx.markRollback();
                return;
            }
            StandardResumeDataHelper.updateModifyTime(candidateIds);
            StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u5e93\u6210\u529f\u3002", (String)"ReserveReListPlugin_3", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            TalentPoolOperateRecordService.getInstance().transferOpRecord(addReserveDtArrays, oldTalentPoolIds);
        }
        catch (Exception e) {
            logger.error("TalentListFunService.transferTalentpool.error", (Throwable)e);
            tx.markRollback();
            throw e;
        }
        finally {
            tx.close();
            view.updateView();
            view.invokeOperation("refresh");
        }
    }

    public static void saveCandidate2UnClassFy(List<Long> candidateIds) {
        HRBaseServiceHelper queryHelper = new HRBaseServiceHelper("tstpm_reservere");
        QFilter candidateIdFilter = new QFilter("stdrsm", "=", (Object)candidateIds.get(0));
        DynamicObject[] candidateDtArray = queryHelper.query(new QFilter[]{candidateIdFilter});
        if (candidateDtArray.length > 0) {
            return;
        }
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(1);
        talentPoolIds.add(1010L);
        DynamicObject[] unClassFyDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("tstpm_reservere");
        baseServiceHelper.save(unClassFyDtArrays);
        StandardResumeDataHelper.updateModifyTime(candidateIds);
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
    }

    public static void updateReserveRecord(DynamicObject mergeFrom, DynamicObject mergeTo) {
        boolean flag = false;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        QFilter filter = new QFilter("stdrsm", "in", (Object)mergeFrom.getLong("id"));
        Object[] reserveDtArrays = serviceHelper.query("talentpool", new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])reserveDtArrays)) {
            return;
        }
        HRBaseServiceHelper serviceMainHelper = new HRBaseServiceHelper("tstpm_reservere");
        QFilter mainFilter = new QFilter("stdrsm", "in", (Object)mergeTo.getLong("id"));
        Object[] reserveMainDtArrays = serviceMainHelper.query("talentpool", new QFilter[]{mainFilter});
        if (HRArrayUtils.isEmpty((Object[])reserveMainDtArrays)) {
            return;
        }
        DynamicObject[] saveDtArrays = new DynamicObject[reserveDtArrays.length];
        long[] reserveIds = ORM.create().genLongIds(serviceHelper.getEntityName(), reserveDtArrays.length);
        int rowIndex = 0;
        for (Object reserveDt : reserveDtArrays) {
            if (!"1010".equals(reserveDt.getDynamicObject("talentpool").get("masterid").toString())) {
                DynamicObject reserveRecordDt = serviceHelper.generateEmptyDynamicObject();
                Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                reserveRecordDt.set("id", (Object)reserveIds[rowIndex]);
                reserveRecordDt.set("creator", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("createtime", (Object)nowTime);
                reserveRecordDt.set("modifier", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("modifytime", (Object)nowTime);
                reserveRecordDt.set("reserveper", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("reservetime", (Object)nowTime);
                reserveRecordDt.set("talentpool", (Object)reserveDt.getDynamicObject("talentpool"));
                reserveRecordDt.set("stdrsm", (Object)mergeTo);
                saveDtArrays[rowIndex] = reserveRecordDt;
                flag = true;
            }
            ++rowIndex;
        }
        if (saveDtArrays.length != 0 && saveDtArrays[0] != null) {
            OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tstpm_reservere", (DynamicObject[])saveDtArrays, (OperateOption)OperateOption.create());
            TalentPoolOperateRecordService.getInstance().reserveOpRecord(saveDtArrays, addOperationResult);
        }
        HRBaseServiceHelper deleteReserveHelper = new HRBaseServiceHelper("tstpm_reservere");
        ArrayList<Long> reserveRecordIds = new ArrayList<Long>(reserveDtArrays.length + 1);
        for (Object reserveRecordDtDt : reserveDtArrays) {
            reserveRecordIds.add(reserveRecordDtDt.getLong("id"));
        }
        for (Object dynamicObject : reserveMainDtArrays) {
            if (!HRStringUtils.equals((String)"1010", (String)dynamicObject.getDynamicObject("talentpool").get("masterid").toString()) || !flag) continue;
            reserveRecordIds.add(dynamicObject.getLong("id"));
        }
        deleteReserveHelper.delete(reserveRecordIds.toArray());
    }

    public static List<MailRecycleCount> queryEmailCollectResumeCount(DynamicObject[] appResumeDtArrays, LocalDate startDate) {
        if (appResumeDtArrays.length < 1) {
            return new ArrayList<MailRecycleCount>(0);
        }
        ArrayList<Long> resumeIds = new ArrayList<Long>(appResumeDtArrays.length);
        for (DynamicObject appResumeDt : appResumeDtArrays) {
            resumeIds.add(appResumeDt.getLong("id"));
        }
        RecycleTaskServiceHelper recycleTaskServiceHelper = new RecycleTaskServiceHelper();
        return recycleTaskServiceHelper.getMailRecycleCount(resumeIds, startDate);
    }

    public static Map<String, String> showReserveRecordMessage(DynamicObject[] reserveDtArrays, OperationResult operationResult) {
        ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
        if (validateResultCollection == null) {
            return new HashMap<String, String>(0);
        }
        HashSet errorPkIdsSet = validateResultCollection.getErrorPkIds();
        List<DynamicObject> reserveDtList = Arrays.asList(reserveDtArrays);
        String titleMsg = String.format(ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u6761\u50a8\u5907\u7533\u8bf7\uff0c%s\u6761\u50a8\u5907\u6210\u529f\uff0c%s\u6761\u50a8\u5907\u5931\u8d25\u3002\n", (String)"TalentListFunService_0", (String)"tsc-tstpm-business", (Object[])new Object[0]), reserveDtList.size(), reserveDtList.size() - errorPkIdsSet.size(), errorPkIdsSet.size());
        StringBuilder errorMsgTotal = new StringBuilder();
        for (DynamicObject reserveDt : reserveDtList) {
            for (Object errorPkId : errorPkIdsSet) {
                if (!HRStringUtils.equals((String)errorPkId.toString(), (String)String.valueOf(reserveDt.getLong("id")))) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff08%s\uff09\uff0c\u5df2\u5f52\u5c5e%s\uff08%s\uff09\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u50a8\u5907\u3002\n", (String)"TalentListFunService_1", (String)"tsc-tstpm-business", (Object[])new Object[0]), StandardResumeDataHelper.queryOne(reserveDt.getLong("stdrsm")).getString("fullname"), StandardResumeDataHelper.queryOne(reserveDt.getLong("stdrsm")).getString("number"), reserveDt.getDynamicObject("talentpool").getString("name"), reserveDt.getDynamicObject("talentpool").getString("number"));
                errorMsgTotal.append(errorMsg);
            }
        }
        HashMap<String, String> returnMap = new HashMap<String, String>(2);
        returnMap.put("titleMsg", titleMsg);
        returnMap.put("errorMsgTotal", errorMsgTotal.toString());
        return returnMap;
    }

    public static Map<String, String> showTalentPoolPermMessage(List<Long> talentPoolIdsWithOutPerm, int totalCount, int successCount) {
        String titleMsg = String.format(ResManager.loadKDString((String)"\u5171\u79fb\u9664%s\u4e2a\u5e93\uff0c%s\u4e2a\u6709\u64cd\u4f5c\u6743\u9650\uff0c%s\u4e2a\u65e0\u64cd\u4f5c\u6743\u9650\u3002\n\u60a8\u6ca1\u6709\"\u79fb\u9664\"\u6743\u9650\u7684\u4eba\u624d\u5e93\u540d\u5355\uff1a", (String)"TalentListFunService_6", (String)"tsc-tstpm-business", (Object[])new Object[0]), totalCount, successCount, talentPoolIdsWithOutPerm.size());
        QFilter qFilter = new QFilter("id", "in", talentPoolIdsWithOutPerm);
        DynamicObject[] talentPoolWithOutPermDts = TalentPoolMgtHelper.queryTalentPool(qFilter);
        StringBuilder errorMsgTotal = new StringBuilder();
        for (DynamicObject talentPool : talentPoolWithOutPermDts) {
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff08%s\uff09", (String)"TalentListFunService_7", (String)"tsc-tstpm-business", (Object[])new Object[0]), talentPool.getString("name"), talentPool.getString("number"));
            errorMsgTotal.append(errorMsg);
        }
        HashMap<String, String> returnMap = new HashMap<String, String>(2);
        returnMap.put("titleMsg", titleMsg);
        returnMap.put("errorMsgTotal", errorMsgTotal.toString());
        return returnMap;
    }

    public static TalentPoolFallMessage saveAppFile(List<Long> candidateIds, List<Long> positionIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrdelivery");
        DynamicObject deliveryDt = hrBaseServiceHelper.generateEmptyDynamicObject();
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        deliveryDt.set("id", (Object)ID.genLongId());
        deliveryDt.set("applytime", (Object)nowTime);
        deliveryDt.set("recruchnlmedia", (Object)1010L);
        deliveryDt.set("appmthd", (Object)1040L);
        deliveryDt.set("resacqmthd", (Object)1080L);
        deliveryDt.set("recruchnlnm", (Object)1200L);
        deliveryDt.set("isfiledisplay", (Object)YesOrNotEnum.YES.toString());
        deliveryDt.set("deliveryper", (Object)TSCRequestContext.getUserId());
        deliveryDt.set("creator", (Object)TSCRequestContext.getUserId());
        deliveryDt.set("createtime", (Object)nowTime);
        deliveryDt.set("modifier", (Object)TSCRequestContext.getUserId());
        deliveryDt.set("modifytime", (Object)nowTime);
        RsmRecommend rsmRecommend = new RsmRecommend();
        rsmRecommend.setStdRsmIds(candidateIds);
        rsmRecommend.setPositionIds(positionIds);
        rsmRecommend.setDeliveryDy(deliveryDt);
        RsmApiService.getInstance().recommendPosition(rsmRecommend);
        int totalCount = candidateIds.size() * positionIds.size();
        logger.info("TalentListFunService.saveAppFile.count:{}", (Object)totalCount);
        logger.info("TalentListFunService.saveAppFile.failPositionList:{}", rsmRecommend.getFailPositions());
        TalentPoolOperateRecordService.getInstance().recommondOpRecord(candidateIds, positionIds, rsmRecommend.getFailPositions());
        return TalentListFunService.showFailPosition(totalCount, rsmRecommend.getFailPositions());
    }

    private static TalentPoolFallMessage showFailPosition(int totalCount, List<RsmRecommend.FailPosition> failPositionList) {
        TalentPoolFallMessage talentPoolFallMessage = new TalentPoolFallMessage();
        int positionFailCOunt = 0;
        if (CollectionUtils.isNotEmpty(failPositionList)) {
            positionFailCOunt = failPositionList.size();
        }
        if (totalCount > 1) {
            if (positionFailCOunt < 1) {
                talentPoolFallMessage.setFlag(true);
                talentPoolFallMessage.setTitleMsg(String.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u63a8\u8350\u6210\u529f\u3002", (String)"TalentListFunService_2", (String)"tsc-tstpm-business", (Object[])new Object[0]), new Object[0]));
                return talentPoolFallMessage;
            }
            StringBuilder errorMsgTotal = new StringBuilder();
            int errorCount = 0;
            for (RsmRecommend.FailPosition failPosition : failPositionList) {
                errorCount += failPosition.getStdRsmDys().size();
                for (DynamicObject stdDt : failPosition.getStdRsmDys()) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff08%s\uff09\uff0c\u5df2\u6295\u9012%s\uff08%s\uff09\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63a8\u8350\u3002\n", (String)"TalentListFunService_5", (String)"tsc-tstpm-business", (Object[])new Object[0]), stdDt.getString("fullname"), stdDt.getString("number"), failPosition.getPositionDy().getString("name"), failPosition.getPositionDy().getString("number"));
                    errorMsgTotal.append(errorMsg);
                }
            }
            logger.info("TalentListServiceHelper.showFailPosition.errorCount:{}", (Object)errorCount);
            talentPoolFallMessage.setFlag(false);
            talentPoolFallMessage.setTitleMsg(String.format(ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u6761\u63a8\u8350\u7533\u8bf7\uff0c%s\u6761\u63a8\u8350\u6210\u529f\uff0c%s\u6761\u63a8\u8350\u5931\u8d25\u3002\n", (String)"TalentListFunService_3", (String)"tsc-tstpm-business", (Object[])new Object[0]), totalCount, totalCount - errorCount, errorCount));
            talentPoolFallMessage.setErrorMsgTotal(errorMsgTotal.toString());
            return talentPoolFallMessage;
        }
        if (positionFailCOunt < 1) {
            talentPoolFallMessage.setFlag(true);
            talentPoolFallMessage.setTitleMsg(String.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u63a8\u8350\u6210\u529f\u3002", (String)"TalentListFunService_2", (String)"tsc-tstpm-business", (Object[])new Object[0]), new Object[0]));
            return talentPoolFallMessage;
        }
        talentPoolFallMessage.setFlag(false);
        talentPoolFallMessage.setTitleMsg(String.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5728\u6b64\u804c\u4f4d\u4e0b\uff0c\u63a8\u8350\u5931\u8d25\u3002", (String)"TalentListFunService_4", (String)"tsc-tstpm-business", (Object[])new Object[0]), new Object[0]));
        return talentPoolFallMessage;
    }

    public static void saveOneReserveRecord(Long candidateId, Long talentPoolId) {
        if (0L == candidateId || 0L == talentPoolId) {
            return;
        }
        DynamicObject[] candidateDtArrays = TalentPoolFunHelper.queryCandidateDtArrays((List<Long>)ImmutableList.of((Object)candidateId));
        if (0 == candidateDtArrays.length) {
            return;
        }
        DynamicObject[] talentPoolDtArrays = TalentPoolFunHelper.queryTalentPoolDtArrays((List<Long>)ImmutableList.of((Object)talentPoolId));
        if (0 == talentPoolDtArrays.length) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        DynamicObject reserveRecordDt = serviceHelper.generateEmptyDynamicObject();
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        reserveRecordDt.set("id", (Object)ORM.create().genLongId(serviceHelper.getEntityName()));
        reserveRecordDt.set("creator", (Object)TSCRequestContext.getUserId());
        reserveRecordDt.set("createtime", (Object)nowTime);
        reserveRecordDt.set("modifier", (Object)TSCRequestContext.getUserId());
        reserveRecordDt.set("modifytime", (Object)nowTime);
        reserveRecordDt.set("reserveper", (Object)TSCRequestContext.getUserId());
        reserveRecordDt.set("reservetime", (Object)nowTime);
        reserveRecordDt.set("talentpool", (Object)talentPoolDtArrays[0]);
        reserveRecordDt.set("stdrsm", (Object)candidateDtArrays[0]);
        OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tstpm_reservere", (DynamicObject[])new DynamicObject[]{reserveRecordDt}, (OperateOption)OperateOption.create());
        ArrayList<Long> candidateIds = new ArrayList<Long>(1);
        candidateIds.add(candidateId);
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        StandardResumeDataHelper.updateModifyTime(candidateIds);
        TalentPoolOperateRecordService.getInstance().reserveOpRecord(new DynamicObject[]{reserveRecordDt}, addOperationResult);
    }

    public static Set<Long> queryNotRepeated(DynamicObject[] reserveRecordDtArrays) {
        HashSet<Long> candidateIds = new HashSet<Long>(reserveRecordDtArrays.length);
        for (DynamicObject reserveRecordDt : reserveRecordDtArrays) {
            if (null == reserveRecordDt.getDynamicObject("stdrsm")) continue;
            candidateIds.add(reserveRecordDt.getDynamicObject("stdrsm").getLong("id"));
        }
        return candidateIds;
    }

    public static List<Long> getReserveByCandidateId(List<Long> candidateIds) {
        DynamicObject[] reserveArrays = TalentListDaoHelper.getInstance().getReserveByCandidateId(candidateIds);
        if (reserveArrays != null) {
            ArrayList<Long> talentPoolIds = new ArrayList<Long>(reserveArrays.length);
            for (DynamicObject reserve : reserveArrays) {
                talentPoolIds.add(reserve.getLong("talentpool.id"));
            }
            return talentPoolIds;
        }
        return null;
    }

    public static void splicingPromptInfo(List<Long> candidateIds, List<TalentPoolMessageEntity> messageEntityList) {
        DynamicObject[] dynamicObjects = TalentListDaoHelper.getInstance().getCandidateDts(candidateIds);
        List<Long> seeCandidateIds = CheckPermissionHelper.getInstance().getCurTalentAuth(NOTBTNKEY, candidateIds, "tstpm_stdrsm");
        for (DynamicObject dynObj : dynamicObjects) {
            TalentPoolMessageEntity messageEntity = new TalentPoolMessageEntity();
            if (seeCandidateIds.contains(dynObj.getLong("id"))) {
                messageEntity.setCommonName(dynObj.getString("fullname"));
                messageEntity.setCommonNumber(dynObj.getString("number"));
            } else {
                messageEntity.setCommonName(TalentPoolDeseUtil.replacePartName((String)dynObj.getString("fullname")));
                messageEntity.setCommonNumber(TalentPoolDeseUtil.replaceFixedName());
            }
            messageEntity.setCommonId(dynObj.getLong("id"));
            messageEntityList.add(messageEntity);
        }
    }

    public static boolean setEjectPromptInfo(List<Long> candidateIds, IFormView view, TalentPoolFallMessage talentPoolFallMessage, List<Long> listWithoutDuplicates, CloseCallBack closeCallBack) {
        int selectPerTotal = candidateIds.size();
        if (selectPerTotal > listWithoutDuplicates.size()) {
            String titleMsg = talentPoolFallMessage.getTitleMsg();
            if (selectPerTotal == 1 && listWithoutDuplicates.size() == 0) {
                view.showErrorNotification(titleMsg);
                return false;
            }
            if (selectPerTotal != 1 && listWithoutDuplicates.size() == 0) {
                FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, (Object)talentPoolFallMessage.getErrorMsgTotal(), (boolean)false);
                view.showForm(formShowParameter);
                return false;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tstpm_operationresult");
            formShowParameter.setShowTitle(false);
            formShowParameter.setCustomParam("title", (Object)titleMsg);
            formShowParameter.setCustomParam("errorMsg", (Object)talentPoolFallMessage.getErrorMsgTotal());
            formShowParameter.setCustomParam("messageBoxOptions", (Object)MessageBoxOptions.OKCancel);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(closeCallBack);
            view.showForm(formShowParameter);
            return false;
        }
        return true;
    }

    public static List<Long> stringToLongList(String str) {
        return Arrays.asList(str.split(",")).parallelStream().map(av -> Long.parseLong(av.trim())).collect(Collectors.toList());
    }

    public static DynamicObject[] getPositionDts(List<Map<String, Object>> searchFieldsList) {
        DynamicObject[] positionDts = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tspr", (String)"positionServiceApi", (String)"getPositionDts", (Object[])new Object[]{searchFieldsList});
        return positionDts;
    }

    public static void showPageNotification(IFormView view, boolean saveFlag, String operationKey) {
        if (saveFlag) {
            if (HRStringUtils.equals((String)operationKey, (String)"savetalent")) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u50a8\u5907\u6210\u529f\u3002", (String)"TALENTLIST_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            } else if (HRStringUtils.equals((String)operationKey, (String)"removetalent")) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u79fb\u9664\u6210\u529f\u3002", (String)"TALENTLIST_4", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)operationKey, (String)"savetalent")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u50a8\u5907\u5728\u4eba\u624d\u5e93\u4e0b\uff0c\u50a8\u5907\u5931\u8d25\u3002", (String)"TALENTLIST_1", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)operationKey, (String)"removetalent")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u672a\u50a8\u5907\u5230\u8be5\u4eba\u624d\u5e93\uff0c\u79fb\u9664\u5931\u8d25\u3002", (String)"TALENTLIST_5", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean isStdRsmBlackList(Long stdRsmId) {
        Object service = RsmPrototypeFactory.getResumeStatusService(ModelType.MAIN_RSM_BLACK_LIST);
        service.setEntryNumber("tstpm_stdrsm");
        return service.validateStatusChange(stdRsmId);
    }

    public static void removeNotEmptyReserveRecord(List<Long> candidateIds) {
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "=", (Object)1010L);
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_reservere");
        DynamicObject[] reserveRecordDtArrays = serviceHelper.query("id, talentpool, stdrsm", new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
        ArrayList<Long> reserveRecordIds = new ArrayList<Long>(reserveRecordDtArrays.length);
        for (DynamicObject reserveRecordDtDt : reserveRecordDtArrays) {
            reserveRecordIds.add(reserveRecordDtDt.getLong("id"));
        }
        serviceHelper.delete(reserveRecordIds.toArray());
    }
}

