/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.common.enums.SecConfPageEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.PageUtils;
import kd.tsc.tsrbs.common.utils.TscTreeUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.common.utils.TalentPoolDeseUtil;
import kd.tsc.tstpm.common.utils.TalentPoolTreeUtils;

public class TalentListServiceHelper {
    private static TalentListServiceHelper talentListServiceHelper = new TalentListServiceHelper();

    private TalentListServiceHelper() {
    }

    public static TalentListServiceHelper getInstance() {
        return talentListServiceHelper;
    }

    public List<TreeNode> getChildrenList(DynamicObject[] objects, long parentId) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)objects.length);
        for (DynamicObject dy : objects) {
            if (dy.getLong("parent") != parentId) continue;
            long id = dy.getLong("id");
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)String.valueOf(parentId));
            List<TreeNode> children = this.getChildrenList(objects, id);
            if (!children.isEmpty()) {
                treeNode.setChildren(children);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void formShowCandidate(Long candidateId, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tstpm_candidate_detail");
        showParameter.setCustomParam("id", (Object)candidateId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(PageUtils.getPageId((String)candidateId.toString(), (String)view.getFormShowParameter().getAppId(), (String)"tstpm_candidate_detail", (String)view.getFormShowParameter().getRootPageId()));
        view.showForm(showParameter);
    }

    public void formShowCandidate(Long candidateId, IFormView view, CloseCallBack closeCallBackSend) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tstpm_candidate_detail");
        showParameter.setCustomParam("id", (Object)candidateId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(PageUtils.getPageId((String)candidateId.toString(), (String)view.getFormShowParameter().getAppId(), (String)"tstpm_candidate_detail", (String)view.getFormShowParameter().getRootPageId()));
        showParameter.setCloseCallBack(closeCallBackSend);
        view.showForm(showParameter);
    }

    public DynamicObject[] judgeSecurityAndDese(DynamicObject[] objects) {
        DynamicObject secrecyDynObj = SecuserHelper.queryUserSecurityLevel((Long)TSCRequestContext.getUserId(), (Long)SecConfPageEnum.getPkIdByName((String)"tstpm_talentpoolmgt"));
        boolean flag = TalentPoolMgtPermHelper.isSuperUser();
        ArrayList<DynamicObject> talentDynObj = new ArrayList<DynamicObject>(objects.length);
        if (secrecyDynObj != null && !flag) {
            int objSize = objects.length;
            for (int i = 0; i < objSize; ++i) {
                if (objects[i].get("seclevel.index") == null || objects[i].getInt("seclevel.index") == 0) {
                    talentDynObj.add(objects[i]);
                    continue;
                }
                if (secrecyDynObj.getInt("index") > objects[i].getInt("seclevel.index")) {
                    String desName = TalentPoolDeseUtil.replaceFixedName();
                    objects[i].set("name", (Object)desName);
                    continue;
                }
                talentDynObj.add(objects[i]);
            }
        } else {
            for (DynamicObject dynObj : objects) {
                talentDynObj.add(dynObj);
            }
        }
        DynamicObject[] talentPool = talentDynObj.toArray(new DynamicObject[talentDynObj.size()]);
        return talentPool;
    }

    public DynamicObject[] getReserveReListInfo(Long stdId) {
        QFilter talentPoolFilter = new QFilter("talentpool.id", "!=", (Object)Long.parseLong("1010"));
        List<Long> idList = StandardResumeDataHelper.getMergeStdIds(Collections.singletonList(stdId));
        idList.add(stdId);
        QFilter mainResFilter = new QFilter("stdrsm", "in", idList);
        mainResFilter.and(talentPoolFilter);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_reservere");
        String selectFields = "id,reservetime,talentpool,talentpool.name,talentpool.seclevel.number,reserveper,stdrsm.id";
        String orderBys = "reservetime desc";
        DynamicObject[] resDynObj = hrBaseServiceHelper.queryOriginalArray(selectFields, new QFilter[]{mainResFilter}, orderBys);
        this.judgeReserveReTalentDese(resDynObj);
        return resDynObj;
    }

    public void judgeReserveReTalentDese(DynamicObject[] objects) {
        DynamicObject secrecyDynObj = SecuserHelper.queryUserSecurityLevel((Long)TSCRequestContext.getUserId(), (Long)SecConfPageEnum.getPkIdByName((String)"tstpm_talentpoolmgt"));
        boolean flag = TalentPoolMgtPermHelper.isSuperUser();
        if (secrecyDynObj != null && !flag) {
            int objSize = objects.length;
            Map<String, Integer> secMap = this.getSecurityLevelMap();
            for (int i = 0; i < objSize; ++i) {
                if (objects[i].get("talentpool.seclevel.number") == null || secMap.get(objects[i].get("talentpool.seclevel.number")) == 0 || secrecyDynObj.getInt("index") <= secMap.get(objects[i].get("talentpool.seclevel.number"))) continue;
                String desName = TalentPoolDeseUtil.replaceFixedName();
                objects[i].set("talentpool.name", (Object)desName);
            }
        }
    }

    public Map<String, Integer> getSecurityLevelMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_securitylevel");
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap<String, Integer> serMap = new HashMap<String, Integer>(dynamicObjects.length);
        for (DynamicObject dynObj : dynamicObjects) {
            serMap.put(dynObj.getString("number"), dynObj.getInt("index"));
        }
        return serMap;
    }

    public void setPositionNumData(Map<Long, Map<String, Object>> updateMaps, List<Long> list) {
        list.addAll(StandardResumeDataHelper.getMergeStdIds(list));
        DynamicObjectCollection collections = TalentListDaoHelper.getInstance().getStdAppFile(list);
        int collSize = list.size();
        int collectSize = collections.size();
        for (int i = 0; i < collSize; ++i) {
            int positionNum = 0;
            for (int j = 0; j < collectSize; ++j) {
                if (!Objects.equals(list.get(i), ((DynamicObject)collections.get(j)).get("stdrsm"))) continue;
                ++positionNum;
            }
            if (positionNum == 0) continue;
            HashMap<String, Integer> positionMap = new HashMap<String, Integer>(1);
            positionMap.put("positionnum", positionNum);
            updateMaps.put(list.get(i), positionMap);
        }
    }

    public void setTalentPoolNumData(Map<Long, Map<String, Object>> updateMaps, List<Long> list) {
        try (DataSet reserveData = TalentListDaoHelper.getInstance().getStdReserveDataSet(list);){
            Map<Long, Set<Long>> result = this.getTalentPoolList(reserveData);
            int collSize = list.size();
            for (int i = 0; i < collSize; ++i) {
                Map<Object, Object> talPoolNumMap = updateMaps.get(list.get(i)) != null ? updateMaps.get(list.get(i)) : new HashMap(1);
                if (result.get(list.get(i)) != null) {
                    talPoolNumMap.put("talentpoolnum", result.get(list.get(i)).size());
                    updateMaps.put(list.get(i), talPoolNumMap);
                    continue;
                }
                talPoolNumMap.put("talentpoolnum", 0);
                updateMaps.put(list.get(i), talPoolNumMap);
            }
        }
    }

    private Map<Long, Set<Long>> getTalentPoolList(DataSet reserveData) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        while (reserveData.hasNext()) {
            Row row = reserveData.next();
            Long stdId = row.getLong("id");
            Long toolPoolId = row.getLong("talentpool");
            Set toolPools = (Set)result.get(stdId);
            if (null == toolPools) {
                toolPools = Sets.newHashSetWithExpectedSize((int)16);
            }
            if (toolPoolId != null) {
                toolPools.add(toolPoolId);
            }
            result.put(stdId, toolPools);
        }
        reserveData.close();
        return result;
    }

    public void setRecStatus(Map<Long, Map<String, Object>> updateMaps, List<Long> list) {
        DynamicObjectCollection collections = TalentListDaoHelper.getInstance().getStdSortAppFile(list);
        list.stream().forEach(collect -> {
            HashMap<String, String> recruitMap;
            String recruitStg = null;
            String recruitSta = null;
            for (DynamicObject dynObj : collections) {
                if (dynObj.get("stdrsm") == null || !Objects.equals(collect, dynObj.get("stdrsm"))) continue;
                if (dynObj.get("recrustg.id") != null) {
                    recruitStg = dynObj.get("recrustg.id").toString();
                }
                if (dynObj.get("recrustat.id") == null) break;
                recruitSta = dynObj.get("recrustat.id").toString();
                break;
            }
            if (null == (recruitMap = (HashMap<String, String>)updateMaps.get(collect))) {
                recruitMap = new HashMap<String, String>(1);
            }
            recruitMap.put("recrustg", recruitStg);
            recruitMap.put("recrustat", recruitSta);
            updateMaps.put((Long)collect, (Map<String, Object>)recruitMap);
        });
    }

    public void setRecChannels(Map<Long, Map<String, Object>> updateMaps, List<Long> list) {
        DynamicObject[] resumeDynObj = TalentListDaoHelper.getInstance().getStdRsm(list);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynObj : resumeDynObj) {
            if (dynObj.get("stdrsm") == null || dynObj.get("delivery.recruchnlnm.name") == null) continue;
            result.put(dynObj.getLong("stdrsm"), dynObj.get("delivery.recruchnlnm.name").toString());
        }
        int collSize = list.size();
        for (int i = 0; i < collSize; ++i) {
            if (result.get(list.get(i)) == null) continue;
            Map<String, Object> recruitMap = updateMaps.get(list.get(i));
            if (null == recruitMap) {
                recruitMap = new HashMap<String, Object>(1);
            }
            recruitMap.put("recruchnlnm", result.get(list.get(i)));
            updateMaps.put(list.get(i), recruitMap);
        }
    }

    public TreeNode createTalentTree() {
        TreeNode root = TscTreeUtils.unRenderRoot();
        TreeNode renderRoot = this.createTalentTree(root);
        TreeNode attentionRoot = TscTreeUtils.attentionRoot();
        root.addChild(renderRoot);
        root.addChild(attentionRoot);
        if (CheckPermissionHelper.getInstance().checkBlackListPermission("47150e89000000ac")) {
            TreeNode blackListRoot = TalentPoolTreeUtils.blackListRoot();
            root.addChild(blackListRoot);
        }
        return root;
    }

    public TreeNode createTalentTree(TreeNode rootNode) {
        DynamicObject[] objects = CheckPermissionHelper.getInstance().selectComPerTalentPool("tstpm_stdrsm", "47150e89000000ac");
        boolean flag = TalentPoolMgtPermHelper.isSuperUser();
        if (!flag) {
            this.judgeSecurityAndDese(objects);
        }
        TreeNode renderRoot = TscTreeUtils.renderRoot();
        int objSize = objects.length;
        for (int i = 0; i < objSize; ++i) {
            DynamicObject dy = objects[i];
            if (dy.getLong("parent") != Long.parseLong(rootNode.getId())) continue;
            long id = dy.getLong("id");
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)rootNode.getId());
            List<TreeNode> children = this.getChildrenList(objects, id);
            if (!children.isEmpty()) {
                treeNode.setChildren(children);
            }
            if (id == 1040L) {
                DynamicObject[] shareTalentPool = CheckPermissionHelper.getInstance().getShareTalentPool();
                ArrayList shareTreeNodes = Lists.newArrayListWithCapacity((int)objects.length);
                for (DynamicObject dynObj : shareTalentPool) {
                    TreeNode shareTreeNode = TscTreeUtils.getCreateTreeNode((DynamicObject)dynObj, (String)String.valueOf(id));
                    shareTreeNodes.add(shareTreeNode);
                }
                if (shareTreeNodes.size() != 0) {
                    treeNode.setChildren((List)shareTreeNodes);
                }
            }
            renderRoot.addChild(treeNode);
        }
        return renderRoot;
    }
}

