/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentSharHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtF7Helper
extends TalentPoolMgtHelper {
    public static List<Long> getAllTalentPoolList(Pair<Boolean, List<Long>> permOrgResult) {
        DynamicObject[] sharPoolObj;
        DynamicObject[] priObj;
        DynamicObject[] pubObj;
        ArrayList<Long> allTalentPoolList = new ArrayList<Long>(100);
        QFilter orgQFilter = TalentPoolMgtF7Helper.getDefaultPubFilter((List)permOrgResult.getRight());
        for (DynamicObject dynamicObject : pubObj = TalentPoolMgtHelper.queryTalentPool(orgQFilter)) {
            allTalentPoolList.add(dynamicObject.getLong("id"));
        }
        QFilter priQFilter = TalentPoolMgtQFilterHelper.privateTalentPoolQFilter();
        for (DynamicObject dynamicObject : priObj = TalentPoolMgtHelper.queryTalentPool(priQFilter)) {
            allTalentPoolList.add(dynamicObject.getLong("id"));
        }
        QFilter sharQFilter = TalentPoolMgtQFilterHelper.sharTalentPoolQFilter();
        for (DynamicObject dynamicObject : sharPoolObj = TalentSharHelper.querySharPool(null, sharQFilter, null)) {
            allTalentPoolList.add(dynamicObject.getLong("talentpool.id"));
        }
        return allTalentPoolList;
    }

    public static QFilter getDefaultPubFilter(List<Long> orgList) {
        QFilter qFilter = TalentPoolMgtQFilterHelper.poolTypeQFilter("A");
        qFilter.and(TalentPoolMgtQFilterHelper.getQFilter(orgList, "org"));
        if (!TalentPoolMgtPermHelper.isSuperUser()) {
            TalentPoolMgtQFilterHelper.isAndSecurityQFilter(qFilter);
        }
        return qFilter;
    }
}

