/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.common.enums.SecConfPageEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.HRStructureTreeOrgHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtPermHelper {
    private TalentPoolMgtPermHelper() {
    }

    public static Pair<Boolean, List<Long>> getAllPermOrg() {
        return TalentPoolMgtPermHelper.getAllPermOrg("47150e89000000ac");
    }

    public static Pair<Boolean, List<Long>> getAllPermOrg(String permissionItem) {
        return TalentPoolMgtPermHelper.getAllPermOrg("tstpm_talentpoolmgt_pub", permissionItem);
    }

    public static Pair<Boolean, List<Long>> getAllPermOrg(String pageNumber, String permissionItem) {
        return TalentPoolMgtPermHelper.getAllPermOrg("tstpm", pageNumber, permissionItem);
    }

    public static Pair<Boolean, List<Long>> getAllPermOrg(String appNumber, String pageNumber, String permissionItem) {
        return HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserPermOrg((String)appNumber, (String)pageNumber, (String)permissionItem);
    }

    public static Pair<Boolean, List<Long>> getUserOrg() {
        return TalentPoolMgtPermHelper.getUserOrg(TSCRequestContext.getUserId());
    }

    public static Pair<Boolean, List<Long>> getUserOrg(Long userId) {
        return HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserAllOrg((Long)userId);
    }

    public static boolean isPermTalentPools(List<DynamicObject> talentPools, String permissionItem) {
        Pair<Boolean, List<Long>> pair = TalentPoolMgtPermHelper.getAllPermOrg(permissionItem);
        return (Boolean)pair.getLeft() != false || talentPools.stream().anyMatch(org -> ((List)pair.getRight()).contains(org.getLong("id")));
    }

    public static boolean querySecurityConf() {
        return SecConfHelper.querySecurityConf((Long)SecConfPageEnum.getPkIdByName((String)"tstpm_talentpoolmgt"));
    }

    public static DynamicObject queryUserSecurityLevel() {
        return SecuserHelper.queryUserSecurityLevel((Long)TSCRequestContext.getUserId(), (Long)1020L);
    }

    public static boolean isSuperUser() {
        return PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId());
    }

    public static boolean checkPerm(String permItem) {
        return TalentPoolMgtPermHelper.isSuperUser() || ((List)TalentPoolMgtPermHelper.getAllPermOrg(permItem).getRight()).size() != 0;
    }

    public static List<Long> queryHRDefaultStructureTree() {
        return HRStructureTreeOrgHelper.queryHRStructureOrgByAppID();
    }
}

