/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tstpm.common.talentpool.UserDto;

public class TalentPoolMgtPriHelper
extends TalentPoolMgtHelper {
    public static TalentPoolMgtPriHelper getInstance() {
        return new TalentPoolMgtPriHelper();
    }

    private TalentPoolMgtPriHelper() {
    }

    public OperateOption createOperateOption(IFormView view) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("sharers", view.getPageCache().get("sharers"));
        operateOption.setVariableValue("deleteSharers", view.getPageCache().get("deleteSharers"));
        return operateOption;
    }

    public void showSharerWindowForm(IFormView view, IFormPlugin plugin) {
        ListShowParameter listShowParameter = new ListShowParameter();
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setBillFormId("bos_user");
        listShowParameter.setFormId("bos_usertreelistf7");
        listShowParameter.setShowUsed(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setCloseCallBack(new CloseCallBack(plugin, "sharer"));
        List sharers = TalentPoolMgtPriHelper.getUsers(view, UserDto.class, "sharers").stream().map(UserDto::getId).collect(Collectors.toList());
        sharers.add(TSCRequestContext.getUserId());
        QFilter qFilter = new QFilter("id", "not in", sharers);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void beforeF7SelectParent(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setShowTitle(false);
        QFilter defaultFilter = TalentPoolMgtPriHelper.getDefaultFilter(view);
        defaultFilter.or(TalentPoolMgtQFilterHelper.getQFilterByID(1030L));
        formShowParameter.getListFilterParameter().setFilter(defaultFilter);
        formShowParameter.setCaption(TalentPoolMgtEnum.TPM_7.getValue());
    }

    public static QFilter getDefaultFilter(IFormView view) {
        QFilter qFilter = TalentPoolMgtQFilterHelper.privateTalentPoolQFilter();
        String pageParam = TalentPoolMgtHelper.getInstance().getPageParam(view);
        qFilter.and(TalentPoolMgtQFilterHelper.getRecrutypQFilter(pageParam, false));
        return qFilter;
    }
}

