/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtPubHelper
extends TalentPoolMgtHelper {
    private Pair<Boolean, List<Long>> permOrgResult = null;

    public static TalentPoolMgtPubHelper getInstance() {
        return new TalentPoolMgtPubHelper();
    }

    private TalentPoolMgtPubHelper() {
    }

    public void beforeF7SelectOrg(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (!TalentPoolMgtPermHelper.isSuperUser()) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Pair<Boolean, List<Long>> newPermOrgResult = TalentPoolMgtPermHelper.getAllPermOrg("1VTQC/MT+XX11");
            QFilter qFilter = TalentPoolMgtQFilterHelper.getQFilter((List)newPermOrgResult.getRight(), "id");
            formShowParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(qFilter));
            formShowParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        }
    }

    public void beforeF7SelectParent(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setShowTitle(false);
        formShowParameter.getListFilterParameter().setFilter(this.getDefaultFilter(view));
        formShowParameter.setCaption(TalentPoolMgtEnum.TPM_7.getValue());
    }

    public QFilter getDefaultFilter(IFormView view) {
        QFilter qFilter = TalentPoolMgtQFilterHelper.poolTypeQFilter("A");
        this.permOrgResult = this.checkHasPermOrgResult(view);
        qFilter.and(TalentPoolMgtQFilterHelper.getQFilter((List)this.permOrgResult.getRight(), "org"));
        if (!((Boolean)this.permOrgResult.getLeft()).booleanValue()) {
            TalentPoolMgtQFilterHelper.isAndSecurityQFilter(qFilter);
        }
        String pageParam = TalentPoolMgtHelper.getInstance().getPageParam(view);
        qFilter.and(TalentPoolMgtQFilterHelper.getRecrutypQFilter(pageParam, false));
        return qFilter;
    }

    public static boolean isLookUp(IFormView view) {
        FormShowParameter form = view.getFormShowParameter();
        return form instanceof ListShowParameter && ((ListShowParameter)form).isLookUp();
    }

    public static String getPermissionItem(IFormView view) {
        return TalentPoolMgtPubHelper.isLookUp(view) ? "1VTQC/MT+XX11" : "47150e89000000ac";
    }

    public Pair<Boolean, List<Long>> checkHasPermOrgResult(IFormView view) {
        if (this.permOrgResult == null) {
            String permissionItem = TalentPoolMgtPubHelper.getPermissionItem(view);
            this.permOrgResult = this.getPermOrgResult(view.getPageCache(), permissionItem);
        }
        return this.permOrgResult;
    }

    public static ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        return col;
    }

    public void setOrgValue(IDataModel dataModel, Pair<Boolean, List<Long>> addPermItem, long orgID) {
        dataModel.setValue("org", (Object)(this.setValue(addPermItem, orgID) ? Long.valueOf(orgID) : null));
    }

    public void setParentValue(IDataModel dataModel, Pair<Boolean, List<Long>> addPermItem) {
        if (!((Boolean)addPermItem.getLeft()).booleanValue()) {
            DynamicObject dataEntity = dataModel.getDataEntity();
            long orgID = dataModel.getDataEntity().getLong("parent.org.id");
            if (!this.setValue(addPermItem, orgID)) {
                dataModel.setValue("parent", null);
                return;
            }
            if (TalentPoolMgtPermHelper.querySecurityConf()) {
                DynamicObject userSecurityObj = TalentPoolMgtPermHelper.queryUserSecurityLevel();
                long parentSecLevelId = dataEntity.getLong("parent.seclevel.id");
                DynamicObject securityLevel = SecuserHelper.getSecurityLevel((Long)parentSecLevelId);
                if (securityLevel.getLong("index") < userSecurityObj.getLong("index")) {
                    dataModel.setValue("parent", null);
                }
            }
        }
    }

    public boolean setValue(Pair<Boolean, List<Long>> addPermItem, long orgID) {
        return (Boolean)addPermItem.getLeft() != false || ((List)addPermItem.getRight()).contains(orgID);
    }
}

