/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tstpm.common.talentpool.UserDto;

public class TalentSharHelper {
    public static final HRBaseServiceHelper sharerServiceHelper = new HRBaseServiceHelper("tstpm_sharer");
    private static final TalentSharHelper TALENT_SHAR_HELPER = new TalentSharHelper();
    private static final Log LOGGER = LogFactory.getLog(TalentSharHelper.class);
    public static final String MORE_USER_HEADER = "more_user_header";

    public static TalentSharHelper getInstance() {
        return TALENT_SHAR_HELPER;
    }

    public static DynamicObject[] querySharPool(String queryFields, QFilter filters, String orderBys) {
        filters = filters == null ? TalentPoolMgtQFilterHelper.enableFilter() : filters;
        queryFields = queryFields == null ? TalentSharHelper.selectProperties() : queryFields;
        return sharerServiceHelper.query(queryFields, filters.toArray(), orderBys);
    }

    public static String selectProperties() {
        return String.join((CharSequence)",", "id", "shartime", "user", "talentpool");
    }

    public void saveSharer(EndOperationTransactionArgs eot, String sharers, String deleteSharers) {
        List deleteSharerList;
        DynamicObject[] dataEntities = eot.getDataEntities();
        long talentPoolId = dataEntities[0].getLong("id");
        if (HRStringUtils.isNotEmpty((String)deleteSharers) && (deleteSharerList = SerializationUtils.fromJsonStringToList((String)deleteSharers, Long.class)).size() > 0) {
            QFilter deleteFilter = new QFilter("user", "in", (Object)deleteSharerList);
            sharerServiceHelper.deleteByFilter(deleteFilter.toArray());
        }
        if (HRStringUtils.isNotEmpty((String)sharers)) {
            QFilter querySharFilter = new QFilter("talentpool", "=", (Object)talentPoolId);
            DynamicObject[] query = sharerServiceHelper.query(TalentSharHelper.selectProperties(), querySharFilter.toArray());
            ArrayList<Long> querySharers = new ArrayList<Long>(query.length);
            for (DynamicObject dynamicObject : query) {
                querySharers.add(dynamicObject.getLong("user.id"));
            }
            List sharerList = SerializationUtils.fromJsonStringToList((String)sharers, UserDto.class);
            List newSharer = sharerList.stream().filter(user -> !querySharers.contains(user.getId())).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = new DynamicObject[newSharer.size()];
            long[] longIDs = ID.genLongIds((int)newSharer.size());
            Date nowDate = new Date();
            for (int i = 0; i < newSharer.size(); ++i) {
                DynamicObject dynamicObject = sharerServiceHelper.generateEmptyDynamicObject();
                dynamicObject.set("id", (Object)longIDs[i]);
                dynamicObject.set("talentpool", (Object)talentPoolId);
                dynamicObject.set("user", (Object)((UserDto)newSharer.get(i)).getId());
                dynamicObject.set("shartime", (Object)nowDate);
                dynamicObjects[i] = dynamicObject;
            }
            sharerServiceHelper.save(dynamicObjects);
        }
    }

    public static DynamicObject[] selectShare(Long talentPoolID) {
        QFilter qFilterShare = new QFilter("talentpool", "=", (Object)talentPoolID);
        return sharerServiceHelper.query("user", qFilterShare.toArray(), "id");
    }

    public void deleteUser(AbstractFormPlugin afp, IFormView view, IDataModel model) {
        CardEntry cardEntry = (CardEntry)afp.getControl("entryentity");
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        IFormView parentView = view;
        List<UserDto> sharerList = TalentPoolMgtHelper.getUsers(parentView, UserDto.class, "sharers");
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
        long row = ((DynamicObject)entry.get(selectRows[0])).getLong("id");
        sharerList.removeIf(next -> next.getId().equals(row));
        model.deleteEntryRow("entryentity", selectRows[0]);
        parentView.getPageCache().put("sharers", SerializationUtils.toJsonString(sharerList));
        List<Long> deleteSharers = TalentPoolMgtHelper.getUsers(parentView, Long.class, "deleteSharers");
        deleteSharers.add(row);
        parentView.getPageCache().put("deleteSharers", SerializationUtils.toJsonString(deleteSharers));
        view.updateView();
    }

    public void setSharerMessage(List<UserDto> sharerList, IDataModel dataModel, IFormView formView) {
        int count = sharerList.size();
        if (count > 0) {
            if (formView != null) {
                formView.setVisible(Boolean.TRUE, new String[]{"labelap"});
            }
            dataModel.batchCreateNewEntryRow("entryentity", count);
            for (int i = 0; i < count; ++i) {
                dataModel.setValue("picturefield", (Object)sharerList.get(i).getPictureUrl(), i);
                dataModel.setValue("name", (Object)sharerList.get(i).getName(), i);
                dataModel.setValue("id", (Object)sharerList.get(i).getId(), i);
            }
        }
    }

    public void packageSharData(PackageDataEvent pde) {
        long id;
        DynamicObject[] shares;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)pde.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)"sharer", (String)fieldKey) && (shares = TalentSharHelper.selectShare(id = pde.getRowData().getLong("id"))).length > 0) {
            StringBuilder sharerName = new StringBuilder();
            for (DynamicObject share : shares) {
                sharerName.append(share.getString("user.name"));
                sharerName.append(";");
            }
            pde.setFormatValue((Object)sharerName);
        }
    }

    public void showMoreHeader(AbstractFormPlugin afp, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tstpm_sharer_window");
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        formShowParameter.setCaption(TalentPoolMgtEnum.TPM_26.getValue());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)afp, MORE_USER_HEADER));
        view.showForm(formShowParameter);
    }

    public void delUserByTpmID(DynamicObject[] dataEntities) {
        ArrayList<Long> tpmIDList = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            tpmIDList.add(dynamicObject.getLong("id"));
        }
        if (tpmIDList.size() > 0) {
            LOGGER.info("Delete user by talentPool :{}", tpmIDList);
            QFilter deleteFilter = new QFilter("talentpool", "in", tpmIDList);
            sharerServiceHelper.deleteByFilter(deleteFilter.toArray());
        }
    }
}

