/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;

public class TrackRecSumServiceHelper {
    private Long currentUserId = RequestContext.get().getCurrUserId();
    private static List<Long> jobStatus = Arrays.asList(1010L, 1020L, 1030L, 1050L, 1060L, 1070L);

    public List<Long> calTrackSumPer(LocalDate startDate) {
        List<Long> talentPoolIds = CheckPermissionHelper.getInstance().getCurTalentAuthStdInfo();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_tracerecord");
        QFilter stdIdFilter = new QFilter("trackper", "=", (Object)this.currentUserId);
        stdIdFilter.and(new QFilter("stdrsm.datastatus", "=", (Object)ResumeHisDataStatusEnum.EFFECTING.getStatus()));
        stdIdFilter.and(new QFilter("stdrsm", "in", talentPoolIds));
        if (startDate != null) {
            stdIdFilter.and(new QFilter("tracktime", ">=", (Object)startDate));
        }
        DynamicObject[] dynObjTrace = serviceHelper.query("id,stdrsm.mid", stdIdFilter.toArray());
        ArrayList<Long> stdIds = new ArrayList<Long>(dynObjTrace.length);
        for (DynamicObject dynObj : dynObjTrace) {
            if (dynObj.getDynamicObject("stdrsm") == null && dynObj.getDynamicObject("stdrsm").get("mid") == null) continue;
            stdIds.add(dynObj.getDynamicObject("stdrsm").getLong("mid"));
        }
        return TrackRecSumServiceHelper.removeDuplicate(stdIds);
    }

    public List<Long> calJobIntention(List<Long> trackSumPer) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tstpm_tracerecord");
        QFilter stdIdFilter = new QFilter("stdrsm", "in", trackSumPer);
        stdIdFilter.and(new QFilter("stdrsm.jobstatus.id", "in", jobStatus));
        stdIdFilter.and(new QFilter("stdrsm.ismerge", "=", (Object)"0"));
        DynamicObject[] dynObjTrace = serviceHelper.query("id,stdrsm", stdIdFilter.toArray());
        ArrayList<Long> stdIds = new ArrayList<Long>(dynObjTrace.length);
        for (DynamicObject dynObj : dynObjTrace) {
            stdIds.add(dynObj.getDynamicObject("stdrsm").getLong("id"));
        }
        return TrackRecSumServiceHelper.removeDuplicate(stdIds);
    }

    public List<Long> calSucDelivery(LocalDate startDate, List<Long> jobIntentionPer) {
        HRBaseServiceHelper resumeHelper = new HRBaseServiceHelper("tstpm_srrsm");
        QFilter resFilter = new QFilter("delivery.applytime", ">=", (Object)startDate);
        DynamicObject[] resumeDynObj = resumeHelper.query("id,stdrsm", resFilter.toArray());
        ArrayList<Long> idList = new ArrayList<Long>(jobIntentionPer.size());
        block0: for (Long dynObj : jobIntentionPer) {
            for (DynamicObject resDynObj : resumeDynObj) {
                if (resDynObj.get("stdrsm") == null || !dynObj.equals(resDynObj.getLong("stdrsm"))) continue;
                idList.add(dynObj);
                continue block0;
            }
        }
        return TrackRecSumServiceHelper.removeDuplicate(idList);
    }

    public static List removeDuplicate(List list) {
        HashSet set = new HashSet(list);
        list.clear();
        list.addAll(set);
        return list;
    }
}

