/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.talentpool.service.oprecord;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;

public class TalentPoolOpRecordService {
    private static final Log LOGGER = LogFactory.getLog(TalentPoolOpRecordService.class);
    private final String TSTPM_EDIT = "tstpm_edit";
    private final String TSTPM_NEW = "tstpm_new";
    private final String TSTPM_DEL = "tstpm_del";
    private static final int MAX_THREADS = 2 * Runtime.getRuntime().availableProcessors() + 1;
    private final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)(this.getClass().getName() + "_threadPool"), (int)MAX_THREADS);

    public static TalentPoolOpRecordService getInstance() {
        return Instance.INSTANCE;
    }

    public void sendOpRecordMessage(List<OprecordMessageModel> opRecordMessageModelList) {
        this.THREAD_POOL.execute(() -> {
            try {
                OprecordMQ.sendOpRecordChangeMessage((List)opRecordMessageModelList);
            }
            catch (Exception e) {
                LOGGER.error("\u4eba\u624d\u5e93\u64cd\u4f5c\u8bb0\u5f55\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            }
        });
    }

    public OprecordMessageModel genBaseDataForMsg(Long talent, String text, String opNumber) {
        OprecordMessageModel message = new OprecordMessageModel();
        message.setBizentry("tstpm_talentpoolmgt");
        message.setBizobj(talent.longValue());
        message.setOperator(Long.valueOf(TSCRequestContext.getUserId()));
        message.setOperatorname(TSCRequestContext.getUserName());
        message.setOprtext(text);
        message.setOptime(new Date());
        message.setOpnumber(opNumber);
        return message;
    }

    public void editOPRecord(IFormView view, IDataModel dataModel) {
        IPageCache pageCache = view.getPageCache();
        if (pageCache.get("newSecLevel") != null && !HRStringUtils.equals((String)pageCache.get("newSecLevel"), (String)pageCache.get("oldSecLevel"))) {
            String text = MessageFormat.format(TalentPoolMgtEnum.TPM_32.getValue(), TSCRequestContext.getUserName(), dataModel.getValue("name"), pageCache.get("oldSecLevel"), pageCache.get("newSecLevel"));
            Long id = (Long)dataModel.getValue("id");
            this.sendOpRecordMessage(Collections.singletonList(this.genBaseDataForMsg(id, text, "tstpm_edit")));
        }
    }

    public void newOPRecord(IDataModel dataModel) {
        if (dataModel.getValue("secselect") != null) {
            String text = MessageFormat.format(TalentPoolMgtEnum.TPM_31.getValue(), TSCRequestContext.getUserName(), dataModel.getValue("name"), dataModel.getValue("secselect"));
            Long id = (Long)dataModel.getValue("id");
            this.sendOpRecordMessage(Collections.singletonList(this.genBaseDataForMsg(id, text, "tstpm_new")));
        }
    }

    public void deleteOPRecord(DynamicObject[] dataEntities) {
        ArrayList<OprecordMessageModel> opRecordMessageModelList = new ArrayList<OprecordMessageModel>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            if (!TalentPoolMgtPermHelper.querySecurityConf() || dynamicObject.getDynamicObject("seclevel") == null) continue;
            String text = MessageFormat.format(TalentPoolMgtEnum.TPM_33.getValue(), TSCRequestContext.getUserName(), dynamicObject.getString("name"));
            Long id = dynamicObject.getLong("id");
            opRecordMessageModelList.add(this.genBaseDataForMsg(id, text, "tstpm_del"));
        }
        if (opRecordMessageModelList.size() > 0) {
            this.sendOpRecordMessage(opRecordMessageModelList);
        }
    }

    private static class Instance {
        private static final TalentPoolOpRecordService INSTANCE = new TalentPoolOpRecordService();

        private Instance() {
        }
    }
}

