/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.tracerecord.service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;

public class TraceRecordHelper {
    private static HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_tracerecord");
    private static TraceRecordHelper traceRecordHelper = new TraceRecordHelper();

    private TraceRecordHelper() {
    }

    public static TraceRecordHelper getInstance() {
        return traceRecordHelper;
    }

    public static void SaveTraceRecord(Long stdRsmId) {
        DynamicObject dynamicObject = BaseHelper.createDynamicObject((String)"tstpm_tracerecord");
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        long currentUserId = RequestContext.get().getCurrUserId();
        dynamicObject.set("id", (Object)ID.genLongId());
        dynamicObject.set("stdrsm", (Object)stdRsmId);
        dynamicObject.set("tracktime", (Object)updateDate);
        dynamicObject.set("trackper", (Object)currentUserId);
        hrBaseServiceHelper.saveOne(dynamicObject);
    }

    public static List<DynamicObject> queryTraceRecord(String queryfields, QFilter filters, String orderBys) {
        queryfields = queryfields == null ? "id" : queryfields;
        ArrayList<DynamicObject> transferedList = new ArrayList<DynamicObject>();
        Arrays.stream(hrBaseServiceHelper.query(queryfields, filters.toArray(), orderBys)).forEach(arr -> transferedList.add((DynamicObject)arr));
        return transferedList;
    }

    public static int queryTraceRecordCount(QFilter filters) {
        return hrBaseServiceHelper.count("tstpm_tracerecord", filters.toArray());
    }

    public static String getSelectProperties() {
        return String.join((CharSequence)",", "tracktime", "trackper", "mid", "jobstatus", "description");
    }

    public static List<DynamicObject> queryTraceRecordByStdrsmId(Long stdrsmId) {
        return TraceRecordHelper.queryTraceRecord(TraceRecordHelper.getSelectProperties(), TraceRecordHelper.getQFilterByStdrsmId(stdrsmId, null), null);
    }

    public static QFilter getQFilterByStdrsmId(Long stdrsmId, List<Long> stdrsmIdList) {
        if (stdrsmIdList == null) {
            return new QFilter("stdrsm", "=", (Object)stdrsmId);
        }
        return new QFilter("stdrsm", "in", stdrsmIdList);
    }

    public int queryTraceRecordCount(int month, QFilter qFilter, Date nowDate) {
        QFilter newQFilter = qFilter.copy();
        Date monthDate = HRDateTimeUtils.addMonth((Date)nowDate, (int)month);
        newQFilter.and(new QFilter("createtime", ">=", (Object)monthDate));
        return TraceRecordHelper.queryTraceRecordCount(newQFilter);
    }

    public QFilter getNewQFilter(Long stdrsmId, boolean switchBtn) {
        QFilter qFilter = TraceRecordHelper.getQFilterByStdrsmId(stdrsmId, null);
        if (switchBtn) {
            List<Long> list = StandardResumeDataHelper.getMergeStdIds(Collections.singletonList(stdrsmId));
            list.add(stdrsmId);
            qFilter = new QFilter("stdrsm", "in", list);
        }
        return qFilter;
    }
}

