/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.arf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.arf.ARFRsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmEduExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmLangAblHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmPrjExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmWorkExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmWorkRelHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.service.PreRsmService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tstpm.common.constants.rsm.sr.RsmConstants;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;

public class ARFRsmCompleteEdit
extends HRDataBaseEdit {
    private static final String KEY_ADDEDUEXPFLEX = "flexpanelap";
    private static final String KEY_ADDWORKEXPFLEX = "flexpanelap1";
    private static final String KEY_ADDPRJEXPFLEX = "flexpanelap11";
    private static final String KEY_ADDWORKRELAFLEX = "addworkrrelaflexpanelap";
    private static final String KEY_ADDLANGABLFLEX = "addlangablflexpanelap";
    private static final Log logger = LogFactory.getLog(ARFRsmCompleteEdit.class);

    public void preOpenForm(PreOpenFormEventArgs ef) {
        String caption = SrRsmKDString.addRsmTitle();
        FormShowParameter showParameter = ef.getFormShowParameter();
        showParameter.setCaption(caption);
        if (showParameter.getStatusValue() == OperationStatus.ADDNEW.getValue()) {
            showParameter.setCustomParam("dataSource", (Object)"1");
        }
    }

    public void beforeBindData(EventObject eo) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        int status = showParameter.getStatusValue();
        IPageCache pageCache = this.getPageCache();
        if (status == OperationStatus.ADDNEW.getValue()) {
            pageCache.put("key_checkchange_cache", "1");
            RsmCommonHelper.showSimpleRsm((IFormView)this.getView(), (boolean)true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"panel_applyinfo"});
        } else {
            pageCache.put("key_checkchange_cache", "0");
            RsmCommonHelper.showSimpleRsm((IFormView)this.getView(), (boolean)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"panel_applyinfo"});
            if (status == OperationStatus.EDIT.getValue()) {
                this.setPerInfoDisEdit();
                this.setConInfoDisEdit();
                this.setJobIntentionDisEdit();
                this.setSelfDescDisEdit();
            } else if (status == OperationStatus.VIEW.getValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_peredit", "bar_percancel", "bar_persave", "bar_concancel", "bar_conedit", "bar_consave", "bar_selfedit", "bar_selfsave", "bar_selfcancel", KEY_ADDEDUEXPFLEX, KEY_ADDWORKEXPFLEX, KEY_ADDPRJEXPFLEX, KEY_ADDWORKRELAFLEX, KEY_ADDLANGABLFLEX, "bar_jobintentionedit", "bar_jobintentioncancel", "bar_jobintentionsave"});
            }
        }
        this.paramResume(showParameter, pageCache);
    }

    private void paramResume(FormShowParameter showParameter, IPageCache pageCache) {
        String resume = (String)showParameter.getCustomParam("resume");
        String dataSource = (String)showParameter.getCustomParam("dataSource");
        if ("1".equals(dataSource) && HRStringUtils.isNotEmpty((String)resume)) {
            AppResumeBo resumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)resume);
            resumeBo = ResumeUtilsHelper.copyResumeBo((AppResumeBo)resumeBo);
            DynamicObject rsm = resumeBo.getRsm();
            IDataModel model = this.getModel();
            DataEntityPropertyCollection depc = rsm.getDataEntityType().getProperties();
            for (IDataEntityProperty idep : depc) {
                String propName = idep.getName();
                model.setValue(propName, rsm.get(propName));
            }
            DynamicObjectCollection eduExpList = resumeBo.getEntry("tstpm_srscarfmrsmeduexp");
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srscarfmrsmeduexp", (List)eduExpList);
            DynamicObjectCollection langAblExpList = resumeBo.getEntry("tstpm_srscarfmrsmlangabl");
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srscarfmrsmlangabl", (List)langAblExpList);
            DynamicObjectCollection workExpList = resumeBo.getEntry("tstpm_srscarfmrsmworkexp");
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srscarfmrsmworkexp", (List)workExpList);
            DynamicObjectCollection prjExpList = resumeBo.getEntry("tstpm_srscarfmrsmprjexp");
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srscarfmrsmprjexp", (List)prjExpList);
        }
    }

    public void afterBindData(EventObject eo) {
        PageUtils.setFlexCollapsible((List)ImmutableList.of((Object)"panel_perinfo", (Object)"advpanel_wordexp", (Object)"advpanel_prjexp", (Object)"advpanel_interexp", (Object)"advpanel_eduexp", (Object)"advpanel_langexp", (Object)"panel_jobintention", (Object)"panel_contactinfo", (Object)"advpanel_crt", (Object)"panel_selfdesc"), (boolean)false, (IFormView)this.getView());
        ARFRsmHelper.reloadExpList((IFormView)this.getView());
        IDataModel model = this.getModel();
        int workMonths = model.getDataEntity().getInt("workingyears");
        RsmCommonHelper.setShowWorkYears((int)workMonths, (IFormView)this.getView());
        RsmCommonHelper.setShowAge((IFormView)this.getView());
        DynamicObject rsmEntity = this.getModel().getDataEntity();
        ResumeUtilsHelper.serialize((IPageCache)this.getPageCache(), (String)RsmCommonHelper.getCacheEntityKey((DynamicObject)rsmEntity), (DynamicObject)rsmEntity);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentDatas = attachmentPanel.getAttachmentData();
        logger.info("ARFRsmCompleteEdit.attachmentpanelap\uff1a{}", (Object)attachmentPanel);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
        if (attachmentDatas != null && attachmentDatas.size() != 0) {
            for (Map attachmentMap : attachmentDatas) {
                attachmentMap.put("visible", "110");
            }
            ClientViewProxy cvp = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
            cvp.setFieldProperty("attachmentpanelap", "v", (Object)attachmentDatas);
        }
    }

    public void propertyChanged(PropertyChangedArgs ec) {
        String propName = ec.getProperty().getName();
        if ("completemodeck".equals(propName)) {
            if (Boolean.TRUE.equals(ec.getChangeSet()[0].getNewValue())) {
                RsmCommonHelper.showSimpleRsm((IFormView)this.getView(), (boolean)false);
                RsmHelper.reloadExpList((IFormView)this.getView());
            } else {
                RsmCommonHelper.showSimpleRsm((IFormView)this.getView(), (boolean)true);
            }
        }
    }

    public void registerListener(EventObject eo) {
        this.addClickListeners(new String[]{"btn_addeduexp", "btn_addworkexp", "btn_addprjexp", "position", "btn_addworkrelaexp", "btn_addlangexp"});
        this.addItemClickListeners(new String[]{"bar_per", "bar_con", "bar_jobintention", "bar_self"});
    }

    private void handleItemClick(String key) {
        switch (key) {
            case "bar_conedit": {
                this.setConInfoEdit();
                break;
            }
            case "bar_concancel": {
                this.checkInfoChange("panel_contact");
                break;
            }
            case "bar_consave": {
                this.saveConInfo();
                break;
            }
            case "bar_jobintentionedit": {
                this.setJobIntentionEdit();
                break;
            }
            case "bar_jobintentioncancel": {
                this.checkInfoChange("panel_jobintention");
                break;
            }
            case "bar_jobintentionsave": {
                this.saveJobIntentionInfo();
                break;
            }
            case "bar_selfedit": {
                this.setSelfDescEdit();
                break;
            }
            case "bar_selfcancel": {
                this.checkInfoChange("panel_selfdesc");
                break;
            }
            case "bar_selfsave": {
                this.saveSelfDesc();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_addeduexp": {
                this.showBaseForm("tstpm_srscarfmrsmeduexp", null, SrRsmKDString.eduExp());
                break;
            }
            case "btn_addlangexp": {
                this.showBaseForm("tstpm_srscarfmrsmlangabl", null, SrRsmKDString.langAblExp());
                break;
            }
            case "btn_addworkexp": {
                this.showBaseForm("tstpm_srscarfmrsmworkexp", null, SrRsmKDString.workExp());
                break;
            }
            case "btn_addprjexp": {
                this.showBaseForm("tstpm_srscarfmrsmprjexp", null, SrRsmKDString.prjExp());
                break;
            }
            case "position": {
                RsmService.openPositionF7Click((IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "tssrm_position_add"));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "tstpm_srrsmworkrela": {
                this.handleRCloseCallBackRsmWorkRelation(closedCallBackEvent, dataSource);
                break;
            }
            case "tstpm_srrsmeduexp": {
                this.handleRCloseCallBackRsmEduExp(closedCallBackEvent, dataSource);
                break;
            }
            case "tstpm_srrsmlangabl": {
                this.handleRCloseCallBackRsmLangAbl(closedCallBackEvent, dataSource);
                break;
            }
            case "tstpm_srrsmworkexp": {
                this.handleCloseCallBackRsmWordExp(closedCallBackEvent, dataSource);
                break;
            }
            case "tstpm_srrsmprjexp": {
                this.handleCLoseCallBackRsmPrjExp(closedCallBackEvent, dataSource);
                break;
            }
            case "tssrm_position_add": {
                RsmService.selectedPositionClosedCallBack((IFormView)this.getView(), (Object)closedCallBackEvent.getReturnData());
                break;
            }
        }
        if (!"1".equals(dataSource)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            RsmCommonHelper.outTransaction((long)dataEntity.getLong("id"), (Boolean)Boolean.TRUE);
            this.refreshAppFile();
        }
    }

    private void refreshAppFile() {
        IFormView view = this.getView().getParentView();
        boolean tssrmAppfileView = view.getEntityId().startsWith("tssrm_appfile_view");
        if (tssrmAppfileView) {
            DynamicObject rsmDy = RsmHelper.findOne((long)this.getModel().getDataEntity().getLong("id"));
            RsmService.refreshAppFileHeader((DynamicObject)rsmDy, (IFormView)view, (IFormView)this.getView());
        }
    }

    private void handleRCloseCallBackRsmWorkRelation(ClosedCallBackEvent closedCallBackEvent, String dataSource) {
        Object returnData;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long rsmId = dataEntity.getLong("id");
        if (rsmId != 0L && !"1".equals(dataSource) && (returnData = closedCallBackEvent.getReturnData()) instanceof DynamicObject) {
            List sortResults = RsmCommonHelper.getAllExpSortList((Long)rsmId, Collections.singletonList((DynamicObject)returnData), (String)"tstpm_srrsmworkrela");
            RsmWorkRelHelper.saveRsmWorkRelation((List)sortResults, (Long)rsmId, (IPageCache)this.getPageCache());
        }
        RsmHelper.reloadRsmExpView((String)"tstpm_srrsmworkrela", (String)"flexpanelcontent_workrela", (Long)rsmId, (IFormView)this.getView());
    }

    private void handleRCloseCallBackRsmEduExp(ClosedCallBackEvent closedCallBackEvent, String dataSource) {
        Object returnData;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long rsmId = dataEntity.getLong("id");
        if (rsmId != 0L && !"1".equals(dataSource) && (returnData = closedCallBackEvent.getReturnData()) instanceof DynamicObject) {
            List sortResults = RsmCommonHelper.getAllExpSortList((Long)rsmId, Collections.singletonList((DynamicObject)returnData), (String)"tstpm_srrsmeduexp");
            RsmEduExpHelper.saveRsmEduExp((List)sortResults, (Long)rsmId, (IPageCache)this.getPageCache());
        }
        RsmHelper.reloadRsmExpView((String)"tstpm_srrsmeduexp", (String)"flexpanelcontent_eduexp", (Long)rsmId, (IFormView)this.getView());
        if ("1".equals(dataSource)) {
            PreRsmService.refreshPreViewOfEdu((IFormView)this.getView(), (IDataModel)this.getModel());
        }
    }

    private void handleRCloseCallBackRsmLangAbl(ClosedCallBackEvent closedCallBackEvent, String dataSource) {
        Object returnData;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long rsmId = dataEntity.getLong("id");
        if (rsmId != 0L && !"1".equals(dataSource) && (returnData = closedCallBackEvent.getReturnData()) instanceof DynamicObject) {
            Object langCertScore = ((DynamicObject)returnData).get("langcertscore");
            if (HRObjectUtils.isEmpty((Object)langCertScore)) {
                ((DynamicObject)returnData).set("langcertscore", (Object)BigDecimal.ZERO);
            }
            List sortResults = RsmCommonHelper.getAllExpSortList((Long)rsmId, Collections.singletonList((DynamicObject)returnData), (String)"tstpm_srrsmlangabl");
            RsmLangAblHelper.saveRsmLangAbl((List)sortResults, (Long)rsmId, (IPageCache)this.getPageCache());
        }
        RsmHelper.reloadRsmExpView((String)"tstpm_srrsmlangabl", (String)"flexpanelcontent_langexp", (Long)rsmId, (IFormView)this.getView());
    }

    private void handleCloseCallBackRsmWordExp(ClosedCallBackEvent closedCallBackEvent, String dataSource) {
        Long rsmId = this.getModel().getDataEntity().getLong("id");
        if (rsmId != 0L && !"1".equals(dataSource)) {
            List sortResults = RsmCommonHelper.getAllExpSortList((Long)rsmId, Collections.singletonList((DynamicObject)closedCallBackEvent.getReturnData()), (String)"tstpm_srrsmworkexp");
            RsmWorkExpHelper.saveRsmWorkExp((List)sortResults, (Long)rsmId, (IPageCache)this.getPageCache());
        }
        RsmHelper.reloadRsmExpView((String)"tstpm_srrsmworkexp", (String)"flexpanelcontent_workexp", (Long)rsmId, (IFormView)this.getView());
        if ("1".equals(dataSource)) {
            PreRsmService.refreshPreViewOfWork((IFormView)this.getView(), (IDataModel)this.getModel());
        }
    }

    private void handleCLoseCallBackRsmPrjExp(ClosedCallBackEvent closedCallBackEvent, String dataSource) {
        Long rsmId = this.getModel().getDataEntity().getLong("id");
        if (rsmId != 0L && !"1".equals(dataSource)) {
            List sortResults = RsmCommonHelper.getAllExpSortList((Long)rsmId, Collections.singletonList((DynamicObject)closedCallBackEvent.getReturnData()), (String)"tstpm_srrsmprjexp");
            RsmPrjExpHelper.saveRsmPrjExp((List)sortResults, (Long)rsmId, (IPageCache)this.getPageCache());
        }
        RsmHelper.reloadRsmExpView((String)"tstpm_srrsmprjexp", (String)"flexpanelcontent_prjexp", (Long)rsmId, (IFormView)this.getView());
    }

    private void showBaseForm(String pageKey, Long pkId, String caption) {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            BaseShowParameter showParameter = FormShowHelper.createBaseFormShowParameter((String)pageKey, null, (ShowType)ShowType.Modal, null);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, pageKey));
            Object rsmId = this.getModel().getDataEntity().get("id");
            showParameter.setCustomParam("rsm_id", (Object)Objects.toString(rsmId, "0"));
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("dataSource", this.getView().getFormShowParameter().getCustomParam("dataSource"));
            if (HRStringUtils.isNotEmpty((String)caption)) {
                showParameter.setCaption(caption);
            }
            if (pkId != null) {
                showParameter.setPkId((Object)pkId);
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setPerInfoEdit() {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_peredit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_percancel", "bar_persave"});
            this.getView().setEnable(Boolean.TRUE, RsmConstants.KEY_PREINFO_FIELDS);
            this.cachePreInfo();
        }
    }

    private void setConInfoEdit() {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_conedit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_concancel", "bar_consave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"phone", "email"});
            this.cacheConInfo();
        }
    }

    private void setJobIntentionEdit() {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_jobintentionedit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_jobintentioncancel", "bar_jobintentionsave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"expccity", "expcfunction", "iscompemp", "accplacechange"});
            this.cacheJobIntentionInfo();
        }
    }

    private void setSelfDescEdit() {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_selfedit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_selfcancel", "bar_selfsave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"selfevaluation"});
            this.cacheSelfDescInfo();
        }
    }

    private void setPerInfoDisEdit() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_peredit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_percancel", "bar_persave"});
        this.getView().setEnable(Boolean.FALSE, RsmConstants.KEY_PREINFO_FIELDS);
    }

    private void setConInfoDisEdit() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_conedit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_concancel", "bar_consave"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"phone", "email"});
    }

    private void setJobIntentionDisEdit() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_jobintentionedit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_jobintentioncancel", "bar_jobintentionsave"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"expccity", "expcfunction", "iscompemp", "accplacechange"});
    }

    private void setSelfDescDisEdit() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_selfedit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_selfcancel", "bar_selfsave"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"selfevaluation"});
    }

    private void cachePreInfo() {
        IDataModel model = this.getModel();
        JSONObject preInfoJson = new JSONObject();
        for (String field : RsmConstants.KEY_PREINFO_FIELDS) {
            Object value = model.getValue(field);
            if (value instanceof Date) {
                preInfoJson.put(field, (Object)HRDateTimeUtils.format((Date)((Date)value)));
                continue;
            }
            if (value instanceof DynamicObject) {
                preInfoJson.put(field, ((DynamicObject)value).get("id"));
                continue;
            }
            preInfoJson.put(field, value);
        }
        this.getView().getPageCache().put("preinfo_data_cache", preInfoJson.toJSONString());
    }

    private void cacheConInfo() {
        IDataModel model = this.getModel();
        JSONObject conInfoJson = new JSONObject();
        conInfoJson.put("phone", model.getValue("phone"));
        conInfoJson.put("email", model.getValue("email"));
        this.getView().getPageCache().put("coninfo_data_cache", conInfoJson.toJSONString());
    }

    private void cacheJobIntentionInfo() {
        Object expcFunction;
        IDataModel model = this.getModel();
        JSONObject jobIntentionInfoJson = new JSONObject();
        Object expcCity = model.getValue("expccity");
        if (!HRObjectUtils.isEmpty((Object)expcCity)) {
            jobIntentionInfoJson.put("expccity", ((DynamicObject)expcCity).get("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(expcFunction = model.getValue("expcfunction")))) {
            jobIntentionInfoJson.put("expcfunction", ((DynamicObject)expcFunction).get("id"));
        }
        jobIntentionInfoJson.put("iscompemp", model.getValue("iscompemp"));
        jobIntentionInfoJson.put("accplacechange", model.getValue("accplacechange"));
        this.getView().getPageCache().put("jobintentioninfo_data_cache", jobIntentionInfoJson.toJSONString());
    }

    private void cacheSelfDescInfo() {
        IDataModel model = this.getModel();
        JSONObject conInfoJson = new JSONObject();
        conInfoJson.put("selfevaluation", model.getValue("selfevaluation"));
        this.getView().getPageCache().put("selfdesc_data_cache", conInfoJson.toJSONString());
    }

    private void checkInfoChange(String key) {
        String entityName = this.getView().getEntityId();
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(key, (IFormPlugin)this);
        if (!RsmHelper.showDataChangeForm((IFormView)this.getView(), null, (ConfirmCallBackListener)confirmCallBackListener)) {
            if (key.equals("panel_per")) {
                this.setPerInfoDisEdit();
                this.getPageCache().remove("preinfo_data_cache");
            } else if (key.equals("panel_contact")) {
                this.setConInfoDisEdit();
                this.getPageCache().remove("coninfo_data_cache");
            } else if (key.equals("panel_jobintention")) {
                this.setJobIntentionDisEdit();
                this.getPageCache().remove("jobintentioninfo_data_cache");
            } else {
                this.setSelfDescDisEdit();
                this.getPageCache().remove("selfdesc_data_cache");
            }
            this.getPageCache().remove(entityName);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String entityName = this.getView().getEntityId();
        if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.handleConfirmCallBack(messageBoxClosedEvent, entityName);
            this.getPageCache().remove(entityName);
        }
    }

    private void handleConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent, String entityName) {
        String callBackId;
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "panel_per": {
                RsmService.resetPreInfo((IFormView)this.getView());
                this.setPerInfoDisEdit();
                break;
            }
            case "panel_contact": {
                RsmService.resetConInfo((IFormView)this.getView());
                this.setConInfoDisEdit();
                break;
            }
            case "panel_jobintention": {
                RsmService.resetJobIntention((IFormView)this.getView());
                this.setJobIntentionDisEdit();
                break;
            }
            case "panel_selfdesc": {
                RsmService.resetSelfDesc((IFormView)this.getView());
                this.setSelfDescDisEdit();
                break;
            }
            case "tstpm_srrsm": {
                this.getPageCache().remove(entityName);
                this.getView().close();
                break;
            }
        }
    }

    private void savePreInfo() {
        if (this.validPreInfoData()) {
            this.setPerInfoDisEdit();
            IFormView formView = this.getView();
            String dataSource = (String)formView.getFormShowParameter().getCustomParam("dataSource");
            if (!"1".equals(dataSource)) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                this.executeUpdateRsm(dataEntity);
                RsmService.refreshAppFileHeader((DynamicObject)dataEntity, (IFormView)formView.getParentView(), (IFormView)this.getView());
            } else if ("1".equals(dataSource)) {
                PreRsmService.refreshPreViewOfBasic((IFormView)this.getView(), (IDataModel)this.getModel());
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.remove("preinfo_data_cache");
            pageCache.remove(formView.getEntityId());
            this.showSaveSuccessTips();
            formView.sendFormAction(this.getView().getParentView());
        }
    }

    private void saveJobIntentionInfo() {
        String cacheJobIntentionInfoStr;
        IFormView formView = this.getView();
        String dataSource = (String)formView.getFormShowParameter().getCustomParam("dataSource");
        this.setJobIntentionDisEdit();
        IPageCache pageCache = formView.getPageCache();
        if (!"1".equals(dataSource) && HRStringUtils.isNotEmpty((String)(cacheJobIntentionInfoStr = pageCache.get("jobintentioninfo_data_cache")))) {
            JSONObject conInfoJson = JSON.parseObject((String)cacheJobIntentionInfoStr);
            String cacheExpcCity = conInfoJson.getString("expccity");
            String cacheExpcFunction = conInfoJson.getString("expcfunction");
            String cacheIsCompEmp = conInfoJson.getString("iscompemp");
            String cacheAccPlaceChange = conInfoJson.getString("accplacechange");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String expcCity = dataEntity.getString("expccity");
            String expcFunction = dataEntity.getString("expcfunction");
            String isCompEmp = dataEntity.getString("iscompemp");
            String accPlaceChange = dataEntity.getString("accplacechange");
            if (!(Objects.equals(cacheExpcCity, expcCity) && Objects.equals(cacheExpcFunction, expcFunction) && Objects.equals(cacheIsCompEmp, isCompEmp) && Objects.equals(cacheAccPlaceChange, accPlaceChange))) {
                this.executeUpdateRsm(dataEntity);
                RsmService.refreshAppFileHeader((DynamicObject)dataEntity, (IFormView)formView.getParentView(), (IFormView)this.getView());
            }
        }
        pageCache.remove("jobintentioninfo_data_cache");
        pageCache.remove(formView.getEntityId());
        this.showSaveSuccessTips();
        formView.sendFormAction(this.getView().getParentView());
    }

    private boolean validPreInfoData() {
        IFormView view;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String tips = RsmCommonHelper.checkMustInput((DynamicObject)dataEntity, (IFormView)(view = this.getView()));
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.checkAdminDivision((DynamicObject)dataEntity, (IFormView)view);
        }
        if (HRStringUtils.isNotEmpty((String)tips)) {
            this.getView().getParentView().showTipNotification(tips);
            this.getView().sendFormAction(this.getView().getParentView());
            return false;
        }
        return true;
    }

    public boolean validConInfoData() {
        IFormView view;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String tips = RsmCommonHelper.checkPhoneEmail((DynamicObject)dataEntity, (IFormView)(view = this.getView()), (String)"phone", (String)"email");
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.validPhoneEmail((DynamicObject)dataEntity, (IFormView)view);
        }
        if (HRStringUtils.isNotEmpty((String)tips)) {
            this.getView().getParentView().showTipNotification(tips);
            this.getView().sendFormAction(this.getView().getParentView());
            return false;
        }
        return true;
    }

    private void saveConInfo() {
        String cacheConInfoStr;
        if (!this.validConInfoData()) {
            return;
        }
        this.setConInfoDisEdit();
        IFormView formView = this.getView();
        IPageCache pageCache = formView.getPageCache();
        String dataSource = (String)formView.getFormShowParameter().getCustomParam("dataSource");
        if (!"1".equals(dataSource) && HRStringUtils.isNotEmpty((String)(cacheConInfoStr = pageCache.get("coninfo_data_cache")))) {
            JSONObject conInfoJson = JSON.parseObject((String)cacheConInfoStr);
            String cachePhone = conInfoJson.getString("phone");
            String cacheEmail = conInfoJson.getString("email");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String phone = dataEntity.getString("phone");
            String email = dataEntity.getString("email");
            if (!Objects.equals(cachePhone, phone) || !Objects.equals(cacheEmail, email)) {
                this.executeUpdateRsm(dataEntity);
                IFormView parentView = formView.getParentView();
                RsmService.refreshAppFileHeader((DynamicObject)dataEntity, (IFormView)formView.getParentView(), (IFormView)this.getView());
                parentView.getModel().setValue("phone", (Object)phone);
                parentView.getModel().setValue("email", (Object)email);
            }
        }
        pageCache.remove("coninfo_data_cache");
        pageCache.remove(formView.getEntityId());
        this.showSaveSuccessTips();
        formView.sendFormAction(this.getView().getParentView());
    }

    private void saveSelfDesc() {
        DynamicObject dataEntity;
        String selfDesc;
        JSONObject conInfoJson;
        String selfDescCache;
        String cacheSelfDesc;
        this.setSelfDescDisEdit();
        IFormView formView = this.getView();
        IPageCache pageCache = formView.getPageCache();
        String dataSource = (String)formView.getFormShowParameter().getCustomParam("dataSource");
        if (!"1".equals(dataSource) && HRStringUtils.isNotEmpty((String)(cacheSelfDesc = pageCache.get("selfdesc_data_cache"))) && !Objects.equals(selfDescCache = (conInfoJson = JSON.parseObject((String)cacheSelfDesc)).getString("selfevaluation"), selfDesc = (dataEntity = this.getModel().getDataEntity()).getString("selfevaluation"))) {
            this.executeUpdateRsm(dataEntity);
            RsmService.refreshAppFileHeader((DynamicObject)dataEntity, (IFormView)formView.getParentView(), (IFormView)this.getView());
        }
        pageCache.remove("selfdesc_data_cache");
        pageCache.remove(formView.getEntityId());
        this.showSaveSuccessTips();
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void showSaveSuccessTips() {
        this.getView().getParentView().showSuccessNotification(SrRsmKDString.saveSuccess());
    }

    public void beforeClosed(BeforeClosedEvent ec) {
        ec.setCheckDataChange(false);
        if ("1".equals(this.getPageCache().get("key_checkchange_cache"))) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("tstpm_srrsm", (IFormPlugin)this);
            ec.setCancel(RsmHelper.showDataChangeForm((IFormView)this.getView(), null, (ConfirmCallBackListener)confirmCallBackListener));
        }
    }

    private void executeUpdateRsm(DynamicObject dataEntity) {
        AppResumeBo resumeBo = RsmCommonHelper.getUpdateResumeBo((DynamicObject)dataEntity, null, null);
        boolean isDiffUpdateStdRsm = RsmCommonHelper.dataIsChanged((IPageCache)this.getPageCache(), (DynamicObject)dataEntity);
        RsmCommonHelper.updateRsmInfo((DynamicObject)dataEntity, (AppResumeBo)resumeBo, (Boolean)Boolean.TRUE, (Boolean)isDiffUpdateStdRsm, (IPageCache)this.getPageCache());
        DynamicObject rsmEntity = this.getModel().getDataEntity();
        ResumeUtilsHelper.serialize((IPageCache)this.getPageCache(), (String)RsmCommonHelper.getCacheEntityKey((DynamicObject)rsmEntity), (DynamicObject)rsmEntity);
    }
}

