/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.arf;

import java.time.LocalDateTime;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.id.ID;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.arf.ARFRsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;

public class ARFRsmExpEdit
extends HRDataBaseEdit {
    private boolean dealDateTime;

    private void setCheckUpdate(boolean status) {
        this.getPageCache().put("checkupdatestatus", status ? "1" : "0");
    }

    public void createNewData(BizDataEventArgs ee) {
        ARFRsmHelper.setExpEditDataModel((BizDataEventArgs)ee, (IFormView)this.getView(), (String)this.getView().getEntityId());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getModel().getDataEntity().containsProperty("ishitherto")) {
            this.getView().setEnable(Boolean.valueOf(!this.getModel().getDataEntity().getBoolean("ishitherto")), new String[]{"endingdate"});
            if (this.getModel().getDataEntity().getBoolean("ishitherto")) {
                this.getModel().setValue("endingdate", null);
            }
        }
    }

    public void afterBindData(EventObject ee) {
        this.dealDateTime = ARFRsmHelper.dealDateTime((IDataModel)this.getModel());
        if (this.dealDateTime) {
            ARFRsmHelper.handleRsmExpAfterBindData((IFormView)this.getView());
        }
        DynamicObject expEntity = this.getModel().getDataEntity();
        IFormView parentView = this.getView().getParentView();
        IPageCache pageCache = parentView.getPageCache();
        ResumeUtilsHelper.serialize((IPageCache)pageCache, (String)RsmCommonHelper.getCacheEntityKey((DynamicObject)expEntity), (DynamicObject)expEntity);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperateKey().equals("save")) {
            this.setCheckUpdate(false);
            DynamicObject rsmExp = this.getModel().getDataEntity();
            rsmExp.set("modifytime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            if (this.dealDateTime && !ResumeAnalysisHelper.checkStartEndDate((DynamicObject)rsmExp)) {
                String tip = SrRsmKDString.startMustThanEndDate();
                this.getView().showTipNotification(tip);
                return;
            }
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            int opStatus = showParameter.getStatusValue();
            if (opStatus == OperationStatus.ADDNEW.getValue()) {
                this.handleAddNewAfterDoOp(showParameter, rsmExp);
            } else if (opStatus == OperationStatus.EDIT.getValue()) {
                this.handleEditAfterDoOp(showParameter, rsmExp);
            }
            this.getView().close();
        }
    }

    private void handleAddNewAfterDoOp(FormShowParameter showParameter, DynamicObject rsmExp) {
        Long rsmId = Long.parseLong((String)showParameter.getCustomParam("rsm_id"));
        String dataSource = (String)showParameter.getCustomParam("dataSource");
        String entityId = this.getView().getEntityId();
        IFormView parentView = this.getView().getParentView();
        IPageCache pageCache = parentView.getPageCache();
        rsmExp.set("id", (Object)ID.genLongId());
        if (rsmId == 0L) {
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)entityId, (DynamicObject)rsmExp);
            String viewCaption = this.getView().getFormShowParameter().getCaption();
            ResumeUtilsHelper.cacheChangeDisplayName((String)viewCaption, (IPageCache)pageCache, (String)parentView.getEntityId());
            this.getView().returnDataToParent((Object)entityId);
        } else {
            rsmExp.set("rsm", (Object)rsmId);
            if ("1".equals(dataSource)) {
                ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)entityId, (DynamicObject)rsmExp);
                this.getView().returnDataToParent((Object)entityId);
            } else {
                this.getView().returnDataToParent((Object)rsmExp);
            }
        }
    }

    private void handleEditAfterDoOp(FormShowParameter showParameter, DynamicObject rsmExp) {
        String dataSource = (String)showParameter.getCustomParam("dataSource");
        String entityId = this.getView().getEntityId();
        IFormView parentView = this.getView().getParentView();
        IPageCache pageCache = parentView.getPageCache();
        if ("1".equals(dataSource)) {
            rsmExp.set("id", showParameter.getCustomParam("pkId"));
            ResumeUtilsHelper.editCacheRsmExpData((IPageCache)pageCache, (String)entityId, (DynamicObject)rsmExp);
            this.getView().returnDataToParent((Object)entityId);
        } else {
            this.getView().returnDataToParent((Object)rsmExp);
        }
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        ARFRsmHelper.handleExpEditPropertyChange((PropertyChangedArgs)ee, (IFormView)this.getView());
    }

    public void beforeClosed(BeforeClosedEvent ee) {
        String checkUpdateStatus = this.getPageCache().get("checkupdatestatus");
        boolean isDataChange = HRStringUtils.isNotEmpty((String)checkUpdateStatus) && "0".equals(checkUpdateStatus);
        ee.setCheckDataChange(!isDataChange);
    }
}

