/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.arf;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tstpm.business.domain.stdrsm.helper.BlacklistHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.common.constants.rsm.sr.RsmConstants;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;

public class ARFRsmSimpleEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(ARFRsmSimpleEdit.class);

    public void afterCreateNewData(EventObject ee) {
        RsmService.setPositionData((IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate;
        LOG.info("RsmSimpleEdit.beforeDoOperation.begin");
        if (args.getSource() instanceof FormOperate && "submit".equals((operate = (FormOperate)args.getSource()).getOperateKey())) {
            LOG.info("RsmSimpleEdit.beforeDoOperation.SUBMIT");
            if (!ARFRsmSimpleEdit.validData(this.getView(), this.getModel().getDataEntity())) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        LOG.info("RsmSimpleEdit.afterDoOperation.begin");
        String opKey = afterDoOperationEventArgs.getOperateKey();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("tstpm_repeatedapplyprompt".equals(closedCallBackEvent.getActionId()) && "coverhisresume".equals(closedCallBackEvent.getReturnData())) {
            String repeatAppFileIdStr = this.getPageCache().get("repeatAppFileId");
            boolean result = this.handlerAfterCoverHisRsm(repeatAppFileIdStr);
            if (!result) {
                this.getView().showTipNotification(SrRsmKDString.updateFail());
            } else {
                String tips = SrRsmKDString.updateSuccess();
                Long repeatAppFileId = HRStringUtils.isNotEmpty((String)repeatAppFileIdStr) ? Long.valueOf(Long.parseLong(repeatAppFileIdStr)) : null;
                RsmCommonHelper.showAppFile((IFormView)this.getView(), (Object)repeatAppFileId, (String)tips);
                this.getPageCache().put("key_checkchange_cache", "0");
                this.getView().close();
            }
        }
    }

    private boolean handlerAfterCoverHisRsm(String repeatAppFileIdStr) {
        if (HRStringUtils.isNotEmpty((String)repeatAppFileIdStr)) {
            AppResumeBo appResumeBo;
            Long repeatAppFileId = Long.valueOf(repeatAppFileIdStr);
            DynamicObject appFile = ResumeUtilsHelper.getServiceHelper((String)"tspr_appfile").queryOne("id,isbinddelyrec,highesteduschool,highesteducation,appres,modifier,modifytime,birthday,jobstatus,phone,email", (Object)repeatAppFileId);
            if (appFile == null) {
                return false;
            }
            long rsmId = 0L;
            DynamicObject rsm = appFile.getDynamicObject("appres");
            if (rsm != null) {
                rsmId = rsm.getLong("id");
            }
            if (rsmId != 0L && (appResumeBo = ResumeBoHelper.getAppResumeBo((Long)rsmId)) != null) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject coverRsm = ARFRsmSimpleEdit.getRsm(dataEntity);
                RsmCommonHelper.copyResume((DynamicObject)coverRsm, (DynamicObject)appResumeBo.getRsm());
                this.setRsmExp(appResumeBo, dataEntity);
                RsmCommonHelper.coverOldRsm((AppResumeBo)appResumeBo, (ResumeTypeEnum)ResumeTypeEnum.FROM);
            }
        }
        return true;
    }

    private void handlerAfterSubmit() {
        LOG.info("RsmSimpleEdit.afterDoOperation.handlerAfterSubmit.begin");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject deliveryDt = ARFRsmSimpleEdit.getDeliveryDy(dataEntity);
        DynamicObject rsm = ARFRsmSimpleEdit.getRsm(dataEntity);
        rsm.set("rsmsource", (Object)RsmSourceEnum.FORM.getCode());
        if (rsm.getLong("id") == 0L) {
            rsm.set("id", (Object)ID.genLongId());
        }
        AppResumeBo resumeBo = new AppResumeBo(rsm, deliveryDt);
        this.setRsmExp(resumeBo, dataEntity);
        AddResumeHandleService addResumeHandleService = new AddResumeHandleService();
        Long positionId = dataEntity.getLong("positionid");
        LOG.info("RsmSimpleEdit.afterDoOperation.handlerAfterSubmit.positionId:[{}]", (Object)positionId);
        DynamicObject positionDt = RsmPositionHelper.queryOneById((Long)positionId);
        SaveCandidateResult saveCandidateResult = addResumeHandleService.handle(resumeBo, positionDt, Boolean.TRUE, ResumeTypeEnum.FROM);
        this.handlerSaveResult(saveCandidateResult);
        LOG.info("RsmSimpleEdit.afterDoOperation.handlerAfterSubmit.end");
    }

    private void handlerSaveResult(SaveCandidateResult saveCandidateResult) {
        if (!saveCandidateResult.isSuccess()) {
            String repeatAppFileId = String.valueOf(saveCandidateResult.getAppFileId());
            if (HRStringUtils.isNotEmpty((String)repeatAppFileId)) {
                FormShowParameter repeatApplyTipParameter = new FormShowParameter();
                repeatApplyTipParameter.setFormId("tstpm_repeatedapplyprompt");
                repeatApplyTipParameter.getOpenStyle().setShowType(ShowType.Modal);
                repeatApplyTipParameter.setShowTitle(false);
                repeatApplyTipParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tstpm_repeatedapplyprompt"));
                repeatApplyTipParameter.setCustomParam("repeatAppFileId", (Object)repeatAppFileId);
                this.getPageCache().put("repeatAppFileId", repeatAppFileId);
                this.getView().showForm(repeatApplyTipParameter);
            }
        } else {
            boolean isBlackList = BlacklistHelper.isBlacklist((long)saveCandidateResult.getStdRsmId());
            String tipMsg = isBlackList ? SrRsmKDString.addNewSuccessBlackList() : SrRsmKDString.addNewSuccess();
            RsmCommonHelper.showAppFile((IFormView)this.getView(), (Object)saveCandidateResult.getAppFileId(), (String)tipMsg);
            this.getPageCache().put("key_checkchange_cache", "0");
            this.getView().close();
        }
    }

    private void setRsmExp(AppResumeBo resumeBo, DynamicObject dataEntity) {
        if (dataEntity.getBoolean("completemodeck")) {
            RsmService.handlerRsmExpInfo((AppResumeBo)resumeBo, (IPageCache)this.getView().getPageCache());
        }
    }

    private static DynamicObject getRsm(DynamicObject dataEntity) {
        if (dataEntity.getBoolean("completemodeck")) {
            return dataEntity;
        }
        DynamicObject rsmDy = ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrsm").generateEmptyDynamicObject();
        DataEntityPropertyCollection depc = dataEntity.getDataEntityType().getProperties();
        for (IDataEntityProperty idep : depc) {
            String name = idep.getName();
            if (!RsmConstants.SIMPLE_RSM_FIELD.containsValue(name)) continue;
            rsmDy.set(name, dataEntity.get(name));
        }
        return rsmDy;
    }

    private static DynamicObject getDeliveryDy(DynamicObject dataEntity) {
        Long resacqmthdId = dataEntity.getLong("resacqmthd.id");
        Long recruchnlnmId = dataEntity.getLong("recruchnlnm.id");
        Long recruchnlMediaId = dataEntity.getLong("recruchnlmedia.id");
        Long appmthdId = dataEntity.getLong("appmthd.id");
        return AddResumeService.generateDeliveryDt((Object)recruchnlMediaId, (Object)appmthdId, (Object)resacqmthdId, (Object)recruchnlnmId);
    }

    private static boolean validData(IFormView view, DynamicObject dataEntity) {
        LOG.info("RsmSimpleEdit.beforeDoOperation.validData.Begin");
        String tips = "";
        tips = dataEntity.getBoolean("completemodeck") ? RsmCommonHelper.checkPhoneEmail((DynamicObject)dataEntity, (IFormView)view, (String)"phone", (String)"email") : RsmCommonHelper.checkPhoneEmail((DynamicObject)dataEntity, (IFormView)view, (String)"sphone", (String)"semail");
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.validPhoneEmail((DynamicObject)dataEntity, (IFormView)view);
        }
        if (HRStringUtils.isEmpty((String)tips) && dataEntity.getBoolean("completemodeck")) {
            tips = RsmCommonHelper.checkAdminDivision((DynamicObject)dataEntity, (IFormView)view);
        }
        if (HRStringUtils.isNotEmpty((String)tips)) {
            view.showTipNotification(tips);
            return false;
        }
        LOG.info("RsmSimpleEdit.beforeDoOperation.validData.Success");
        return true;
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        String propName = ee.getProperty().getName();
        String displayName = ee.getProperty().getDisplayName().getLocaleValue();
        String entityName = this.getView().getEntityId();
        if (!RsmConstants.NOT_CHECK_FIELD.contains(propName)) {
            ResumeUtilsHelper.cacheChangeDisplayName((String)displayName, (IPageCache)this.getView().getPageCache(), (String)entityName);
        }
        switch (propName) {
            case "birthday": 
            case "sbirthday": {
                this.handlerBirthdayChange((Date)ee.getChangeSet()[0].getNewValue());
                break;
            }
            case "partwt": {
                RsmHelper.handlerPartwtChange((Date)((Date)ee.getChangeSet()[0].getNewValue()), (IFormView)this.getView());
                break;
            }
            case "completemodeck": {
                this.onCompleteModeChange(ee);
                break;
            }
            default: {
                this.handlerOtherChange(propName);
            }
        }
    }

    private void onCompleteModeChange(PropertyChangedArgs ee) {
        boolean showSimpleRsm = Boolean.TRUE.equals(ee.getChangeSet()[0].getNewValue());
        RsmCommonHelper.showSimpleRsm((IFormView)this.getView(), (!showSimpleRsm ? 1 : 0) != 0);
    }

    private void handlerOtherChange(String propName) {
        Object fieldKey = RsmConstants.SIMPLE_RSM_FIELD.get(propName);
        if (null != fieldKey) {
            IDataModel model = this.getModel();
            model.setValue(String.valueOf(fieldKey), model.getValue(propName));
            return;
        }
        Object propVal = ResumeUtilsHelper.getKeyByValue((Map)RsmConstants.SIMPLE_RSM_FIELD, (Object)propName);
        if (null != propVal) {
            IDataModel model = this.getModel();
            model.setValue(String.valueOf(propVal), model.getValue(propName));
        }
    }

    private void handlerBirthdayChange(Date birthday) {
        IDataModel model = this.getModel();
        model.beginInit();
        Integer age = null;
        if (null != birthday) {
            age = ResumeAnalysisHelper.calculateAge((Date)birthday);
        }
        model.setValue("age", (Object)age);
        model.setValue("sage", (Object)age);
        model.setValue("birthday", (Object)birthday);
        model.setValue("sbirthday", (Object)birthday);
        model.setValue("propbirthday", (Object)birthday);
        model.endInit();
        IFormView view = this.getView();
        view.updateView("age");
        view.updateView("sage");
        view.updateView("birthday");
        view.updateView("sbirthday");
    }
}

