/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.rescheck;

import com.google.common.collect.ImmutableBiMap;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.BlacklistDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmSmlServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.duplicate.IDuplicateService;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.common.utils.TalentPoolDeseUtil;

public class MergerCandidatesPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(MergerCandidatesPlugin.class);

    public void afterCreateNewData(EventObject evt) {
        Object curId = this.getView().getFormShowParameter().getCustomParam("curId");
        Object susId = this.getView().getFormShowParameter().getCustomParam("susId");
        this.fillPersonData(Long.parseLong(String.valueOf(curId)), "cur");
        this.fillPersonData(Long.parseLong(String.valueOf(susId)), "sus");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"curstdrsm", "susstdrsm", "nextstep"});
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (HRStringUtils.equals((String)key, (String)"curstdrsm")) {
            HashMap<String, String> cstylesMap = new HashMap<String, String>(16);
            HashMap<String, String> cstylesMap1 = new HashMap<String, String>(16);
            cstylesMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gYm94LXNoYWRvdzogMXB4IDFweCA2cHggJ3RoZW1lQ29sb3InO1xuICBib3JkZXI6MXB4IHNvbGlkICd0aGVtZUNvbG9yJztcbiAgIHRyYW5zaXRpb246IGFsbCAwLjNzO1xuIH0ifQ==");
            this.getView().updateControlMetadata("curstdrsm", cstylesMap);
            cstylesMap1.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gYm94LXNoYWRvdzogMXB4IDFweCA2cHggI2U1ZTVlNTtcbiAgYm9yZGVyOjFweCBzb2xpZCAjZTVlNWU1O1xuICAgdHJhbnNpdGlvbjogYWxsIDAuM3M7XG4gfVxuIFxuXG4kOmhvdmVyIHtcbiAgYm9yZGVyOjFweCBzb2xpZCAndGhlbWVDb2xvcic7XG4gIGJveC1zaGFkb3c6IDFweCAxcHggNnB4ICd0aGVtZUNvbG9yJztcbiB9In0=");
            this.getView().updateControlMetadata("susstdrsm", cstylesMap1);
            this.getModel().setValue("selected", (Object)"cur");
        } else if (HRStringUtils.equals((String)key, (String)"susstdrsm")) {
            HashMap<String, String> cstylesMap = new HashMap<String, String>(16);
            HashMap<String, String> cstylesMap1 = new HashMap<String, String>(16);
            cstylesMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gYm94LXNoYWRvdzogMXB4IDFweCA2cHggJ3RoZW1lQ29sb3InO1xuICBib3JkZXI6MXB4IHNvbGlkICd0aGVtZUNvbG9yJztcbiAgIHRyYW5zaXRpb246IGFsbCAwLjNzO1xuIH0ifQ==");
            this.getView().updateControlMetadata("susstdrsm", cstylesMap);
            cstylesMap1.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gYm94LXNoYWRvdzogMXB4IDFweCA2cHggI2U1ZTVlNTtcbiAgYm9yZGVyOjFweCBzb2xpZCAjZTVlNWU1O1xuICAgdHJhbnNpdGlvbjogYWxsIDAuM3M7XG4gfVxuIFxuXG4kOmhvdmVyIHtcbiAgYm9yZGVyOjFweCBzb2xpZCAndGhlbWVDb2xvcic7XG4gIGJveC1zaGFkb3c6IDFweCAxcHggNnB4ICd0aGVtZUNvbG9yJztcbiB9In0=");
            this.getView().updateControlMetadata("curstdrsm", cstylesMap1);
            this.getModel().setValue("selected", (Object)"sus");
        } else if (HRStringUtils.equals((String)key, (String)"nextstep")) {
            if (HRStringUtils.isEmpty((String)(this.getModel().getValue("selected") + ""))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fdd\u7559\u7684\u5019\u9009\u4eba\u3002", (String)"MergerCandidatesPlugin_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            } else {
                Long susId;
                Long curId = Long.parseLong(this.getModel().getValue("key").toString());
                String message = ResumeValidateHelper.mergeSusValidate((Object)curId, (Object)(susId = Long.valueOf(Long.parseLong(this.getModel().getValue("sus_key").toString()))), (IFormView)this.getView().getParentView());
                if (HRStringUtils.isNotEmpty((String)message)) {
                    this.getView().close();
                    this.getView().getParentView().showErrorNotification(message);
                    this.getView().sendFormAction(this.getView().getParentView());
                }
                String curSelectType = this.getModel().getValue("selected") + "";
                Long selectId = Long.parseLong(this.getModel().getValue(this.getTitle("key", curSelectType)) + "");
                Long noSelectId = selectId.equals(curId) ? susId : curId;
                Boolean appFileVerfRes = (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tspr", (String)"appFileService", (String)"hasTobeEmployedAppFile", (Object[])new Object[]{selectId, noSelectId});
                String confirmMessage = ResManager.loadKDString((String)"\u5408\u5e76\u5019\u9009\u4eba\u540e\u5c06\u65e0\u6cd5\u8fdb\u884c\u9006\u8f6c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"MergerCandidatesPlugin_1", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                if (appFileVerfRes.booleanValue()) {
                    confirmMessage = ResManager.loadKDString((String)"\u7591\u4f3c\u6807\u51c6\u7b80\u5386\u201c%s\u201d\u5b58\u5728\u5f85\u5165\u804c\u7684\u5e94\u8058\u4fe1\u606f\uff0c\u5408\u5e76\u540e\u5c06\u4fdd\u7559\u5f53\u524d\u6807\u51c6\u7b80\u5386\u7684\u5e94\u8058\u4fe1\u606f\u4e14\u65e0\u6cd5\u8fdb\u884c\u9006\u8f6c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c", (String)"MergerCandidatesPlugin_4", (String)"tsc-tstpm-formplugin", (Object[])new Object[]{StdRsmServiceHelper.getStdRsmDy((Long)noSelectId).getString("fullname")});
                }
                if (TalentListFunService.isStdRsmBlackList((Long)curId) == !TalentListFunService.isStdRsmBlackList((Long)susId)) {
                    confirmMessage = ResManager.loadKDString((String)"\u5408\u5e76\u5019\u9009\u4eba\u540e\u5c06\u65e0\u6cd5\u8fdb\u884c\u9006\u8f6c\uff0c\u5e76\u4e14\u5019\u9009\u4eba\u88ab\u52a0\u5165\u9ed1\u540d\u5355\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"MergerCandidatesPlugin_4", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
                    if (appFileVerfRes.booleanValue()) {
                        confirmMessage = ResManager.loadKDString((String)"\u7591\u4f3c\u6807\u51c6\u7b80\u5386\u201c%s\u201d\u5b58\u5728\u5f85\u5165\u804c\u7684\u5e94\u8058\u4fe1\u606f\uff0c\u5408\u5e76\u540e\u5c06\u4fdd\u7559\u5f53\u524d\u6807\u51c6\u7b80\u5386\u7684\u5e94\u8058\u4fe1\u606f\u4e14\u4f1a\u88ab\u52a0\u5165\u9ed1\u540d\u5355\u4e14\u65e0\u6cd5\u8fdb\u884c\u9006\u8f6c\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c", (String)"MergerCandidatesPlugin_4", (String)"tsc-tstpm-formplugin", (Object[])new Object[]{StdRsmServiceHelper.getStdRsmDy((Long)noSelectId).getString("fullname")});
                    }
                }
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("callBackId_nextStep", (IFormPlugin)this);
                this.getView().showConfirm(confirmMessage, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, (Map)ImmutableBiMap.of((Object)2, (Object)"\u4e0a\u4e00\u6b65"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        int result = evt.getResult().getValue();
        if (result == MessageBoxResult.Yes.getValue() && HRStringUtils.equals((String)evt.getCallBackId(), (String)"callBackId_nextStep")) {
            this.callBackOfNextStep();
        }
    }

    private void callBackOfNextStep() {
        String mergeToId;
        DynamicObject mergeFrom;
        DynamicObject mergeTo;
        Long curId = Long.parseLong(this.getModel().getValue("key").toString());
        Long susId = Long.parseLong(this.getModel().getValue("sus_key").toString());
        String selectVal = this.getModel().getValue("selected") + "";
        if (HRStringUtils.equals((String)selectVal, (String)"cur")) {
            mergeTo = StdRsmServiceHelper.getStdRsmDy((Long)curId);
            mergeFrom = StdRsmServiceHelper.getStdRsmDy((Long)susId);
            mergeToId = curId + "";
        } else {
            mergeTo = StdRsmServiceHelper.getStdRsmDy((Long)susId);
            mergeFrom = StdRsmServiceHelper.getStdRsmDy((Long)curId);
            mergeToId = susId + "";
        }
        try {
            String message = ResumeValidateHelper.mergeSusValidate((Object)curId, (Object)susId, (IFormView)this.getView().getParentView());
            if (HRStringUtils.isNotEmpty((String)message)) {
                this.getView().close();
                this.getView().getParentView().showErrorNotification(message);
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
            try (TXHandle tx = TX.required();){
                try {
                    IDuplicateService service = new IDuplicateService("tstpm_stdrsmsimilar");
                    service.mergeStdRsm(mergeFrom, mergeTo);
                }
                catch (Exception ex) {
                    tx.markRollback();
                    throw new KDBizException(ex.getMessage());
                }
            }
            HashMap<String, String> returndata = new HashMap<String, String>();
            returndata.put("state", "success");
            returndata.put("stdrsmId", mergeToId);
            this.getView().returnDataToParent(returndata);
            this.getView().close();
        }
        catch (KDException error) {
            logger.error("failed to merge candidates", (Throwable)error);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u5e76\u5019\u9009\u4eba\u5931\u8d25", (String)"MergerCandidatesPlugin_3", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillPersonData(Long id, String type) {
        DynamicObject resData = StdRsmServiceHelper.getStdRsmDy((Long)id);
        Boolean havePermit = CheckPermissionHelper.getInstance().isCurTalentAuth(id.longValue());
        this.judgeAndFillBlackList(id, type);
        if (!HRStringUtils.isEmpty((String)resData.getString("photo"))) {
            Image head = (Image)this.getControl(this.getTitle("image", type));
            head.setUrl(HRImageUrlUtil.getImageFullUrl((String)resData.getString("photo")));
        }
        this.setTextValue("key", id + "", type);
        this.setTextValue("fullname", resData.getString("fullname"), type);
        String phone = havePermit != false ? resData.getString("phone") : TalentPoolDeseUtil.replacePhoneX((String)resData.getString("phone"));
        String email = havePermit != false ? resData.getString("email") : TalentPoolDeseUtil.replaceEmailX((String)resData.getString("email"));
        this.setTextValue("phone", phone, type);
        this.setTextValue("email", email, type);
        if (havePermit.booleanValue()) {
            this.fillrectApplyData(id, type);
        }
    }

    private void judgeAndFillBlackList(Long id, String type) {
        Boolean isBlack = TalentListFunService.isStdRsmBlackList((Long)id);
        this.getView().setVisible(isBlack, new String[]{this.getTitle("black", type)});
        if (isBlack.booleanValue()) {
            DynamicObject blacklistDy = BlacklistDataHelper.loadSingle((long)id);
            this.getModel().setValue(this.getTitle("blackreason", type), (Object)blacklistDy.getString("blareason"));
            this.getModel().setValue(this.getTitle("blackmodifier", type), (Object)blacklistDy.getDynamicObject("modifier").getString("name"));
        }
    }

    private void fillrectApplyData(Long id, String type) {
        Map rectData = StdRsmSmlServiceHelper.getRectApplyData((Long)id);
        this.setTextValue("rectjobdate", (String)rectData.get("rectjobdate"), type);
        this.setTextValue("rectjob", (String)rectData.get("rectjob"), type);
        this.setTextValue("rectjober", (String)rectData.get("rectjober"), type);
    }

    private String getTitle(String titleName, String type) {
        return "cur".equals(type) ? titleName : type + "_" + titleName;
    }

    private void setTextValue(String titleName, String value, String type) {
        if (HRStringUtils.isNotEmpty((String)value)) {
            this.getModel().setValue(this.getTitle(titleName, type), (Object)value);
        }
    }
}

