/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.rescheck;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.stdrsm.helper.BlacklistDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeFormHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardWorkExpDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmSmlServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.duplicate.IDuplicateService;
import kd.tsc.tstpm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListServiceHelper;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tstpm.business.infrastructure.utils.ResumeUtil;
import kd.tsc.tstpm.common.utils.TalentPoolDeseUtil;

public class SuspectedResumePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(SuspectedResumePlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter parameter = args.getFormShowParameter();
        String validate = ResumeValidateHelper.suspectedResumeOpenValidate((FormShowParameter)parameter);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            args.setCancel(true);
            args.setCancelMessage(validate);
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        EntryGrid resumeList = (EntryGrid)this.getControl("resumelist");
        resumeList.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"mergercddt", "cancelsus", "sus_viewcddt", "viewcddt", "allopen", "allclose", "cur_work_open", "cur_work_close", "false_work_open", "false_work_close", "cur_item_open", "cur_item_close", "false_item_open", "false_item_close"});
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String susId = this.getModel().getValue("susid", row) + "";
        String message = ResumeValidateHelper.stdRsmDeleteStateValidate((long)Long.parseLong(susId));
        if (HRStringUtils.isNotEmpty((String)message)) {
            this.getView().showErrorNotification(message);
            return;
        }
        this.clearBasicData("sus");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)Long.parseLong(susId));
        this.fillResumeData(stdRsmDy, "sus");
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.selectFirstRow();
    }

    private void selectFirstRow() {
        int rows = this.getModel().getDataEntity().getDynamicObjectCollection("resumelist").size();
        if (rows > 0) {
            EntryGrid resumeList = (EntryGrid)this.getControl("resumelist");
            resumeList.selectRows(0);
        }
    }

    public void afterCreateNewData(EventObject event) {
        Object obj = this.getView().getFormShowParameter().getCustomParam("id");
        Long stdRsmId = Long.valueOf(obj.toString());
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)stdRsmId);
        long mid = stdRsmDy.getLong("mid");
        String message = ResumeValidateHelper.stdRsmDeleteStateValidate((long)mid);
        if (HRStringUtils.isNotEmpty((String)message)) {
            this.getView().showErrorNotification(message);
            return;
        }
        this.init(mid + "");
    }

    private void init(String stdRsmId) {
        this.clearBasicData("cur");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)Long.parseLong(stdRsmId));
        this.fillResumeData(stdRsmDy, "cur");
        this.getSusList(Long.parseLong(stdRsmId));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        Map data = (Map)returnData;
        if (HRStringUtils.equals((String)actionId, (String)"merger") && HRStringUtils.equals((String)((String)data.get("state")), (String)"success")) {
            this.init((String)data.get("stdrsmId"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        Object curId = this.getModel().getValue(this.getTitle("key", "cur"));
        Object susId = this.getModel().getValue(this.getTitle("key", "sus"));
        if (key.contains("open") || key.contains("close")) {
            this.clickFlodDetails(key);
        } else if (HRStringUtils.equals((String)key, (String)"mergercddt")) {
            String message = ResumeValidateHelper.mergeSusValidate((Object)curId, (Object)susId, (IFormView)this.getView());
            if (HRStringUtils.isNotEmpty((String)message)) {
                this.getView().showErrorNotification(message);
                return;
            }
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "merger");
            ResumeFormHelper.showMergeCandidate((IFormView)this.getView(), (Object)curId, (Object)susId, (CloseCallBack)callBack);
        } else if (HRStringUtils.equals((String)key, (String)"cancelsus")) {
            String message = ResumeValidateHelper.cancelSusValidate((Object)curId, (Object)susId, (IFormView)this.getView());
            if (HRStringUtils.isNotEmpty((String)message)) {
                this.getView().showErrorNotification(message);
            } else {
                this.cancleSus();
            }
        } else if (HRStringUtils.equals((String)key, (String)"viewcddt")) {
            Long stdRsmId = Long.parseLong(this.getModel().getValue(this.getTitle("key", "cur")) + "");
            String validate = ResumeValidateHelper.viewStdRsmPermission((Long)Long.valueOf(curId.toString()));
            if (HRStringUtils.isNotEmpty((String)validate)) {
                this.getView().showErrorNotification(validate);
                return;
            }
            TalentListServiceHelper.getInstance().formShowCandidate(stdRsmId, this.getView());
        } else if (HRStringUtils.equals((String)key, (String)"sus_viewcddt")) {
            if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6807\u51c6\u7b80\u5386\u7684\u67e5\u770b\u6743\u9650", (String)"SuspectedResumePlugin_10", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long stdRsmId = Long.parseLong(this.getModel().getValue(this.getTitle("key", "sus")) + "");
            TalentListServiceHelper.getInstance().formShowCandidate(stdRsmId, this.getView());
        }
    }

    private void cancleSus() {
        String curName = this.getModel().getValue(this.getTitle("fullname", "cur")) + "";
        String susName = this.getModel().getValue(this.getTitle("fullname", "sus")) + "";
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("callBackId_cancelsus", (IFormPlugin)this);
        String confirmMessage = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88\u5019\u9009\u4eba\u201c%s\u201d\u4e0e\u201c%s\u201d\u7684\u7591\u4f3c\u5173\u7cfb\u5417\uff1f", (String)"SuspectedResumePlugin_1", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]), curName, susName);
        this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        int result = evt.getResult().getValue();
        if (result == MessageBoxResult.Yes.getValue() && HRStringUtils.equals((String)evt.getCallBackId(), (String)"callBackId_cancelsus")) {
            long stdRsmId = Long.parseLong(this.getModel().getValue(this.getTitle("key", "cur")).toString());
            long similarId = Long.parseLong(this.getModel().getValue(this.getTitle("key", "sus")).toString());
            String message = ResumeValidateHelper.cancelSusValidate((Object)stdRsmId, (Object)similarId, (IFormView)this.getView());
            if (HRStringUtils.isNotEmpty((String)message)) {
                this.getView().showErrorNotification(message);
                return;
            }
            IDuplicateService service = new IDuplicateService("tstpm_stdrsm");
            service.unSuspectStdRsm(Long.valueOf(stdRsmId), Long.valueOf(similarId));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u7591\u4f3c\u6210\u529f", (String)"SuspectedResumePlugin_2", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            this.getSusList(stdRsmId);
        }
    }

    private void clickFlodDetails(String key) {
        String value;
        String string = value = key.contains("open") ? "0" : "1";
        if (key.contains("all")) {
            this.getModel().setValue("cur_work_isflod", (Object)value);
            this.getModel().setValue("false_work_isflod", (Object)value);
            this.getModel().setValue("cur_item_isflod", (Object)value);
            this.getModel().setValue("false_item_isflod", (Object)value);
        } else if (key.contains("work")) {
            this.getModel().setValue("cur_work_isflod", (Object)value);
            this.getModel().setValue("false_work_isflod", (Object)value);
        } else {
            this.getModel().setValue("cur_item_isflod", (Object)value);
            this.getModel().setValue("false_item_isflod", (Object)value);
        }
    }

    private void getSusList(Long id) {
        this.getModel().deleteEntryData("resumelist");
        List susIds = SimilarServiceHelper.querySimilarList((Long)id);
        if (susIds.size() > 0) {
            this.clearBasicData("sus");
            Long stdRsmId = (Long)susIds.get(0);
            DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)stdRsmId);
            this.fillResumeData(stdRsmDy, "sus");
            this.getView().setVisible(susIds.size() == 1 ? Boolean.FALSE : Boolean.TRUE, new String[]{"suslist_box"});
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("resumelist", susIds.size());
            EntryGrid resumelist = (EntryGrid)this.getControl("resumelist");
            resumelist.addRowClickListener((RowClickEventListener)this);
            resumelist.selectRows(0);
            for (int i = 0; i < susIds.size(); ++i) {
                String susName = ResManager.loadKDString((String)"\u7591\u4f3c\u6807\u51c6\u7b80\u5386", (String)"SuspectedResumePlugin_4", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]) + (i + 1);
                this.getModel().setValue("susname", (Object)susName, rowIndex[i]);
                this.getModel().setValue("susid", susIds.get(i), rowIndex[i]);
            }
        } else {
            this.getView().close();
            this.getView().returnDataToParent((Object)"noSusResume");
        }
    }

    private void fillResumeData(DynamicObject resData, String type) {
        DynamicObject city;
        this.clickFlodDetails("close");
        long stdRsmId = resData.getLong("mid");
        String message = ResumeValidateHelper.stdRsmDeleteStateValidate((long)stdRsmId);
        if (HRStringUtils.isNotEmpty((String)message)) {
            this.getView().showErrorNotification(message);
            return;
        }
        String permMessage = ResumeValidateHelper.viewStdRsmPermission((Long)stdRsmId);
        boolean haveDataPermit = HRStringUtils.isEmpty((String)permMessage);
        this.judgeAndFillBlackList(stdRsmId, type);
        if (HRStringUtils.isNotEmpty((String)resData.getString("photo"))) {
            Image head = (Image)this.getControl(this.getTitle("image", type));
            head.setUrl(HRImageUrlUtil.getImageFullUrl((String)resData.getString("photo")));
        }
        this.setTextValue("key", stdRsmId + "", type, -1);
        this.setTextValue("gender", resData.getString("gender.name"), type, -1);
        DynamicObject rectWorkExp = StandardWorkExpDataHelper.queryRecentWorkExp((Long)stdRsmId);
        if (rectWorkExp != null && (city = (DynamicObject)rectWorkExp.get("city")) != null) {
            this.setTextValue("natreg", city.getString("name"), type, -1);
        }
        String phone = haveDataPermit || TalentPoolMgtPermHelper.isSuperUser() ? resData.getString("phone") : TalentPoolDeseUtil.replacePhoneX((String)resData.getString("phone"));
        String email = haveDataPermit || TalentPoolMgtPermHelper.isSuperUser() ? resData.getString("email") : TalentPoolDeseUtil.replaceEmailX((String)resData.getString("email"));
        String name = haveDataPermit || TalentPoolMgtPermHelper.isSuperUser() ? resData.getString("fullname") : TalentPoolDeseUtil.replacePartName((String)resData.getString("fullname"));
        this.setTextValue("fullname", name, type, -1);
        this.setTextValue("phone", phone, type, -1);
        this.setTextValue("email", email, type, -1);
        if (!haveDataPermit && !TalentPoolMgtPermHelper.isSuperUser()) {
            String customStyle = "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICB2aXNpYmlsaXR5OiBoaWRkZW47XG59In0=";
            this.updateCStyle(this.getTitle("flex_edu", type), customStyle);
            this.updateCStyle(this.getTitle("flex_job", type), customStyle);
            this.updateCStyle(this.getTitle("flex_pro", type), customStyle);
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTitle("rectjobdata", type), this.getTitle("viewcddt", type)});
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getTitle("nopermit", type)});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getTitle("viewcddt", type)});
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTitle("nopermit", type)});
            this.fillrectApplyData(stdRsmId, type);
            this.fillEduExper(stdRsmId, type);
            this.fillJobExper(stdRsmId, type);
            this.fillprojectExper(stdRsmId, type);
        }
        Object curId = this.getModel().getValue(this.getTitle("key", "cur"));
        Object susId = this.getModel().getValue(this.getTitle("key", "sus"));
        if (type.equals("sus")) {
            this.getView().setVisible(Boolean.valueOf(ResumeValidateHelper.mergeSusValidate((Object)curId, (Object)susId, (IFormView)this.getView()) == null), new String[]{"mergercddt"});
            this.getView().setVisible(Boolean.valueOf(ResumeValidateHelper.cancelSusValidate((Object)curId, (Object)susId, (IFormView)this.getView()) == null), new String[]{"cancelsus"});
        }
    }

    private void judgeAndFillBlackList(Long id, String type) {
        Boolean isBlack = TalentListFunService.isStdRsmBlackList((Long)id);
        this.getView().getPageCache().put(this.getTitle("blackState", type), isBlack.toString());
        this.getView().setVisible(isBlack, new String[]{this.getTitle("black", type)});
        if (isBlack.booleanValue()) {
            DynamicObject blacklistDy = BlacklistDataHelper.loadSingle((long)id);
            this.getModel().setValue(this.getTitle("blackreason", type), (Object)blacklistDy.getString("blareason"));
            this.getModel().setValue(this.getTitle("blackmodifier", type), (Object)blacklistDy.getDynamicObject("modifier").getString("name"));
        }
    }

    private void fillrectApplyData(Long id, String type) {
        this.getView().setVisible(Boolean.TRUE, new String[]{this.getTitle("rectjobdata", type)});
        Map rectData = StdRsmSmlServiceHelper.getRectApplyData((Long)id);
        this.setTextValue("rectjobdate", (String)rectData.get("rectjobdate"), type, -1);
        this.setTextValue("rectjob", (String)rectData.get("rectjob"), type, -1);
        this.setTextValue("rectjober", (String)rectData.get("rectjober"), type, -1);
    }

    private String getTitle(String titleName, String type) {
        return type.equals("cur") ? titleName : type + "_" + titleName;
    }

    private void updateCStyle(String title, String cStyle) {
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("cstyles", cStyle);
        this.getView().updateControlMetadata(title, ctrl);
    }

    private void fillEduExper(Long id, String type) {
        this.updateCStyle(this.getTitle("flex_edu", type), "");
        this.getModel().deleteEntryData(this.getTitle("edu_entry", type));
        List eduExperArr = StdRsmServiceHelper.getEntryDysOrdered((String)"tstpm_stdeduexp", (Long)id);
        if (eduExperArr.size() > 0) {
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(this.getTitle("edu_entry", type), eduExperArr.size());
            CardEntry cardEntry = (CardEntry)this.getView().getControl(this.getTitle("edu_entry", type));
            for (int i = 0; i < eduExperArr.size(); ++i) {
                DynamicObject eduItem = (DynamicObject)eduExperArr.get(i);
                if (eduItem == null) continue;
                String timeSlot = this.timeSlotHandle(eduItem);
                this.setTextValue("edutimeslot", timeSlot, type, rowIndex[i]);
                this.setTextValue("lengthofstudy", ResumeUtil.getFormativeDuration((Date)eduItem.getDate("startdate"), (Date)eduItem.getDate("endingdate")), type, rowIndex[i]);
                DynamicObject school = (DynamicObject)eduItem.get("schoolname");
                if (school != null) {
                    if (HRStringUtils.equals((String)school.getString("number"), (String)"30000010_S")) {
                        this.setTextValue("schoolname", eduItem.getString("othschname"), type, rowIndex[i]);
                    } else {
                        this.setTextValue("schoolname", school.getString("name"), type, rowIndex[i]);
                    }
                }
                this.setTextValue("specialtyname", eduItem.getString("specialtyname"), type, rowIndex[i]);
                DynamicObject education = (DynamicObject)eduItem.get("education");
                if (education != null) {
                    this.setTextValue("education", education.getString("name"), type, rowIndex[i]);
                }
                Boolean isShowGuide = i == eduExperArr.size() - 1 ? Boolean.FALSE : Boolean.TRUE;
                cardEntry.setChildVisible(isShowGuide.booleanValue(), rowIndex[i], new String[]{this.getTitle("edu_guideline", type)});
            }
        }
    }

    private void fillJobExper(Long id, String type) {
        this.updateCStyle(this.getTitle("flex_job", type), "");
        this.getModel().deleteEntryData(this.getTitle("job_entry", type));
        List jobExperArr = StdRsmServiceHelper.getEntryDysOrdered((String)"tstpm_stdworkexp", (Long)id);
        if (jobExperArr.size() > 0) {
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(this.getTitle("job_entry", type), jobExperArr.size());
            CardEntry cardEntry = (CardEntry)this.getView().getControl(this.getTitle("job_entry", type));
            for (int i = 0; i < jobExperArr.size(); ++i) {
                DynamicObject jobItem = (DynamicObject)jobExperArr.get(i);
                if (jobItem == null) continue;
                String timeSlot = this.timeSlotHandle(jobItem);
                this.setTextValue("jobtimeslot", timeSlot, type, rowIndex[i]);
                this.setTextValue("lengthofwork", ResumeUtil.getFormativeDuration((Date)jobItem.getDate("startdate"), (Date)jobItem.getDate("endingdate")), type, rowIndex[i]);
                this.setTextValue("companyname", jobItem.getString("companyname"), type, rowIndex[i]);
                this.setTextValue("positionname", jobItem.getString("positionname"), type, rowIndex[i]);
                this.setTextValue("workresponsibility", jobItem.getString("workresponsibility"), type, rowIndex[i]);
                Boolean isShowGuide = i == jobExperArr.size() - 1 ? Boolean.FALSE : Boolean.TRUE;
                cardEntry.setChildVisible(isShowGuide.booleanValue(), rowIndex[i], new String[]{this.getTitle("job_guideline", type)});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getTitle("jobbutton", type)});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTitle("jobbutton", type)});
        }
    }

    private void fillprojectExper(Long id, String type) {
        this.updateCStyle(this.getTitle("flex_pro", type), "");
        this.getModel().deleteEntryData(this.getTitle("pro_entry", type));
        List projctExperArr = StdRsmServiceHelper.getEntryDysOrdered((String)"tstpm_stdprjexp", (Long)id);
        if (projctExperArr.size() > 0) {
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(this.getTitle("pro_entry", type), projctExperArr.size());
            CardEntry cardEntry = (CardEntry)this.getView().getControl(this.getTitle("pro_entry", type));
            for (int i = 0; i < projctExperArr.size(); ++i) {
                DynamicObject projctItem = (DynamicObject)projctExperArr.get(i);
                if (projctItem == null) continue;
                String timeSlot = this.timeSlotHandle(projctItem);
                this.setTextValue("protimeslot", timeSlot, type, rowIndex[i]);
                this.setTextValue("projectduration", ResumeUtil.getFormativeDuration((Date)projctItem.getDate("startdate"), (Date)projctItem.getDate("endingdate")), type, rowIndex[i]);
                this.setTextValue("projectname", projctItem.getString("projectname"), type, rowIndex[i]);
                this.setTextValue("projectjob", projctItem.getString("projectjob"), type, rowIndex[i]);
                this.setTextValue("projectresp", projctItem.getString("projectresp"), type, rowIndex[i]);
                Boolean isShowGuide = i == projctExperArr.size() - 1 ? Boolean.FALSE : Boolean.TRUE;
                cardEntry.setChildVisible(isShowGuide.booleanValue(), rowIndex[i], new String[]{this.getTitle("pro_guideline", type)});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getTitle("probutton", type)});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTitle("probutton", type)});
        }
    }

    private String timeSlotHandle(DynamicObject item) {
        String noVal;
        String start = noVal = ResManager.loadKDString((String)"\u672a\u77e5", (String)"SuspectedResumePlugin_5", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
        String end = noVal;
        Object startDate = item.get("startdate");
        Object endDate = item.get("endingdate");
        if (startDate != null) {
            String string = start = HRStringUtils.isEmpty((String)startDate.toString()) ? noVal : startDate.toString().split(" ")[0];
        }
        if (endDate != null) {
            String string = end = HRStringUtils.isEmpty((String)endDate.toString()) ? noVal : endDate.toString().split(" ")[0];
        }
        if (HRStringUtils.equals((String)start, (String)noVal) && HRStringUtils.equals((String)end, (String)noVal)) {
            return ResManager.loadKDString((String)"\u65f6\u95f4\u672a\u77e5", (String)"SuspectedResumePlugin_6", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
        }
        return start + " " + ResManager.loadKDString((String)"\u81f3", (String)"SuspectedResumePlugin_7", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]) + " " + end;
    }

    private void clearBasicData(String type) {
        Image head = (Image)this.getControl(this.getTitle("image", type));
        head.setUrl("/images/pc/emotion/default_person_82_82.png");
        this.getModel().setValue(this.getTitle("fullname", type), (Object)"\u59d3\u540d\u672a\u77e5");
        this.getModel().setValue(this.getTitle("gender", type), (Object)"\u6027\u522b\u672a\u77e5");
        this.getModel().setValue(this.getTitle("natreg", type), (Object)"\u5de5\u4f5c\u5730\u70b9\u672a\u77e5");
        this.getModel().setValue(this.getTitle("phone", type), (Object)"");
        this.getModel().setValue(this.getTitle("email", type), (Object)"");
        this.getModel().setValue(this.getTitle("rectjob", type), (Object)"");
        this.getModel().setValue(this.getTitle("rectjobdate", type), (Object)"");
        this.getModel().setValue(this.getTitle("rectjober", type), (Object)"");
        this.updateCStyle(this.getTitle("flex_edu", type), "");
        this.getModel().deleteEntryData(this.getTitle("edu_entry", type));
        this.updateCStyle(this.getTitle("flex_job", type), "");
        this.getModel().deleteEntryData(this.getTitle("job_entry", type));
        this.updateCStyle(this.getTitle("flex_pro", type), "");
        this.getModel().deleteEntryData(this.getTitle("pro_entry", type));
    }

    private void setTextValue(String titleName, String value, String type, int index) {
        if (HRStringUtils.isNotEmpty((String)value)) {
            if (index == -1) {
                this.getModel().setValue(this.getTitle(titleName, type), (Object)value);
            } else {
                this.getModel().setValue(this.getTitle(titleName, type), (Object)value, index);
            }
        }
    }
}

