/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.rsm.sr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.common.constants.rsm.ResumeConstants;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;

public class AddResumeResultPlugin
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(AddResumeResultPlugin.class);

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        Button againAddCandidateButton = (Button)this.getView().getControl("againaddcandidate");
        againAddCandidateButton.addClickListener((ClickListener)this);
        Button endAddCandidateButton = (Button)this.getView().getControl("endaddcandidate");
        endAddCandidateButton.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject eo) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String analysisResultListBase64 = (String)showParameter.getCustomParam("resumelistlentryentity");
        String positionId = (String)showParameter.getCustomParam("position");
        if (HRStringUtils.isNotEmpty((String)analysisResultListBase64)) {
            List resumeDtList = (List)SerializationUtils.deSerializeFromBase64((String)analysisResultListBase64);
            int total = resumeDtList.size();
            int successCount = 0;
            for (DynamicObject resumeDt : resumeDtList) {
                int resultStatus = resumeDt.getInt("resultstatus");
                if (resultStatus == 200) {
                    ++successCount;
                }
                this.loadResumeResult(resumeDt, positionId);
            }
            String resultDesc = SrRsmKDString.addSuccessFailSta();
            resultDesc = String.format(Locale.ROOT, resultDesc, resumeDtList.size(), successCount, total - successCount);
            this.getModel().setValue("resultlog", (Object)resultDesc);
            this.changeResultForeColor();
        }
    }

    private void loadResumeResult(DynamicObject resumeDt, String positionId) {
        String operationName = null;
        int resultStatus = resumeDt.getInt("resultstatus");
        String appFileId = resumeDt.getString("appfile");
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("resultstatus", new Object[0]);
        vs.addField("appfile", new Object[0]);
        vs.addField("pagecacheid", new Object[0]);
        vs.addField("filename", new Object[0]);
        vs.addField("fullname", new Object[0]);
        vs.addField("phone", new Object[0]);
        vs.addField("email", new Object[0]);
        vs.addField("result", new Object[0]);
        vs.addField("viewcandidate", new Object[0]);
        vs.addField("updatersm", new Object[0]);
        String updateName = "";
        if (!positionId.equals("0") && HRStringUtils.isNotEmpty((String)appFileId)) {
            if (resultStatus == 200) {
                operationName = SrRsmKDString.viewCandidate();
            } else {
                operationName = SrRsmKDString.viewHisRsm();
                updateName = SrRsmKDString.update();
            }
        }
        vs.addRow(new Object[]{String.valueOf(resultStatus), appFileId, resumeDt.get("pagecacheid"), resumeDt.get("filename"), resumeDt.get("fullname"), resumeDt.get("phone"), resumeDt.get("email"), resumeDt.get("result"), operationName, updateName});
        model.batchCreateNewEntryRow("resumelistlentryentity", vs);
        model.endInit();
        this.getView().updateView("resumelistlentryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        EntryGrid entryGrid = (EntryGrid)arg0.getSource();
        DynamicObject[] dynamicObject = entryGrid.getEntryData().getDataEntitys();
        int rowIndex = arg0.getRowIndex();
        DynamicObject dataEntry = dynamicObject[rowIndex];
        long appFileId = dataEntry.getLong("appfile");
        String pageCacheId = dataEntry.getString("pagecacheid");
        LOG.info("AddResumeResultPlugin.appFile={}", (Object)appFileId);
        String hyperFieldName = arg0.getFieldName();
        if (HRStringUtils.equals((String)"viewcandidate", (String)hyperFieldName)) {
            LOG.info("AddResumeResultPlugin.fieldName={}", (Object)arg0.getFieldName());
            RsmCommonHelper.showAppFile((IFormView)this.getView(), (Object)appFileId, (String)"");
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("updatersm", (IFormPlugin)this);
            String msg = SrRsmKDString.coverOldRsmTips();
            JSONObject args = new JSONObject();
            args.put("appfile", (Object)appFileId);
            args.put("pagecacheid", (Object)pageCacheId);
            args.put("rowIndex", (Object)rowIndex);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, args.toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("updatersm".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            JSONObject args = JSON.parseObject((String)messageBoxClosedEvent.getCustomVaule());
            Long appFileId = args.getLong("appfile");
            DynamicObject appFile = ResumeUtilsHelper.getServiceHelper((String)"tspr_appfile").queryOne("id,isbinddelyrec,highesteduschool,highesteducation,appres,modifier,modifytime,birthday,jobstatus,phone,email", (Object)appFileId);
            if (appFile != null) {
                long rsmId = 0L;
                DynamicObject rsm = appFile.getDynamicObject("appres");
                if (rsm != null) {
                    rsmId = rsm.getLong("id");
                }
                if (rsmId != 0L) {
                    AppResumeBo appResumeBo = ResumeBoHelper.getAppResumeBo((Long)rsmId);
                    this.setResumeBoData(appResumeBo, args);
                }
            }
            int rowIndex = args.getInteger("rowIndex");
            String updateSuccessMsg = SrRsmKDString.updateSuccess();
            this.getModel().setValue("result", (Object)updateSuccessMsg, rowIndex);
            this.getModel().setValue("updatersm", (Object)"", rowIndex);
            String opMSg = SrRsmKDString.viewCandidate();
            this.getModel().setValue("viewcandidate", (Object)opMSg, rowIndex);
            this.changeResultForeColor(rowIndex);
            RsmCommonHelper.showAppFile((IFormView)this.getView(), (Object)appFileId, (String)updateSuccessMsg);
        }
    }

    private void setResumeBoData(AppResumeBo appResumeBo, JSONObject args) {
        if (appResumeBo != null) {
            String pageCacheId = args.getString("pagecacheid");
            AppResumeBo newResumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)this.getView().getParentView().getPageCache().get(pageCacheId));
            DynamicObject newRsm = newResumeBo.getRsm();
            for (String pageKey : ResumeConstants.SUBPAGES) {
                appResumeBo.setEntry(pageKey, newResumeBo.getEntry(pageKey));
            }
            RsmCommonHelper.copyResume((DynamicObject)newRsm, (DynamicObject)appResumeBo.getRsm());
            RsmService.handlerRsmExpInfo((AppResumeBo)appResumeBo);
            RsmCommonHelper.coverOldRsm((AppResumeBo)appResumeBo, (ResumeTypeEnum)ResumeTypeEnum.ANALYSIS);
            long appFileId = ResumeUtilsHelper.getId((DynamicObject)appResumeBo.getRsm(), (String)"appfile");
            AppFileMService.addRsmUpdateOpRecord((long)appFileId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        HashMap<String, String> returnData = new HashMap<String, String>(1);
        if (HRStringUtils.equals((String)source.getKey(), (String)"againaddcandidate")) {
            returnData.put("btnsign", "againaddcandidate");
            this.getView().returnDataToParent(returnData);
        }
        if (HRStringUtils.equals((String)source.getKey(), (String)"endaddcandidate")) {
            returnData.put("btnsign", "endaddcandidate");
            this.getView().returnDataToParent(returnData);
        }
        this.getView().close();
    }

    private void changeResultForeColor() {
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(16);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] analysisResultArrays = entryData.getDataEntitys();
        int rowIndex = -1;
        for (DynamicObject entryEntity : analysisResultArrays) {
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey("result");
            cellStyle.setRow(++rowIndex);
            if (HRStringUtils.equals((String)ResumeConstants.RESULTSUCCESS, (String)entryEntity.getString("result")) || HRStringUtils.equals((String)ResumeConstants.RESULT_SUCCESS_BLACK_LIST, (String)entryEntity.getString("result"))) {
                cellStyle.setForeColor("#26B175");
            } else {
                cellStyle.setForeColor("#FD6C6A");
            }
            cellStyleList.add(cellStyle);
        }
        entryGrid.setCellStyle(cellStyleList);
    }

    private void changeResultForeColor(int rowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey("result");
        cellStyle.setRow(rowIndex);
        cellStyle.setForeColor("#26B175");
        cellStyleList.add(cellStyle);
        entryGrid.setCellStyle(cellStyleList);
    }
}

