/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.rsm.sr;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.enums.rsm.RsmAssignTypeEnum;
import kd.tsc.tsrbs.common.utils.EnumUtils;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.entity.PositionAndAddressDto;
import kd.tsc.tstpm.business.domain.rsm.sr.entity.RsmAssignRuleDto;
import kd.tsc.tstpm.business.domain.rsm.sr.helper.AssignPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tstpm.business.domain.rsm.unallocate.UnAllocateRsmHelper;
import kd.tsc.tstpm.common.constants.rsm.unallocate.AssignPositionResult;

public class AssignPositionEditPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(AssignPositionEditPlugin.class);
    private static AssignPositionHelper assignPositionHelper = AssignPositionHelper.getInstance();
    private static ThreadPool assignPositionThreadPools = ThreadPools.newCachedThreadPool((String)"assignPositionThreadPools");
    private static final String KEY_CHECKBOXFIELD = "checkboxfield";

    public void registerListener(EventObject ee) {
        super.registerListener(ee);
        this.addClickListeners(new String[]{"btnsave", "position"});
    }

    public void afterCreateNewData(EventObject ee) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("\u7b80\u5386\u5206\u914d\u804c\u4f4d\u63a5\u6536\u53c2\u6570:{}", (Object)SerializationUtils.toJsonString((Object)customParams));
        if (customParams.size() != 0 && customParams.get("rsmIDList") != null) {
            List rsmList = (List)customParams.get("rsmIDList");
            this.getPageCache().put("rsmList", JSON.toJSONString((Object)rsmList));
            DynamicObject[] positionNameAndAddress = assignPositionHelper.getPositionNameAndAddress(rsmList);
            List assignLists = assignPositionHelper.assignPosition(positionNameAndAddress);
            LOGGER.info("\u90ae\u7bb1\u89e3\u6790\u804c\u4f4d\u548c\u540d\u79f0\u7ed3\u679c\uff1a{}", (Object)SerializationUtils.toJsonString((Object)assignLists));
            this.getPageCache().put("assignLists", JSON.toJSONString((Object)assignLists));
            RsmAssignRuleDto rsmAssignRule = assignPositionHelper.getRsmAssignRule(assignLists);
            this.setLabelValue(rsmAssignRule);
        }
    }

    private void setLabelValue(RsmAssignRuleDto rsmAssignRule) {
        if (rsmAssignRule != null) {
            LOGGER.info("\u7b80\u5386\u5206\u914d\u89c4\u5219\u6761\u4ef6\uff1a{}", (Object)rsmAssignRule.toString());
            this.getPageCache().put("rule", JSON.toJSONString((Object)rsmAssignRule));
            StringBuilder labelText = new StringBuilder();
            labelText.append(EnumUtils.getValueByCode((String)rsmAssignRule.getDistributedMode(), RsmAssignTypeEnum.class));
            labelText.append(ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u5305\u542b:", (String)"AssignPositionEditPlugin_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
            labelText.append(rsmAssignRule.getKeyword());
            Label labelap = (Label)this.getView().getControl("labelap");
            labelap.setText(labelText.toString());
        }
    }

    public void afterBindData(EventObject ee) {
        String rule = this.getPageCache().get("rule");
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)rule)), new String[]{KEY_CHECKBOXFIELD});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btnsave", (String)source.getKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long positionID = dataEntity.getLong("positionid");
            DynamicObject newPosition = RsmPositionHelper.queryOneById((Long)positionID);
            String positionStatus = newPosition.getString("positionstatus");
            List<String> status = Arrays.asList("A", "C");
            if (!status.contains(positionStatus)) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u804c\u4f4d\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AssignPositionEditPlugin_1", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                return;
            }
            List<PositionAndAddressDto> positionAndAddressDtos = this.getPositionAndAddressDtos();
            Map stdRsmStatusMap = UnAllocateRsmHelper.getStdRsmStatusMap(positionAndAddressDtos.stream().map(PositionAndAddressDto::getRsmID).collect(Collectors.toList()));
            if (stdRsmStatusMap.containsValue(ResumeHisDataStatusEnum.DELETED.getStatus())) {
                IFormView tipView = this.getView().getMainView();
                String errorTip = TSCBaseKDString.dataChangedTip();
                IFormView parentView = this.getView().getParentView();
                if (parentView instanceof BaseView) {
                    parentView.close();
                    this.getView().sendFormAction(parentView);
                    errorTip = UnAllocateRsmHelper.getStdRsmChangeTip();
                }
                tipView.showErrorNotification(errorTip);
                this.getView().sendFormAction(tipView);
                this.getView().close();
                return;
            }
            List<AssignPositionResult> errorList = this.assignPosition(dataEntity, newPosition);
            if (errorList.isEmpty()) {
                this.getView().returnDataToParent((Object)true);
                this.getView().invokeOperation("close");
            } else {
                this.addErrorMessage(errorList);
            }
        } else if (HRStringUtils.equals((String)"position", (String)source.getKey())) {
            RsmService.openPositionF7Click((IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "position"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String closeActionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"position", (String)closeActionId)) {
            RsmService.selectedPositionClosedCallBack((IFormView)this.getView(), (Object)returnData);
        }
    }

    private void addErrorMessage(List<AssignPositionResult> errorList) {
        List<PositionAndAddressDto> rsmList = this.getPositionAndAddressDtos();
        StringBuilder errorMessage = new StringBuilder();
        rsmList.forEach(rsm -> errorList.forEach(error -> {
            if (rsm.getRsmID().longValue() == error.getRsmID()) {
                errorMessage.append(rsm.getRsmNumber());
                errorMessage.append(":");
                errorMessage.append(error.getMessage());
            }
        }));
        String title = ResManager.loadKDString((String)MessageFormat.format("\u5206\u914d\u804c\u4f4d,\u6210\u529f: {0}\u4efd\uff0c\u5931\u8d25: {1}\u4efd", rsmList.size() - errorList.size(), errorList.size()), (String)"AssignPositionEditPlugin_2", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)title, (Object)errorMessage.toString(), (boolean)true);
        this.getView().showForm(formShowParameter);
    }

    private List<AssignPositionResult> assignPosition(DynamicObject dataEntity, DynamicObject newPosition) {
        List<PositionAndAddressDto> rsmList = this.getPositionAndAddressDtos();
        ArrayList<Future> futureList = new ArrayList<Future>(rsmList.size());
        ArrayList<AssignPositionResult> errorList = new ArrayList<AssignPositionResult>(rsmList.size());
        for (PositionAndAddressDto rsm : rsmList) {
            rsm.setPositionId(Long.valueOf(newPosition.getLong("id")));
            Future future = assignPositionThreadPools.submit(() -> assignPositionHelper.appFileJudgmentRepetition(rsm.getRsmID(), Long.valueOf(newPosition.getLong("id"))));
            futureList.add(future);
        }
        this.insertAssignRule(dataEntity, newPosition);
        for (int i = 0; i < futureList.size(); ++i) {
            try {
                SaveCandidateResult saveCandidateResult = (SaveCandidateResult)((List)((Future)futureList.get(i)).get(6L, TimeUnit.SECONDS)).get(0);
                if (saveCandidateResult == null || saveCandidateResult.isSuccess()) continue;
                AssignPositionResult result = new AssignPositionResult(saveCandidateResult.getRsmId().longValue(), saveCandidateResult.getMessage());
                errorList.add(result);
                LOGGER.error("\u5206\u914d\u804c\u4f4d\u8c03\u7528\u5e94\u8058\u6863\u6848\u63a5\u53e3\uff1a\u5e94\u8058\u7b80\u5386ID\uff1a{},\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)result.getRsmID(), (Object)result.getMessage());
                continue;
            }
            catch (TimeoutException ex) {
                PositionAndAddressDto positionAndAddressDto = rsmList.get(i);
                AssignPositionResult result = new AssignPositionResult(positionAndAddressDto.getRsmID().longValue(), "\u5206\u914d\u804c\u4f4d\u8c03\u7528\u5e94\u8058\u6863\u6848\u63a5\u53e3\u8d85\u65f6");
                errorList.add(result);
                LOGGER.error("\u5206\u914d\u804c\u4f4d\u8c03\u7528\u5e94\u8058\u6863\u6848\u63a5\u53e3\u8d85\u65f6", (Throwable)ex);
                continue;
            }
            catch (Exception ex) {
                LOGGER.error("\u5206\u914d\u804c\u4f4d\u8c03\u7528\u5e94\u8058\u6863\u6848\u63a5\u53e3\u5f02\u5e38", (Throwable)ex);
                throw new KDException(new ErrorCode("", "\u5206\u914d\u804c\u4f4d\u8c03\u7528\u5e94\u8058\u6863\u6848\u63a5\u53e3\u5f02\u5e38"), new Object[0]);
            }
        }
        return errorList;
    }

    private List<PositionAndAddressDto> getPositionAndAddressDtos() {
        String assignLists = this.getPageCache().get("assignLists");
        return JSON.parseArray((String)assignLists, PositionAndAddressDto.class);
    }

    private void insertAssignRule(DynamicObject dataEntity, DynamicObject newPosition) {
        String rule = this.getPageCache().get("rule");
        if (HRStringUtils.isNotEmpty((String)rule) && dataEntity.getBoolean(KEY_CHECKBOXFIELD)) {
            RsmAssignRuleDto rsmAssignRuleDto = (RsmAssignRuleDto)JSON.parseObject((String)rule, RsmAssignRuleDto.class);
            rsmAssignRuleDto.setPositionId(Long.valueOf(newPosition.getLong("id")));
            LOGGER.info("\u65b0\u589e\u7b80\u5386\u5206\u914d\u89c4\u5219\u63a5\u53e3\u53c2\u6570\uff1a{}", (Object)rsmAssignRuleDto.toString());
            BizResult bizResult = assignPositionHelper.insertRsmAssignRule(rsmAssignRuleDto);
            LOGGER.info("\u65b0\u589e\u7b80\u5386\u5206\u914d\u89c4\u5219\u63a5\u53e3\uff1a\u804c\u4f4dID\uff1a{},\u662f\u5426\u6210\u529f:{},\u9519\u8bef\u539f\u56e0\uff1a{}", new Object[]{newPosition.getLong("id"), bizResult.getSuccess(), bizResult.getMessage()});
        }
    }
}

