/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.rsm.sr;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tstpm.common.enums.MainPageTypeEnum;

public class PreviewResumeEdit
extends HRDataBaseEdit {
    private static final String KEY_CACHE_PAGE_ID = "add_resume_pageId";

    public void registerListener(EventObject ee) {
        super.registerListener(ee);
        IFormView formView = this.getView();
        Button delBtn = (Button)formView.getControl("btn_delete");
        delBtn.addClickListener((ClickListener)this);
        Button exitBtn = (Button)formView.getControl("btn_exit");
        exitBtn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btn_delete": {
                this.getView().showConfirm(SrRsmKDString.preDelRsmTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_delete"));
                break;
            }
            case "btn_exit": {
                this.checkResumeDataChange();
                break;
            }
        }
    }

    private void checkResumeDataChange() {
        String rsmViewPageId = this.getPageCache().get(KEY_CACHE_PAGE_ID);
        IFormView rsmView = this.getView().getView(rsmViewPageId);
        if (null != rsmView) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("btn_exit", (IFormPlugin)this);
            if (!RsmHelper.showDataChangeForm((IFormView)rsmView, (IFormView)this.getView(), (ConfirmCallBackListener)confirmCallBackListener)) {
                this.exitOperation();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            switch (callBackId) {
                case "btn_delete": {
                    this.deleteResume();
                    break;
                }
                case "btn_exit": {
                    this.exitOperation();
                    break;
                }
            }
        }
    }

    private void deleteResume() {
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        String pageCacheId = showParameter.getCustomParams().get("pagecacheid").toString();
        String rowIndex = showParameter.getCustomParams().get("rowIndex").toString();
        String resumeStoAdd = showParameter.getCustomParams().get("resumestoadd").toString();
        HashMap<String, String> returnData = new HashMap<String, String>(4);
        returnData.put("resumestoadd", resumeStoAdd);
        returnData.put("rowIndex", rowIndex);
        returnData.put("pagecacheid", pageCacheId);
        returnData.put("btnsign", "btn_delete");
        view.returnDataToParent(returnData);
        view.close();
    }

    public void afterBindData(EventObject ee) {
        IFormView view = this.getView();
        Map requestData = view.getFormShowParameter().getCustomParams();
        if (requestData != null && requestData.size() != 0) {
            Tab tab = (Tab)view.getControl("tabap");
            tab.activeTab("tab_resume");
            this.loadResumeTabap();
            this.loadOriginalResumeTabap();
        }
    }

    public void afterCreateNewData(EventObject ee) {
        Map requestData = this.getView().getFormShowParameter().getCustomParams();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParams(requestData);
        parameter.setCustomParam("page_type", (Object)MainPageTypeEnum.PREVIEW_RSM.getType());
        parameter.setFormId("tstpm_head_template");
        OpenStyle openStyle = parameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("flex_head");
        this.getView().showForm(parameter);
    }

    private void loadResumeTabap() {
        IFormView formView = this.getView();
        String pageCacheId = formView.getFormShowParameter().getCustomParams().get("pagecacheid").toString();
        String resumeStr = formView.getParentView().getPageCache().get(pageCacheId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tstpm_srrsm");
        HashMap<String, String> returnData = new HashMap<String, String>(2);
        returnData.put("resume", resumeStr);
        returnData.put("dataSource", "1");
        showParameter.setCustomParams(returnData);
        showParameter.setStatus(OperationStatus.EDIT);
        Integer viewStatus = (Integer)formView.getFormShowParameter().getCustomParam("view");
        if (!HRObjectUtils.isEmpty((Object)viewStatus)) {
            showParameter.setStatus(OperationStatus.forValue((int)viewStatus));
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_delete"});
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("tab_resume");
        formView.showForm(showParameter);
        this.getPageCache().put(KEY_CACHE_PAGE_ID, showParameter.getPageId());
    }

    private void loadOriginalResumeTabap() {
        IFormView formView = this.getView();
        String resumeStoAdd = formView.getFormShowParameter().getCustomParams().get("resumestoadd").toString();
        FormShowParameter showOriginalParameter = new FormShowParameter();
        showOriginalParameter.setFormId("tstpm_originalresume");
        showOriginalParameter.setCustomParam("resumestoadd", (Object)resumeStoAdd);
        showOriginalParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showOriginalParameter.getOpenStyle().setTargetKey("tab_originalres");
        formView.showForm(showOriginalParameter);
    }

    private void exitOperation() {
        String pageCacheId;
        IFormView resView = this.getView().getView(this.getPageCache().get(KEY_CACHE_PAGE_ID));
        RsmService.resetRsmInfo((IFormView)resView);
        this.getView().sendFormAction(resView);
        Object rowIndex = this.getView().getFormShowParameter().getCustomParams().get("rowIndex");
        if (HRObjectUtils.isEmpty(rowIndex)) {
            this.getView().close();
            return;
        }
        IDataModel model = resView.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        dataEntity.set("photo", this.getModel().getDataEntity().get("photo"));
        IPageCache childPageCache = resView.getPageCache();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().close();
            return;
        }
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String resume = parentPageCache.get(pageCacheId = this.getView().getFormShowParameter().getCustomParams().get("pagecacheid").toString());
        if (HRStringUtils.isNotEmpty((String)resume)) {
            AppResumeBo resumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)resume);
            resumeBo.setRsm(dataEntity);
            List eduExpList = ResumeUtilsHelper.deserializeDynamicObject((IPageCache)childPageCache, (String)"tstpm_srrsmeduexp");
            List workExpList = ResumeUtilsHelper.deserializeDynamicObject((IPageCache)childPageCache, (String)"tstpm_srrsmworkexp");
            List prjExpList = ResumeUtilsHelper.deserializeDynamicObject((IPageCache)childPageCache, (String)"tstpm_srrsmprjexp");
            resumeBo.setEntry("tstpm_srrsmeduexp", eduExpList);
            resumeBo.setEntry("tstpm_srrsmworkexp", workExpList);
            resumeBo.setEntry("tstpm_srrsmprjexp", prjExpList);
            String resumeStr = SerializationUtils.serializeToBase64((Object)resumeBo);
            parentPageCache.put(pageCacheId, resumeStr);
        }
        HashMap returnData = new HashMap(4);
        returnData.put("rowIndex", rowIndex);
        returnData.put("pagecacheid", pageCacheId);
        returnData.put("btnsign", "btn_exit");
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

