/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.rsm.sr;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmEduExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmLangAblHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmPrjExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmWorkExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmWorkRelHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.service.PreRsmService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tstpm.formplugin.web.rsm.sr.RsmCompleteEdit;

public class RsmExpList
extends HRDataBaseList {
    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"lbl_edit", "lbl_delete"});
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Label) {
            Label lbl = (Label)evt.getSource();
            String key = lbl.getKey();
            ListView listView = (ListView)lbl.getView();
            String billFormId = listView.getBillFormId();
            long pkId = (Long)listView.getSelectedRows().getPrimaryKeyValues()[0];
            switch (key) {
                case "lbl_edit": {
                    this.showRsmExpEditForm(billFormId, pkId);
                    break;
                }
                case "lbl_delete": {
                    this.handlerDeleteRsmExp(billFormId, pkId);
                    break;
                }
            }
        }
    }

    private void handlerDeleteRsmExp(String billFormId, long pkId) {
        if (RsmHelper.rsmExpValidCanEdit((long)pkId, (String)billFormId, (IFormView)this.getView())) {
            RsmHelper.showConfirmDeleteRsmExp((String)billFormId, (IFormView)this.getView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("lbl_delete".equals(operateKey) || "lbl_edit".equals(operateKey)) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            String billFormId = messageBoxClosedEvent.getCallBackId();
            ListSelectedRow currentSelectRow = this.getSelectedRows().get(0);
            Long eduId = (Long)currentSelectRow.getPrimaryKeyValue();
            Long rsmId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("rsm_id"));
            String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
            IPageCache pageCache = this.getView().getParentView().getPageCache();
            switch (billFormId) {
                case "tstpm_srrsmworkrela": {
                    RsmWorkRelHelper.deleteWorkRel((IPageCache)pageCache, (Long)eduId, (Long)rsmId, (String)dataSource);
                    this.refreshAppFile();
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "tstpm_srrsmeduexp": {
                    RsmEduExpHelper.deleteEduExp((IPageCache)pageCache, (Long)eduId, (Long)rsmId, (String)dataSource);
                    this.refreshAppFile();
                    PreRsmService.refreshPreViewOfEdu((IFormView)this.getView().getParentView(), (IDataModel)this.getView().getParentView().getModel());
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "tstpm_srrsmlangabl": {
                    RsmLangAblHelper.deleteLangAbl((IPageCache)pageCache, (Long)eduId, (Long)rsmId, (String)dataSource);
                    this.refreshAppFile();
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "tstpm_srrsmworkexp": {
                    RsmWorkExpHelper.deleteWorkExp((IPageCache)pageCache, (Long)eduId, (Long)rsmId, (String)dataSource);
                    this.refreshAppFile();
                    PreRsmService.refreshPreViewOfWork((IFormView)this.getView().getParentView(), (IDataModel)this.getView().getParentView().getModel());
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "tstpm_srrsmprjexp": {
                    RsmPrjExpHelper.deletePrjExp((IPageCache)pageCache, (Long)eduId, (Long)rsmId, (String)dataSource);
                    this.refreshAppFile();
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
            if (!"1".equals(dataSource)) {
                RsmCommonHelper.outTransaction((long)rsmId, (Boolean)true);
            }
        }
    }

    private void refreshAppFile() {
        IFormView view = this.getView().getParentView().getParentView();
        boolean tssrmAppfileView = view.getEntityId().startsWith("tssrm_appfile_view");
        if (tssrmAppfileView) {
            long rsmId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
            DynamicObject rsmDy = RsmHelper.findOne((long)rsmId);
            RsmService.refreshAppFileHeader((DynamicObject)rsmDy, (IFormView)view, (IFormView)this.getView());
            this.getView().sendFormAction(view);
        }
    }

    private void showRsmExpEditForm(String billFormId, long pkId) {
        if (RsmHelper.rsmExpValidCanEdit((long)pkId, (String)billFormId, (IFormView)this.getView())) {
            BaseShowParameter baseFormShowParameter = FormShowHelper.createBaseFormShowParameter((String)billFormId, null, (ShowType)ShowType.Modal, null);
            IFormView formView = this.getView();
            FormShowParameter showParameter = formView.getFormShowParameter();
            String dataSource = (String)showParameter.getCustomParam("dataSource");
            if ("1".equals(dataSource)) {
                baseFormShowParameter.setCustomParam("pkId", (Object)pkId);
            } else {
                baseFormShowParameter.setPkId((Object)pkId);
            }
            baseFormShowParameter.setCustomParam("dataSource", (Object)dataSource);
            baseFormShowParameter.setCustomParam("rsm_id", showParameter.getCustomParam("rsm_id"));
            baseFormShowParameter.setStatus(OperationStatus.EDIT);
            baseFormShowParameter.setCloseCallBack(new CloseCallBack(RsmCompleteEdit.class.getName(), billFormId));
            formView.getParentView().showForm((FormShowParameter)baseFormShowParameter);
            formView.sendFormAction(this.getView().getParentView());
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        setFilterEvent.addCustomQFilter(new QFilter("id", "=", (Object)-1));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new CusListDataProvider());
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        RsmHelper.rsmExpListPackageData((PackageDataEvent)packageDataEvent, (IFormView)this.getView());
    }

    class CusListDataProvider
    extends ListDataProvider {
        CusListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            List cacheData;
            String entityName = this.getEntityType().getName();
            Long rsmId = Long.parseLong((String)RsmExpList.this.getView().getFormShowParameter().getCustomParam("rsm_id"));
            List expSorts = RsmCommonHelper.getAllExpSortList((Long)rsmId, (List)(cacheData = ResumeUtilsHelper.deserializeDynamicObject((IPageCache)RsmExpList.this.getView().getParentView().getPageCache(), (String)entityName)), (String)entityName);
            if (!expSorts.isEmpty()) {
                DynamicObjectCollection cacheDataColl = super.getData(start, limit);
                this.registerProperty(cacheDataColl, entityName);
                for (DynamicObject dy : expSorts) {
                    this.setRowFieldValue(cacheDataColl, dy);
                }
                return cacheDataColl;
            }
            return super.getData(start, limit);
        }

        private void setRowFieldValue(DynamicObjectCollection cacheDataColl, DynamicObject dy) {
            DynamicObject row = cacheDataColl.addNew();
            DataEntityPropertyCollection depc = row.getDataEntityType().getProperties();
            for (IDataEntityProperty dep : depc) {
                Object value;
                String propName = dep.getName();
                if ("fseq".equals(propName) || (value = dy.get(propName)) == null) continue;
                row.set(dep.getName(), value);
            }
        }

        private void registerProperty(DynamicObjectCollection cacheDataColl, String entityName) {
            switch (entityName) {
                case "tstpm_srrsmeduexp": {
                    cacheDataColl.getDynamicObjectType().registerProperty("showlengthofstudy", String.class, (Object)"", false);
                    break;
                }
                case "tstpm_srrsmworkexp": {
                    cacheDataColl.getDynamicObjectType().registerProperty("showlengthofwork", String.class, (Object)"", false);
                    break;
                }
                case "tstpm_srrsmprjexp": {
                    cacheDataColl.getDynamicObjectType().registerProperty("showprojectduration", String.class, (Object)"", false);
                    break;
                }
            }
        }
    }
}

