/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.formplugin.web.rsm.sr.unallocate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.entity.label.AiInsightParamEntity;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbs.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tstpm.business.domain.rsm.sr.helper.AssignPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.unallocate.UnAllocateRsmHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.ResumeFormHelper;
import kd.tsc.tstpm.common.enums.MainPageTypeEnum;

public class UnAllocateRsmEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(UnAllocateRsmEdit.class);
    public static final String KEY_TABORIGINRSM = "taboriginrsm";
    private static final String KEY_ORIGINRESFLEX = "originresflex";
    private static final String KEY_LBLJOBSTATUS = "lbljobstatus";
    private static final String KEY_IMGSTDRSM = "imgstdrsm";
    private static final String KEY_BLACKLISTICON = "blacklisticon";
    private static final String KEY_ALLOCATEPOS = "allocatepos";
    private static final String CURR_PRJ_NAME = "tsc-tstpm-formplugin";

    public void preOpenForm(PreOpenFormEventArgs ee) {
        BillShowParameter showParameter = (BillShowParameter)ee.getFormShowParameter();
        Object pkId = showParameter.getPkId();
        if (pkId != null) {
            long rsmId = Long.parseLong(pkId.toString());
            Map stdRsmStatusMap = UnAllocateRsmHelper.getStdRsmStatusMap((List)Lists.newArrayList((Object[])new Long[]{rsmId}));
            if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(stdRsmStatusMap.get(rsmId))) {
                ee.setCancel(true);
                ee.setCancelMessage(TSCBaseKDString.dataChangedTip());
            }
        }
        showParameter.setCaption(ResManager.loadKDString((String)"\u6e20\u9053\u7b80\u5386\u67e5\u770b", (String)"UnAllocateRsmEdit_0", (String)CURR_PRJ_NAME, (Object[])new Object[0]));
        showParameter.setStatus(OperationStatus.VIEW);
    }

    public void registerListener(EventObject ee) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source;
        if (args.getSource() instanceof FormOperate && "discardpos".equals((source = (FormOperate)args.getSource()).getOperateKey())) {
            boolean isRsmDelete = this.isRsmDelete();
            args.setCancel(isRsmDelete);
        }
    }

    public void afterBindData(EventObject ee) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        logger.info("afterBindData.appRes:{}", (Object)HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dataEntity));
        logger.info("afterBindData.showParameter:{}", (Object)this.getView().getFormShowParameter());
        HashMap customMap = Maps.newHashMapWithExpectedSize((int)16);
        customMap.put("id", dataEntity.get("id"));
        customMap.put("stdrsm", dataEntity.getLong("stdrsm"));
        customMap.put("applyposition", dataEntity.get("delivery.postposition"));
        customMap.put("applyposition.id", dataEntity.get("delivery.postposition"));
        customMap.put("page_type", MainPageTypeEnum.UN_ALLOCATE.getType());
        FormShowParameter parameter = ResumeFormHelper.openFormInContainer((Map)customMap, (String)"tstpm_head_template", (String)"flex_head");
        this.getView().showForm(parameter);
        AiInsightParamEntity aiInsightParamEntity = new AiInsightParamEntity();
        aiInsightParamEntity.setAppRsmId(Long.valueOf(dataEntity.getLong("id")));
        aiInsightParamEntity.setTargetKey("flexpanelap5");
        aiInsightParamEntity.setTypeId(LabelTagObjTypeEnum.OUT_RESUME.getId());
        aiInsightParamEntity.setShowMyLabel(Boolean.valueOf(false));
        aiInsightParamEntity.setCanEditLabel(Boolean.valueOf(false));
        aiInsightParamEntity.setFold(Boolean.valueOf(false));
        LabelDataHelper.showAppRsmDefaultLabelPage((IFormView)this.getView(), (AiInsightParamEntity)aiInsightParamEntity);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(KEY_IMGSTDRSM)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
            long stdRsmId = this.getView().getModel().getDataEntity().getLong("stdrsm");
            DynamicObject stdRsm = helper.queryOne((Object)stdRsmId);
            if (stdRsm != null) {
                Long mainId = stdRsm.getLong("mid");
                StdRsmCommonService.getInstance().showStandardResumePage((AbstractFormPlugin)this, mainId);
            }
        } else if (key.equals(KEY_BLACKLISTICON)) {
            UnAllocateRsmHelper.showBlackListDetailPage((Long)this.getModel().getDataEntity().getLong("id"), (IFormView)this.getView());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (KEY_ALLOCATEPOS.equals(itemKey) || "discardpos".equals(itemKey)) {
            boolean isRsmDelete = this.isRsmDelete();
            evt.setCancel(isRsmDelete);
        }
    }

    private boolean isRsmDelete() {
        boolean isRsmDelete = UnAllocateRsmHelper.validateIsRsmDelete(Collections.singletonList(this.getModel().getDataEntity().getLong("id")), (IFormView)this.getView().getMainView(), (String)UnAllocateRsmHelper.getStdRsmChangeTip());
        if (isRsmDelete) {
            this.getView().sendFormAction(this.getView().getMainView());
            this.getView().close();
        }
        return isRsmDelete;
    }

    public void itemClick(ItemClickEvent evt) {
        if (KEY_ALLOCATEPOS.equals(evt.getItemKey())) {
            boolean checkPermission = AssignPositionHelper.checkPermission((String)"tstpm", (String)"tstpm_rsm_unallocated", (String)"2/52S4X1O0ZK");
            if (!checkPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u5206\u914d\u7b80\u5386\u201d\u7684\u201c\u5206\u914d\u804c\u4f4d\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"UnAllocateRsmEdit_2", (String)CURR_PRJ_NAME, (Object[])new Object[0]));
                return;
            }
            this.assignPosition();
        }
    }

    private void assignPosition() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Long rsmID = dataEntity.getLong("id");
        List<Long> rsmIDList = Collections.singletonList(rsmID);
        UnAllocateRsmHelper.assignPosition(rsmIDList, (AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("tstpm_assignposition".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null && ((Boolean)returnData).booleanValue()) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u804c\u4f4d\u6210\u529f\u3002", (String)"UnAllocateRsmEdit_1", (String)"tsc-tstpm-business", (Object[])new Object[0]));
                    parentView.invokeOperation("refresh");
                }
                this.getView().close();
            }
            return;
        }
        UnAllocateRsmHelper.handleClosedCallback((AbstractFormPlugin)this, (ClosedCallBackEvent)closedCallBackEvent);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("savetalent".equals(afterDoOperationEventArgs.getOperateKey())) {
            ArrayList selectPkIds = Lists.newArrayList((Object[])new Long[]{this.getView().getModel().getDataEntity().getLong("id")});
            String pageNumber = this.getView().getEntityId();
            UnAllocateRsmHelper.validateTalentRight((AbstractFormPlugin)this, (List)selectPkIds, (String)pageNumber, (String)"savetalent");
        } else if ("discardpos".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            IFormView parentView = this.getView().getParentView();
            if (parentView instanceof ListView) {
                ((ListView)parentView).refresh();
                Donothing operate = (Donothing)afterDoOperationEventArgs.getSource();
                parentView.showSuccessNotification(operate.getSuccessMsg().getLocaleValue());
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }
}

